/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.entities.ally;

import com.Polarice3.Goety.api.entities.IGolem;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModTicketTypes;
import com.Polarice3.Goety.utils.ServantUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface IServant
extends IOwned {
    public static final int GUARDING_RANGE = (Integer)MobsConfig.ServantGuardingRange.get();

    public boolean isWandering();

    public void setWandering(boolean var1);

    public boolean isStaying();

    public void setStaying(boolean var1);

    default public boolean canWander() {
        return true;
    }

    default public boolean canStay() {
        return true;
    }

    default public boolean isGuardingArea() {
        IServant iServant = this;
        if (iServant instanceof Entity) {
            Entity entity = (Entity)iServant;
            if (entity.f_19853_.m_46472_() != this.getBoundLevel()) {
                return false;
            }
        }
        return this.getBoundPos() != null;
    }

    default public boolean canGuardArea() {
        return true;
    }

    default public BlockPos getBoundPos() {
        return null;
    }

    default public Vec3 vec3BoundPos() {
        return Vec3.m_82539_((Vec3i)this.getBoundPos());
    }

    default public void setBoundPos(BlockPos blockPos) {
        IServant iServant = this;
        if (iServant instanceof Entity) {
            Entity entity = (Entity)iServant;
            this.setBoundDim((ResourceKey<Level>)entity.f_19853_.m_46472_());
        }
    }

    default public ResourceKey<Level> getBoundLevel() {
        ResourceLocation resourcelocation = new ResourceLocation(this.getBoundDim());
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)resourcelocation);
    }

    default public String getBoundDim() {
        return Level.f_46428_.m_135782_().toString();
    }

    default public void setBoundDim(ResourceKey<Level> resourceKey) {
        this.setBoundDim(resourceKey.m_135782_().toString());
    }

    default public void setBoundDim(String string) {
    }

    default public boolean isWithinGuard(BlockPos p_21445_) {
        if (this.getBoundPos() == null) {
            return true;
        }
        return this.getBoundPos().m_123331_((Vec3i)p_21445_) < (double)Mth.m_144944_((int)GUARDING_RANGE);
    }

    @Nullable
    default public LivingEntity getPriorityTarget() {
        return null;
    }

    default public void setPriorityTarget(@Nullable LivingEntity target) {
        this.overrideSetTarget(target);
    }

    default public void overrideSetTarget(@Nullable LivingEntity target) {
    }

    default public void setFollowing() {
        this.setBoundPos(null);
        this.setWandering(false);
        this.setStaying(false);
    }

    default public boolean isFollowing() {
        return !this.isWandering() && !this.isStaying() && !this.isGuardingArea() && this.canFollow();
    }

    default public boolean canFollow() {
        return true;
    }

    default public void spawnUpgraded() {
        IServant iServant = this;
        if (iServant instanceof Mob) {
            Mob mob = (Mob)iServant;
            if (mob.m_6336_() == MobType.f_21641_) {
                this.setUpgraded(CuriosFinder.hasUndeadCape(this.getTrueOwner()));
            } else if (mob.m_6336_() == ModMobType.NATURAL || mob.m_6336_() == MobType.f_21642_) {
                this.setUpgraded(CuriosFinder.hasWildRobe(this.getTrueOwner()));
            } else if (mob.m_6336_() == ModMobType.FROST) {
                this.setUpgraded(CuriosFinder.hasFrostRobes(this.getTrueOwner()));
            } else if (mob.m_6336_() == MobType.f_21644_) {
                this.setUpgraded(CuriosFinder.hasAbyssRobes(this.getTrueOwner()));
            }
        }
    }

    public boolean canUpdateMove();

    default public void updateMoveMode(Player player) {
        IServant iServant = this;
        if (iServant instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)iServant;
            boolean flag = false;
            if (!this.isWandering() && !this.isStaying() && !this.isGuardingArea() && this.canWander()) {
                this.setBoundPos(null);
                this.setWandering(true);
                this.setStaying(false);
                player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.wander", (Object[])new Object[]{living.m_5446_()}), true);
                flag = true;
            } else if (!this.isStaying() && !this.isGuardingArea() && this.canStay()) {
                this.setBoundPos(null);
                this.setWandering(false);
                this.setStaying(true);
                player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.staying", (Object[])new Object[]{living.m_5446_()}), true);
                flag = true;
            } else if (!this.isGuardingArea() && this.canGuardArea()) {
                this.setBoundPos(living.m_20183_());
                this.setWandering(false);
                this.setStaying(false);
                player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.guard", (Object[])new Object[]{living.m_5446_()}), true);
                flag = true;
            } else if (this.canFollow()) {
                this.setBoundPos(null);
                this.setWandering(false);
                this.setStaying(false);
                player.m_5661_((Component)Component.m_237110_((String)"info.goety.servant.follow", (Object[])new Object[]{living.m_5446_()}), true);
                flag = true;
            }
            if (flag) {
                living.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
            }
        }
    }

    default public boolean canBeCommanded() {
        return true;
    }

    public boolean isCommanded();

    default public boolean canCommandToBlock(Level level, BlockPos blockPos) {
        return !level.m_8055_(blockPos).m_60804_((BlockGetter)level, blockPos);
    }

    default public void setCommandPos(BlockPos blockPos) {
        this.setCommandPos(blockPos, true);
    }

    default public BlockPos getCommandPos() {
        return null;
    }

    default public void setCommandPos(BlockPos blockPos, boolean removeEntity) {
        if (removeEntity) {
            this.setCommandPosEntity(null);
        }
        this.setCommandPos(blockPos);
        this.setCommandTick(MathHelper.secondsToTicks(10));
    }

    default public void setCommandPosEntityOrder(LivingEntity living) {
        this.setCommandPosEntity(living);
    }

    public void setCommandPosEntity(LivingEntity var1);

    @Nullable
    default public LivingEntity getCommandPosEntity() {
        return null;
    }

    default public int getCommandTick() {
        return 0;
    }

    default public void setCommandTick(int time) {
    }

    default public int getNoHealTime() {
        return 0;
    }

    default public void setNoHealTime(int time) {
    }

    default public int getKillChance() {
        return 0;
    }

    default public void setKillChance(int time) {
    }

    public void tryKill(Player var1);

    default public boolean isUpgraded() {
        return false;
    }

    default public void setUpgraded(boolean upgraded) {
    }

    default public boolean servantSunBurn() {
        return false;
    }

    default public boolean burnSunTick() {
        IServant iServant = this;
        if (iServant instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)iServant;
            if (living.f_19853_.m_46461_() && !living.f_19853_.f_46443_) {
                float f = living.m_213856_();
                BlockPos blockpos = BlockPos.m_274561_((double)living.m_20185_(), (double)living.m_20188_(), (double)living.m_20189_());
                boolean flag = living.m_20071_() || living.f_146808_ || living.f_146809_;
                return f > 0.5f && living.m_217043_().m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !flag && living.f_19853_.m_45527_(blockpos);
            }
        }
        return false;
    }

    default public boolean isAbleToRide(LivingEntity livingEntity) {
        if (!(this instanceof PlayerRideable) && !(this instanceof IGolem) && (livingEntity instanceof PlayerRideable || livingEntity.m_6095_().m_204039_(ModTags.EntityTypes.SERVANT_RIDEABLE)) && livingEntity.m_146895_() == null) {
            if (livingEntity instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)livingEntity;
                return horse.m_30614_();
            }
            if (MobUtil.getOwner((Entity)livingEntity) != null) {
                return MobUtil.getOwner((Entity)livingEntity) == this.getTrueOwner();
            }
        }
        if (livingEntity instanceof IServant) {
            IServant servant = (IServant)livingEntity;
            IServant iServant = this;
            if (iServant instanceof LivingEntity) {
                LivingEntity rider = (LivingEntity)iServant;
                return servant.canBeRidden(rider);
            }
        }
        return false;
    }

    @Deprecated
    default public boolean canRide(LivingEntity livingEntity) {
        return this.isAbleToRide(livingEntity);
    }

    default public boolean canBeRidden(LivingEntity livingEntity) {
        return false;
    }

    default public void servantTick() {
        IServant iServant = this;
        if (iServant instanceof Mob) {
            Mob owned = (Mob)iServant;
            this.stayingMode();
            if (this.getKillChance() > 0) {
                this.setKillChance(this.getKillChance() - 1);
            }
            if (owned.m_6084_()) {
                this.chunkLoad();
            }
            this.commandMode();
            if ((this.isWandering() || this.isGuardingArea()) && this.isStaying()) {
                this.setStaying(false);
            }
            if (this.isGuardingArea()) {
                if (owned.m_5448_() != null) {
                    if (owned.m_5448_() != this.getPriorityTarget() && owned.m_5448_().m_20238_(this.vec3BoundPos()) > (double)Mth.m_144944_((int)(GUARDING_RANGE * 2))) {
                        owned.m_6710_(null);
                        if (!this.isCommanded()) {
                            owned.m_21573_().m_26519_((double)this.getBoundPos().m_123341_(), (double)this.getBoundPos().m_123342_(), (double)this.getBoundPos().m_123343_(), 1.0);
                        }
                    }
                } else if (!this.isCommanded() && owned.m_20238_(this.vec3BoundPos()) > (double)Mth.m_144944_((int)GUARDING_RANGE)) {
                    owned.m_21573_().m_26519_((double)this.getBoundPos().m_123341_(), (double)this.getBoundPos().m_123342_(), (double)this.getBoundPos().m_123343_(), 1.0);
                }
            }
            if (this.getPriorityTarget() != null && !this.getPriorityTarget().m_6084_()) {
                this.setPriorityTarget(null);
            }
            if (this.getNoHealTime() <= 0) {
                this.healServant();
            } else {
                this.setNoHealTime(this.getNoHealTime() - 1);
            }
            this.burnServant((LivingEntity)owned);
        }
    }

    default public long getTicketTime() {
        return 0L;
    }

    default public void setTicketTime(long time) {
    }

    default public long decreaseTicketTime() {
        long ticket = this.getTicketTime() - 1L;
        this.setTicketTime(ticket);
        return ticket;
    }

    default public boolean shouldChunkLoad() {
        if (this.isStaying()) {
            return (Boolean)MobsConfig.StayingServantChunkLoad.get();
        }
        if (this.isGuardingArea()) {
            return (Boolean)MobsConfig.GuardingServantChunkLoad.get();
        }
        if (this.isFollowing()) {
            return (Boolean)MobsConfig.FollowingServantChunkLoad.get();
        }
        return false;
    }

    default public void chunkLoad() {
        IServant iServant = this;
        if (iServant instanceof Mob) {
            Mob owned = (Mob)iServant;
            Level level = owned.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.shouldChunkLoad()) {
                    if (this.getTrueOwner() instanceof Player) {
                        int i = SectionPos.m_235865_((double)owned.m_20182_().m_7096_());
                        int j = SectionPos.m_235865_((double)owned.m_20182_().m_7094_());
                        BlockPos blockPos = BlockPos.m_274446_((Position)owned.m_20182_());
                        if (this.decreaseTicketTime() <= 0L || i != SectionPos.m_123171_((int)blockPos.m_123341_()) || j != SectionPos.m_123171_((int)blockPos.m_123343_())) {
                            serverLevel.m_7726_().m_8387_(ModTicketTypes.SERVANT, owned.m_146902_(), 2, (Object)owned.m_20183_());
                            serverLevel.m_8886_();
                            this.setTicketTime(ModTicketTypes.SERVANT.m_9469_() - 1L);
                        }
                    }
                } else if (this.getTicketTime() > 0L) {
                    this.setTicketTime(0L);
                }
            }
        }
    }

    default public void forceChunkLoadSelf() {
        IServant iServant = this;
        if (iServant instanceof Mob) {
            Mob owned = (Mob)iServant;
            Level level = owned.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8387_(ModTicketTypes.SERVANT, owned.m_146902_(), 2, (Object)owned.m_20183_());
                serverLevel.m_8886_();
            }
        }
    }

    default public void chunkLoadTarget(BlockPos blockPos) {
        IServant iServant;
        if (blockPos != null && (iServant = this) instanceof Mob) {
            Mob owned = (Mob)iServant;
            Level level = owned.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.shouldChunkLoad() && this.getTrueOwner() instanceof Player) {
                    int i = SectionPos.m_123171_((int)blockPos.m_123341_());
                    int j = SectionPos.m_123171_((int)blockPos.m_123343_());
                    if (this.getTicketTime() <= 0L || i != SectionPos.m_123171_((int)blockPos.m_123341_()) || j != SectionPos.m_123171_((int)blockPos.m_123343_())) {
                        serverLevel.m_7726_().m_8387_(ModTicketTypes.SERVANT, new ChunkPos(blockPos), 9, (Object)blockPos);
                        serverLevel.m_8886_();
                    }
                }
            }
        }
    }

    default public void healServant() {
        IServant iServant = this;
        if (iServant instanceof LivingEntity) {
            LivingEntity self = (LivingEntity)iServant;
            if (this.getTrueOwner() != null) {
                boolean crown = false;
                if (ServantUtil.isFrostHeal(self)) {
                    crown = CuriosFinder.hasFrostCrown(this.getTrueOwner());
                }
                if (ServantUtil.isWildHeal(self)) {
                    crown = CuriosFinder.hasWildCrown(this.getTrueOwner());
                }
                if (ServantUtil.isNetherHeal(self)) {
                    crown = CuriosFinder.hasNetherCrown(this.getTrueOwner());
                }
                if (ServantUtil.isNecroHeal(self)) {
                    crown = CuriosFinder.hasUndeadCrown(this.getTrueOwner());
                }
                if (ServantUtil.isAbyssHeal(self)) {
                    crown = CuriosFinder.hasAbyssCrown(this.getTrueOwner());
                }
                if (ServantUtil.isVoidHeal(self)) {
                    crown = CuriosFinder.hasVoidCrown(this.getTrueOwner());
                }
                if (!crown) {
                    if (this.getLifespan() > 0) {
                        this.setHasLifespan(true);
                    }
                } else {
                    this.setHasLifespan(false);
                }
                if (!(self.f_19853_.f_46443_ || this.hasLifespan() && this.getLifespan() <= 20)) {
                    ServantUtil.healServant(this.getTrueOwner(), self);
                }
            }
        }
    }

    default public void burnServant(LivingEntity livingEntity) {
        boolean flag;
        boolean bl = flag = this.servantSunBurn() && this.burnSunTick() && !livingEntity.m_5825_() && (Boolean)MobsConfig.UndeadServantSunlightBurn.get() != false;
        if (flag) {
            ItemStack itemstack = livingEntity.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_() && ((Boolean)MobsConfig.UndeadServantSunlightHelmet.get()).booleanValue()) {
                    itemstack.m_41721_(itemstack.m_41773_() + livingEntity.m_217043_().m_188503_(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        livingEntity.m_21166_(EquipmentSlot.HEAD);
                        livingEntity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                livingEntity.m_20254_(8);
            }
        }
    }

    default public double getCommandSpeed() {
        return 1.25;
    }

    default public void commandMode() {
        IServant iServant = this;
        if (iServant instanceof Mob) {
            Mob owned = (Mob)iServant;
            if (this.isCommanded()) {
                if (owned.m_21573_().m_6342_(this.getCommandPos()) || this.getCommandPosEntity() != null) {
                    this.setCommandTick(this.getCommandTick() - 1);
                    if (this.getCommandPosEntity() != null) {
                        owned.m_21573_().m_5624_((Entity)this.getCommandPosEntity(), this.getCommandSpeed());
                    } else {
                        owned.m_21573_().m_26519_((double)this.getCommandPos().m_123341_() + 0.5, (double)this.getCommandPos().m_123342_(), (double)this.getCommandPos().m_123343_() + 0.5, this.getCommandSpeed());
                    }
                    if (owned.m_21573_().m_26577_() || this.getCommandTick() <= 0) {
                        this.setCommandPosEntity(null);
                        this.setCommandPos(null);
                    } else if (this.getCommandPos().m_203195_((Position)(owned.m_275832_() != null ? owned.m_275832_().m_20182_() : owned.m_20182_()), owned.m_275832_() != null ? (double)owned.m_275832_().m_20205_() + 1.0 : (double)owned.m_20205_() + 1.0)) {
                        if (this.getCommandPosEntity() != null && owned.m_20191_().m_82400_(1.25).m_82381_(this.getCommandPosEntity().m_20191_())) {
                            LivingEntity livingEntity;
                            if (this.isAbleToRide(this.getCommandPosEntity()) && owned.m_20329_((Entity)this.getCommandPosEntity()) && (livingEntity = this.getTrueOwner()) instanceof Player) {
                                Player player = (Player)livingEntity;
                                player.m_5661_((Component)Component.m_237115_((String)"info.goety.servant.dismount"), true);
                            }
                            this.setCommandPosEntity(null);
                        }
                        if (this.isGuardingArea()) {
                            this.setBoundPos(this.getCommandPos());
                        }
                        owned.m_21573_().m_26573_();
                        owned.m_21566_().m_24988_(0.0f, 0.0f);
                        owned.m_20035_(this.getCommandPos(), owned.m_146908_(), owned.m_146909_());
                        this.setCommandPos(null);
                    }
                } else {
                    this.setCommandPos(null);
                }
            }
        }
    }

    default public void stayingMode() {
        Mob owned;
        AttributeInstance modifiableattributeinstance;
        IServant iServant = this;
        if (iServant instanceof Mob && (modifiableattributeinstance = (owned = (Mob)iServant).m_21051_(Attributes.f_22279_)) != null) {
            if (this.isStaying()) {
                if (owned.m_21573_().m_26570_() != null) {
                    owned.m_21573_().m_26573_();
                }
                if (owned.m_21051_(Attributes.f_22279_) != null) {
                    modifiableattributeinstance.m_22130_(SPEED_MODIFIER);
                    modifiableattributeinstance.m_22118_(SPEED_MODIFIER);
                }
                this.stayingPosition();
                if (this.isWandering()) {
                    this.setWandering(false);
                }
            } else if (modifiableattributeinstance.m_22109_(SPEED_MODIFIER)) {
                modifiableattributeinstance.m_22130_(SPEED_MODIFIER);
            }
        }
    }

    default public void stayingPosition() {
        Mob owned;
        IServant iServant = this;
        if (iServant instanceof Mob && (owned = (Mob)iServant).m_5448_() != null) {
            owned.m_21563_().m_24960_((Entity)owned.m_5448_(), (float)owned.m_8085_(), (float)owned.m_8132_());
            double d2 = owned.m_5448_().m_20185_() - owned.m_20185_();
            double d1 = owned.m_5448_().m_20189_() - owned.m_20189_();
            owned.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
            owned.f_20883_ = owned.m_146908_();
        }
    }

    default public void readServantData(CompoundTag compound) {
        if (compound.m_128441_("Upgraded")) {
            this.setUpgraded(compound.m_128471_("Upgraded"));
        }
        if (compound.m_128441_("wandering")) {
            this.setWandering(compound.m_128471_("wandering"));
        }
        if (compound.m_128441_("staying")) {
            this.setStaying(compound.m_128471_("staying"));
        }
        if (compound.m_128441_("commandPos")) {
            this.setCommandPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("commandPos")));
        }
        if (compound.m_128441_("commandPosEntity") && EntityFinder.getLivingEntityByUuiD(compound.m_128342_("commandPosEntity")) != null) {
            this.setCommandPosEntity(EntityFinder.getLivingEntityByUuiD(compound.m_128342_("commandPosEntity")));
        }
        if (compound.m_128441_("boundPos")) {
            this.setBoundPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("boundPos")));
            if (compound.m_128441_("boundDim")) {
                this.setBoundDim(compound.m_128461_("boundDim"));
            } else {
                IServant iServant = this;
                if (iServant instanceof Entity) {
                    Entity entity = (Entity)iServant;
                    this.setBoundDim((ResourceKey<Level>)entity.f_19853_.m_46472_());
                }
            }
        }
        if (compound.m_128441_("noHealTime")) {
            this.setNoHealTime(compound.m_128451_("noHealTime"));
        }
    }

    default public void saveServantData(CompoundTag compound) {
        compound.m_128379_("Upgraded", this.isUpgraded());
        compound.m_128379_("wandering", this.isWandering());
        compound.m_128379_("staying", this.isStaying());
        if (this.getCommandPos() != null) {
            compound.m_128365_("commandPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getCommandPos()));
        }
        if (this.getCommandPosEntity() != null) {
            compound.m_128362_("commandPosEntity", this.getCommandPosEntity().m_20148_());
        }
        compound.m_128405_("commandTick", this.getCommandTick());
        if (this.getBoundPos() != null) {
            compound.m_128365_("boundPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getBoundPos()));
            compound.m_128359_("boundDim", this.getBoundDim());
        }
        compound.m_128405_("noHealTime", this.getNoHealTime());
    }
}

