/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.TrainingBlockEntity;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.spider.SpiderServant;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;

public class SpiderNestBlockEntity
extends TrainingBlockEntity {
    public SpiderNestBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SPIDER_NEST.get(), p_155229_, p_155230_);
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        super.tick(level, blockPos, blockState, blockEntity);
        if (this.isTraining()) {
            if (this.trainTime != this.getMaxTrainTime()) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (level.f_46441_.m_188503_(10) == 0) {
                        ServerParticleUtil.blockBreakParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), blockPos, blockState, serverLevel);
                    }
                }
                if (this.trainTime == 20) {
                    level.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SPIDER_NEST_TRAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (level.f_46441_.m_188503_(10) == 0) {
                    double d0 = (double)this.f_58858_.m_123341_() + level.f_46441_.m_188500_();
                    double d1 = (double)this.f_58858_.m_123342_() + level.f_46441_.m_188500_();
                    double d2 = (double)this.f_58858_.m_123343_() + level.f_46441_.m_188500_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void setVariant(ItemStack itemStack, Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (BlockFinder.findStructure(serverLevel, blockPos, ModTags.Structures.CRYPT) || this.getBlocks(blockState -> blockState.m_60713_(Blocks.f_50453_), 16) && this.getBlocks(blockState -> blockState.m_60713_((Block)ModBlocks.SKULL_PILE.get()), 4)) {
                if (this.getTrainMob() != ModEntityType.BONE_SPIDER_SERVANT.get()) {
                    this.setEntityType((EntityType)ModEntityType.BONE_SPIDER_SERVANT.get());
                    this.markUpdated();
                }
            } else if (RitualRequirements.frostRitual(blockPos, level)) {
                if (this.getTrainMob() != ModEntityType.ICY_SPIDER_SERVANT.get()) {
                    this.setEntityType((EntityType)ModEntityType.ICY_SPIDER_SERVANT.get());
                    this.markUpdated();
                }
            } else if (BlockFinder.findStructure(serverLevel, blockPos, (TagKey<Structure>)StructureTags.f_215890_) || this.getBlocks(blockState -> blockState.m_60713_(Blocks.f_50599_), 8) && this.getBlocks(blockState -> blockState.m_60734_() instanceof MushroomBlock, 8) && this.getBlocks(blockState -> blockState.m_204336_(Tags.Blocks.STONE), 8)) {
                if (this.getTrainMob() != ModEntityType.CAVE_SPIDER_SERVANT.get()) {
                    this.setEntityType((EntityType)ModEntityType.CAVE_SPIDER_SERVANT.get());
                    this.markUpdated();
                }
            } else if (this.getBlocks(blockState -> blockState.m_204336_(BlockTags.f_13035_), 16) && this.getBlocks(blockState -> blockState.m_60734_() instanceof WebBlock, 8)) {
                if (this.getTrainMob() != ModEntityType.WEB_SPIDER_SERVANT.get()) {
                    this.setEntityType((EntityType)ModEntityType.WEB_SPIDER_SERVANT.get());
                    this.markUpdated();
                }
            } else if (this.getTrainMob() != ModEntityType.SPIDER_SERVANT.get()) {
                this.setEntityType((EntityType)ModEntityType.SPIDER_SERVANT.get());
                this.markUpdated();
            }
        }
    }

    @Override
    public void startTraining(int amount, ItemStack itemStack) {
        super.startTraining(amount, itemStack);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SPIDER_NEST_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public void playSpawnSound() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.SPIDER_NEST_SPAWN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public int maxTrainAmount() {
        return 5;
    }

    @Override
    public boolean summonLimit() {
        int count = 0;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!(entity instanceof SpiderServant)) continue;
                SpiderServant servant = (SpiderServant)entity;
                if (this.getTrueOwner() == null || servant.getTrueOwner() != this.getTrueOwner() || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count >= (Integer)SpellConfig.SpiderLimit.get();
    }

    @Override
    public boolean isFuel(ItemStack itemStack) {
        return itemStack.m_41720_().m_41472_() && this.getPlayer() != null && itemStack.m_41720_().getFoodProperties(itemStack, (LivingEntity)this.getPlayer()).m_38746_();
    }
}

