/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities.void_spawner;

import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawner;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerConfig;
import com.Polarice3.Goety.common.blocks.entities.void_spawner.VoidSpawnerState;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ModUUIDUtil;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import org.jetbrains.annotations.Nullable;

public class VoidSpawnerData {
    public static final String TAG_SPAWN_DATA = "spawn_data";
    private static final String TAG_NEXT_MOB_SPAWNS_AT = "next_mob_spawns_at";
    public static MapCodec<VoidSpawnerData> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ModUUIDUtil.CODEC_SET.optionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(trialSpawnerData -> trialSpawnerData.detectedPlayers), (App)ModUUIDUtil.CODEC_SET.optionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(trialSpawnerData -> trialSpawnerData.currentMobs), (App)Codec.LONG.optionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(trialSpawnerData -> trialSpawnerData.cooldownEndsAt), (App)Codec.LONG.optionalFieldOf(TAG_NEXT_MOB_SPAWNS_AT, (Object)0L).forGetter(trialSpawnerData -> trialSpawnerData.nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("total_mobs_spawned", (Object)0).forGetter(trialSpawnerData -> trialSpawnerData.totalMobsSpawned), (App)SpawnData.f_186559_.optionalFieldOf(TAG_SPAWN_DATA).forGetter(trialSpawnerData -> trialSpawnerData.nextSpawnData), (App)ResourceLocation.f_135803_.optionalFieldOf("ejecting_loot_table").forGetter(trialSpawnerData -> trialSpawnerData.ejectingLootTable)).apply((Applicative)instance, VoidSpawnerData::new));
    protected final Set<UUID> detectedPlayers = new HashSet<UUID>();
    protected final Set<UUID> currentMobs = new HashSet<UUID>();
    protected long cooldownEndsAt;
    protected long nextMobSpawnsAt;
    protected int totalMobsSpawned;
    protected Optional<SpawnData> nextSpawnData;
    protected Optional<ResourceLocation> ejectingLootTable;
    protected SimpleWeightedRandomList<SpawnData> spawnPotentials;
    @Nullable
    protected Entity displayEntity;
    protected double spin;
    protected double oSpin;

    public VoidSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public VoidSpawnerData(Set<UUID> set, Set<UUID> set2, long l, long m, int i, Optional<SpawnData> optional, Optional<ResourceLocation> optional2) {
        this.detectedPlayers.addAll(set);
        this.currentMobs.addAll(set2);
        this.cooldownEndsAt = l;
        this.nextMobSpawnsAt = m;
        this.totalMobsSpawned = i;
        this.nextSpawnData = optional;
        this.ejectingLootTable = optional2;
    }

    public void setSpawnPotentialsFromConfig(VoidSpawnerConfig trialSpawnerConfig) {
        SimpleWeightedRandomList<SpawnData> simpleWeightedRandomList = trialSpawnerConfig.spawnPotentialsDefinition();
        this.spawnPotentials = simpleWeightedRandomList.m_146337_() ? SimpleWeightedRandomList.m_185862_((Object)this.nextSpawnData.orElseGet(SpawnData::new)) : simpleWeightedRandomList;
    }

    public void reset() {
        this.detectedPlayers.clear();
        this.totalMobsSpawned = 0;
        this.nextMobSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
        this.currentMobs.clear();
    }

    public boolean hasMobToSpawn() {
        boolean bl = this.nextSpawnData.isPresent() && this.nextSpawnData.get().m_186567_().m_128425_("id", 8);
        return bl || !this.spawnPotentials.m_146337_();
    }

    public boolean hasFinishedSpawningAllMobs(VoidSpawnerConfig trialSpawnerConfig, int i) {
        return this.totalMobsSpawned >= trialSpawnerConfig.calculateTargetTotalMobs(i);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(ServerLevel serverLevel, VoidSpawnerConfig trialSpawnerConfig, int i) {
        return serverLevel.m_46467_() >= this.nextMobSpawnsAt && this.currentMobs.size() < trialSpawnerConfig.calculateTargetSimultaneousMobs(i);
    }

    public int countAdditionalPlayers(BlockPos blockPos) {
        if (this.detectedPlayers.isEmpty()) {
            Util.m_143785_((String)("Void Spawner at " + blockPos + " has no detected players"));
        }
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public void tryDetectPlayers(ServerLevel serverLevel, BlockPos blockPos, VoidSpawner voidSpawner) {
        List<UUID> list = voidSpawner.getPlayerDetector().detect(serverLevel, voidSpawner.getEntitySelector(), blockPos, voidSpawner.getRequiredPlayerRange(), true);
        boolean bl = this.detectedPlayers.addAll(list);
        if (bl) {
            this.nextMobSpawnsAt = Math.max(serverLevel.m_46467_() + 40L, this.nextMobSpawnsAt);
            serverLevel.m_5594_(null, blockPos, (SoundEvent)ModSounds.VOID_SPAWNER_DETECT_PLAYER.get(), SoundSource.BLOCKS, 1.0f, (serverLevel.m_213780_().m_188501_() - serverLevel.m_213780_().m_188501_()) * 0.2f + 1.0f);
            VoidSpawner.addDetectPlayerParticles(serverLevel, blockPos, serverLevel.m_213780_(), this.detectedPlayers.size());
        }
    }

    public boolean isReadyToOpenShutter(ServerLevel serverLevel, VoidSpawnerConfig trialSpawnerConfig, float f) {
        long l = this.cooldownEndsAt - (long)trialSpawnerConfig.targetCooldownLength();
        return (float)serverLevel.m_46467_() >= (float)l + f;
    }

    public boolean isReadyToEjectItems(ServerLevel serverLevel, VoidSpawnerConfig trialSpawnerConfig, float f) {
        long l = this.cooldownEndsAt - (long)trialSpawnerConfig.targetCooldownLength();
        return (float)(serverLevel.m_46467_() - l) % f == 0.0f;
    }

    public boolean isCooldownFinished(ServerLevel serverLevel) {
        return serverLevel.m_46467_() >= this.cooldownEndsAt;
    }

    public void setEntityId(VoidSpawner trialSpawner, RandomSource randomSource, EntityType<?> entityType) {
        this.getOrCreateNextSpawnData(trialSpawner, randomSource).m_186567_().m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(entityType).toString());
    }

    protected SpawnData getOrCreateNextSpawnData(VoidSpawner trialSpawner, RandomSource randomSource) {
        if (this.nextSpawnData.isPresent()) {
            return this.nextSpawnData.get();
        }
        this.nextSpawnData = Optional.of(this.spawnPotentials.m_216829_(randomSource).map(WeightedEntry.Wrapper::m_146310_).orElseGet(SpawnData::new));
        trialSpawner.markUpdated();
        return this.nextSpawnData.get();
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(VoidSpawner trialSpawner, Level level, VoidSpawnerState trialSpawnerState) {
        if (trialSpawner.canSpawnInLevel(level) && trialSpawnerState.hasSpinningMob()) {
            CompoundTag compoundTag;
            if (this.displayEntity == null && (compoundTag = this.getOrCreateNextSpawnData(trialSpawner, level.m_213780_()).m_186567_()).m_128425_("id", 8)) {
                this.displayEntity = EntityType.m_20645_((CompoundTag)compoundTag, (Level)level, Function.identity());
            }
            return this.displayEntity;
        }
        return null;
    }

    public CompoundTag getUpdateTag(VoidSpawnerState trialSpawnerState) {
        CompoundTag compoundTag = new CompoundTag();
        if (trialSpawnerState == VoidSpawnerState.ACTIVE) {
            compoundTag.m_128356_(TAG_NEXT_MOB_SPAWNS_AT, this.nextMobSpawnsAt);
        }
        this.nextSpawnData.ifPresent(spawnData -> compoundTag.m_128365_(TAG_SPAWN_DATA, (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, spawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return compoundTag;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }
}

