/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.hostile.illagers;

import com.Polarice3.Goety.api.entities.ICharger;
import com.Polarice3.Goety.api.entities.ICustomAttributes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ai.ChargeGoal;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class Trampler
extends Raider
implements ICharger,
ICustomAttributes {
    private static final EntityDataAccessor<Boolean> DATA_STANDING_ID = SynchedEntityData.m_135353_(Trampler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING = SynchedEntityData.m_135353_(Trampler.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float clientSideStandAnimationO;
    private float clientSideStandAnimation;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;

    public Trampler(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new TramplerChargeGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new TramplerMeleeAttackGoal());
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, p_199899_ -> !p_199899_.m_6162_()));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob) || this.m_6688_().m_6095_().m_204039_(EntityTypeTags.f_13121_);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, flag);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.TramplerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.TramplerArmor.get()).doubleValue()).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.TramplerDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.TramplerHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.TramplerArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.TramplerDamage.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STANDING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_CHARGING, (Object)false);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setConfigurableAttributes();
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public int m_8085_() {
        return 45;
    }

    public double m_6048_() {
        return 1.2000000000000002;
    }

    public void m_19956_(Entity rider, Entity.MoveFunction p_19958_) {
        super.m_19956_(rider, p_19958_);
        if (this.standAnimO > 0.0f) {
            float f3 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.standAnimO;
            float f2 = 0.15f * this.standAnimO;
            rider.m_6034_(this.m_20185_() + (double)(f1 * f3), this.m_20186_() + this.m_6048_() + rider.m_6049_() + (double)f2, this.m_20189_() - (double)(f1 * f));
        }
        if (rider instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)rider;
            living.f_20883_ = this.f_20883_;
        }
    }

    public int m_8100_() {
        return 400;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.TRAMPLER_AMBIENT.get();
    }

    public SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.TRAMPLER_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.TRAMPLER_DEATH.get();
    }

    protected void m_7355_(BlockPos p_30584_, BlockState p_30585_) {
        if (!p_30585_.m_278721_()) {
            BlockState blockstate = this.m_9236_().m_8055_(p_30584_.m_7494_());
            SoundType soundtype = p_30585_.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), p_30584_, (Entity)this);
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 5 && this.gallopSoundCounter % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (this.isWoodSoundType(soundtype)) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    private boolean isWoodSoundType(SoundType p_278280_) {
        return p_278280_ == SoundType.f_56736_ || p_278280_ == SoundType.f_244244_ || p_278280_ == SoundType.f_56763_ || p_278280_ == SoundType.f_271497_ || p_278280_ == SoundType.f_243772_;
    }

    protected void playGallopSound(SoundType p_30560_) {
        this.m_5496_(SoundEvents.f_11977_, p_30560_.m_56773_() * 0.15f, p_30560_.m_56774_());
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_21525_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.clientSideStandAnimation != this.clientSideStandAnimationO) {
                this.m_6210_();
            }
            this.clientSideStandAnimationO = this.clientSideStandAnimation;
            this.standAnimO = this.standAnim;
            this.mouthAnimO = this.mouthAnim;
            if (this.isStanding()) {
                this.clientSideStandAnimation = Mth.m_14036_((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f);
                this.standAnim += (1.0f - this.standAnim) * 0.4f + 0.05f;
                if (this.standAnim > 1.0f) {
                    this.standAnim = 1.0f;
                }
                this.mouthAnim += (1.0f - this.mouthAnim) * 0.7f + 0.05f;
                if (this.mouthAnim > 1.0f) {
                    this.mouthAnim = 1.0f;
                }
            } else {
                this.clientSideStandAnimation = Mth.m_14036_((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
                this.standAnim += (0.8f * this.standAnim * this.standAnim * this.standAnim - this.standAnim) * 0.6f - 0.05f;
                if (this.standAnim < 0.0f) {
                    this.standAnim = 0.0f;
                }
                this.mouthAnim += (0.0f - this.mouthAnim) * 0.7f - 0.05f;
                if (this.mouthAnim < 0.0f) {
                    this.mouthAnim = 0.0f;
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            AttributeInstance instance = this.m_21051_(Attributes.f_22279_);
            if (instance != null) {
                double d0 = this.m_5448_() != null ? 0.45 : 0.35;
                double d1 = instance.m_22115_();
                instance.m_22100_(Mth.m_14139_((double)0.1, (double)d1, (double)d0));
            }
            if (this.isCharging()) {
                this.f_267362_.m_267771_(this.f_267362_.m_267731_() + 0.8f);
            }
            if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                boolean flag = false;
                AABB aabb = this.m_20191_().m_82400_(0.2);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (!(block instanceof CropBlock)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
                }
                if (!flag && this.m_20096_()) {
                    this.m_6135_();
                }
            }
        }
    }

    public EntityDimensions m_6972_(Pose p_29531_) {
        if (this.clientSideStandAnimation > 0.0f) {
            float f = this.clientSideStandAnimation / 6.0f;
            float f1 = 1.0f + f;
            return super.m_6972_(p_29531_).m_20390_(1.0f, f1);
        }
        return super.m_6972_(p_29531_);
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STANDING_ID);
    }

    public void setStanding(boolean p_29568_) {
        this.f_19804_.m_135381_(DATA_STANDING_ID, (Object)p_29568_);
    }

    public float getStandingAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.clientSideStandAnimationO, (float)this.clientSideStandAnimation) / 6.0f;
    }

    public float getMouthAnim(float p_30534_) {
        return Mth.m_14179_((float)p_30534_, (float)this.mouthAnimO, (float)this.mouthAnim);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean m_7490_() {
        return false;
    }

    @NotNull
    public SoundEvent m_7930_() {
        return (SoundEvent)ModSounds.TRAMPLER_CELEBRATE.get();
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (this.m_20160_() && p_37849_.m_7639_() != null && this.m_6688_() != null && p_37849_.m_7639_() == this.m_6688_()) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING);
    }

    @Override
    public void setCharging(boolean flag) {
        this.f_19804_.m_135381_(DATA_CHARGING, (Object)flag);
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.isCharging()) {
            this.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.STUNNED.get(), 100, 0, false, false));
            p_33361_.f_19864_ = true;
        }
    }

    public static class TramplerChargeGoal
    extends ChargeGoal {
        public TramplerChargeGoal(PathfinderMob mob) {
            super(mob, 1.2f, 4.0, 32.0, 5, 200);
        }

        @Override
        public double getAttackReachSqr(LivingEntity target) {
            return 6.0f + target.m_20205_();
        }
    }

    class TramplerMeleeAttackGoal
    extends MeleeAttackGoal {
        public TramplerMeleeAttackGoal() {
            super((PathfinderMob)Trampler.this, 1.25, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Trampler.this.isCharging();
        }

        protected void m_6739_(LivingEntity p_29589_, double p_29590_) {
            double d0 = this.m_6639_(p_29589_);
            if (p_29590_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_29589_);
                Trampler.this.setStanding(false);
            } else if (p_29590_ <= d0 * 2.0) {
                if (this.m_25564_()) {
                    Trampler.this.setStanding(false);
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Trampler.this.setStanding(true);
                }
            } else {
                this.m_25563_();
                Trampler.this.setStanding(false);
            }
        }

        public void m_8041_() {
            Trampler.this.setStanding(false);
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity p_29587_) {
            return 4.0f + p_29587_.m_20205_();
        }
    }
}

