/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractSnareling;
import com.Polarice3.Goety.common.entities.projectiles.TangleEntity;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SnarelingGoop
extends TangleEntity {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SnarelingGoop.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState holdAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();

    public SnarelingGoop(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public SnarelingGoop(Level p_19871_, LivingEntity owner, Entity target) {
        super((EntityType)ModEntityType.SNARELING_GOOP.get(), p_19871_, owner, target);
    }

    public SnarelingGoop(Level p_19871_, LivingEntity owner, BlockPos blockPos) {
        super((EntityType)ModEntityType.SNARELING_GOOP.get(), p_19871_, owner, blockPos);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "hold")) {
            return 1;
        }
        if (Objects.equals(animation, "burrow")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.holdAnimationState);
        list.add(this.burrowAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.holdAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.holdAnimationState);
                    break;
                }
                case 2: {
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.burrowAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    @Override
    public void burst() {
        this.setAnimationState("hold");
        this.m_5496_((SoundEvent)ModSounds.SNARELING_GOO_IMPACT.get(), 1.5f, 1.0f);
    }

    @Override
    public void tangleTarget() {
        super.tangleTarget();
        if (this.getTarget() != null) {
            this.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19597_, MathHelper.secondsToTicks(5), 0, false, false));
        }
        this.setAnimationState("hold");
    }

    @Override
    public void burrow() {
        this.setAnimationState("burrow");
    }

    @Override
    protected boolean canHitEntity(Entity pEntity) {
        if (pEntity instanceof AbstractSnareling) {
            return false;
        }
        return super.canHitEntity(pEntity);
    }
}

