/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.BioMine;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BioMineSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BiomineCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BiomineDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ABYSS_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BiomineCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster);
            radius += (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
        }
        LivingEntity target = this.getTarget(caster, range);
        int i = this.rightStaff(staff) ? 8 : 4;
        for (int j = 0; j < i; ++j) {
            Vec3 vec3 = Vec3.m_82539_((Vec3i)BlockFinder.SummonWaterAwayRadius(caster.m_20183_(), caster, (Level)worldIn, 16, 8));
            if (target != null) {
                vec3 = Vec3.m_82539_((Vec3i)BlockFinder.SummonWaterAwayRadius(target.m_20183_(), target, (Level)worldIn, 16, 8));
            }
            BioMine bioMine = new BioMine((EntityType)ModEntityType.BIOMINE.get(), (Level)worldIn);
            bioMine.m_146884_(vec3);
            bioMine.setOwner(caster);
            bioMine.setExtraRadius((float)radius);
            bioMine.setExtraDamage(potency);
            bioMine.setLifeTicks(bioMine.getLifeTicks() + MathHelper.secondsToTicks(duration));
            bioMine.setExtraDuration(MathHelper.secondsToTicks(duration));
            if (!worldIn.m_7967_((Entity)bioMine)) continue;
            for (int i1 = 0; i1 < worldIn.m_213780_().m_188503_(10) + 10; ++i1) {
                worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SUMMON.get()), bioMine.m_20208_(1.5), bioMine.m_20187_(), bioMine.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
            }
            worldIn.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ModSounds.BIOMINE_SPAWN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

