/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.block;

import com.Polarice3.Goety.client.render.BlockRenderType;
import com.Polarice3.Goety.common.blocks.entities.AnimatorBlockEntity;
import com.Polarice3.Goety.common.items.WaystoneItem;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.RenderBlockUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimatorRenderer
implements BlockEntityRenderer<AnimatorBlockEntity> {
    public AnimatorRenderer(BlockEntityRendererProvider.Context p_i226007_1_) {
    }

    public void render(AnimatorBlockEntity pBlockEntity, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        ItemStack itemStack = pBlockEntity.getItem();
        Minecraft minecraft = Minecraft.m_91087_();
        if (pBlockEntity.m_58904_() != null && itemStack != null && !itemStack.m_41619_()) {
            pMatrixStack.m_85836_();
            pMatrixStack.m_252880_(0.5f, 0.5f, 0.5f);
            pMatrixStack.m_85841_(1.0f, 1.0f, 1.0f);
            if (pBlockEntity.getSpinning() > 0) {
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(12.0f * ((float)(minecraft.f_91073_.m_46467_() % 360L) + pPartialTicks)));
            } else {
                pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(3.0f * ((float)(minecraft.f_91073_.m_46467_() % 360L) + pPartialTicks)));
            }
            minecraft.m_91291_().m_269128_(itemStack, ItemDisplayContext.GROUND, pCombinedLight, pCombinedOverlay, pMatrixStack, pBuffer, pBlockEntity.m_58904_(), 0);
            pMatrixStack.m_85849_();
            if (pBlockEntity.isShowBlock()) {
                HashMap<BlockPos, ColorUtil> renderCubes = new HashMap<BlockPos, ColorUtil>();
                GlobalPos loc = WaystoneItem.getPosition(itemStack);
                if (loc != null && loc.m_122640_() == pBlockEntity.m_58904_().m_46472_()) {
                    renderCubes.put(loc.m_122646_(), new ColorUtil(ChatFormatting.LIGHT_PURPLE));
                }
                if (!renderCubes.keySet().isEmpty()) {
                    Vec3 view = Vec3.m_82528_((Vec3i)pBlockEntity.m_58899_());
                    RenderBlockUtils.renderColourCubes(pMatrixStack, view, renderCubes, 1.0f, 1.0f);
                }
                AnimatorRenderer.draw(pBlockEntity, pMatrixStack, pBuffer);
            }
        }
    }

    public boolean shouldRenderOffScreen(AnimatorBlockEntity p_112306_) {
        return true;
    }

    public static void draw(AnimatorBlockEntity tile, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        GlobalPos posPosTarget = tile.getPosition();
        if (posPosTarget == null) {
            return;
        }
        if (tile.m_58904_() == null) {
            return;
        }
        if (posPosTarget.m_122640_() != tile.m_58904_().m_46472_()) {
            return;
        }
        BlockPos posTarget = posPosTarget.m_122646_();
        if (posTarget.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_252922_();
        BlockPos tilePos = tile.m_58899_();
        Vector3f from = new Vector3f((float)posTarget.m_123341_() + 0.5f - (float)tilePos.m_123341_(), (float)posTarget.m_123342_() + 0.5f - (float)tilePos.m_123342_(), (float)posTarget.m_123343_() + 0.5f - (float)tilePos.m_123343_());
        Vector3f to = new Vector3f(0.5f, 0.5f, 0.5f);
        VertexConsumer builder = bufferIn.m_6299_(BlockRenderType.LASER_MAIN_BEAM);
        ColorUtil colorUtil = new ColorUtil(ChatFormatting.LIGHT_PURPLE);
        AnimatorRenderer.drawDirewolfLaser(builder, positionMatrix, from, to, colorUtil.red(), colorUtil.green(), colorUtil.blue(), colorUtil.alpha(), 0.065f, tilePos);
        matrixStackIn.m_85849_();
    }

    public static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockPos tile) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vector3f vectP = new Vector3f((float)player.m_20185_() - (float)tile.m_123341_(), (float)player.m_20188_() - (float)tile.m_123342_(), (float)player.m_20189_() - (float)tile.m_123343_());
        Vector3f vectS = new Vector3f((Vector3fc)from);
        vectS.sub((Vector3fc)vectP);
        Vector3f vectE = new Vector3f((Vector3fc)to);
        vectE.sub((Vector3fc)from);
        Vector3f adjustedVec = new Vector3f((Vector3fc)vectS);
        adjustedVec.cross((Vector3fc)vectE);
        adjustedVec.normalize();
        return adjustedVec;
    }

    public static void drawDirewolfLaser(VertexConsumer builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, BlockPos tilePos) {
        float v = 1.0f;
        Vector3f adjustedVec = AnimatorRenderer.adjustBeamToEyes(from, to, tilePos);
        adjustedVec.mul(thickness);
        Vector3f p1 = new Vector3f((Vector3fc)from);
        p1.add((Vector3fc)adjustedVec);
        Vector3f p2 = new Vector3f((Vector3fc)from);
        p2.sub((Vector3fc)adjustedVec);
        Vector3f p3 = new Vector3f((Vector3fc)to);
        p3.add((Vector3fc)adjustedVec);
        Vector3f p4 = new Vector3f((Vector3fc)to);
        p4.sub((Vector3fc)adjustedVec);
        builder.m_252986_(positionMatrix, p1.x(), p1.y(), p1.z()).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(positionMatrix, p3.x(), p3.y(), p3.z()).m_85950_(r, g, b, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(positionMatrix, p4.x(), p4.y(), p4.z()).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(positionMatrix, p2.x(), p2.y(), p2.z()).m_85950_(r, g, b, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5752_();
    }
}

