/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.WraithAnimations;
import com.Polarice3.Goety.common.entities.neutral.AbstractWraith;
import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class WraithModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart Ghost;
    private final ModelPart head;
    private final ModelPart RightArm;
    private final ModelPart RightBone;
    private final ModelPart LeftArm;
    private final ModelPart LeftBone;
    private final ModelPart body;
    private final ModelPart robe;

    public WraithModel(ModelPart root) {
        this.root = root;
        this.Ghost = root.m_171324_("Ghost");
        this.head = this.Ghost.m_171324_("head");
        this.RightArm = this.Ghost.m_171324_("right_arm");
        this.RightBone = this.RightArm.m_171324_("right_bone");
        this.LeftArm = this.Ghost.m_171324_("left_arm");
        this.LeftBone = this.LeftArm.m_171324_("left_bone");
        this.body = this.Ghost.m_171324_("body");
        this.robe = this.body.m_171324_("robe");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Ghost = partdefinition.m_171599_("Ghost", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = Ghost.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(2, 3).m_171488_(-3.0f, -7.0f, -2.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)-1.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -3.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition hat_r1 = hat.m_171599_("hat_r1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-5.0f, -4.7f, -0.6f, 10.0f, 4.0f, 9.0f, new CubeDeformation(-0.75f)), PartPose.m_171423_((float)0.0f, (float)-5.3f, (float)2.6f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = Ghost.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)-22.0f, (float)0.0f));
        PartDefinition right_robe = right_arm.m_171599_("right_robe", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_bone = right_arm.m_171599_("right_bone", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-0.5f, -2.0f, -0.5f, 1.0f, 12.0f, 1.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = Ghost.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-22.0f, (float)0.0f));
        PartDefinition left_robe = left_arm.m_171599_("left_robe", CubeListBuilder.m_171558_().m_171514_(16, 33).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_bone = left_arm.m_171599_("left_bone", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-0.5f, -2.0f, -0.5f, 1.0f, 12.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = Ghost.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition ribs = body.m_171599_("ribs", CubeListBuilder.m_171558_().m_171514_(8, 17).m_171488_(-3.0f, 0.0f, -4.0f, 6.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spine = body.m_171599_("spine", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-0.5f, -1.0f, -1.5f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition robe = body.m_171599_("robe", CubeListBuilder.m_171558_().m_171514_(35, 34).m_171488_(-4.0f, -1.0f, -2.0f, 8.0f, 20.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (pEntity instanceof AbstractWraith) {
            AbstractWraith wraith = (AbstractWraith)pEntity;
            this.m_233381_(wraith.attackAnimationState, WraithAnimations.ATTACK, pAgeInTicks);
            this.m_233381_(wraith.breathingAnimationState, WraithAnimations.PUKE, pAgeInTicks);
            this.m_233381_(wraith.postTeleportAnimationState, WraithAnimations.TELEPORT_OUT, pAgeInTicks);
            this.m_233381_(wraith.acidAnimationState, WraithAnimations.ACID, pAgeInTicks);
            if (!(wraith.isFiring() || wraith.isBreathing() || wraith.isPostTeleporting())) {
                if (wraith.isTeleporting()) {
                    float f7 = Mth.m_14031_((float)(((float)(wraith.teleportTime - 20) - (float)wraith.teleportTime2) / 20.0f * (float)Math.PI * 0.25f));
                    this.head.f_104203_ = (float)Math.PI * f7 + 2.0f;
                    this.RightArm.f_104203_ = (float)Math.PI * f7;
                    this.LeftArm.f_104203_ = (float)Math.PI * f7;
                    this.Ghost.f_104201_ += (float)Math.PI * f7 * 5.0f;
                } else {
                    float f = pAgeInTicks * 0.0025f;
                    if (((LivingEntity)pEntity).f_267362_.m_267780_()) {
                        f *= 2.0f;
                    }
                    this.Ghost.f_104201_ = Mth.m_14031_((float)(f * 40.0f)) + 24.0f;
                    float f4 = Math.min(pLimbSwingAmount / 0.3f, 1.0f);
                    this.robe.f_104203_ = f4 * MathHelper.modelDegrees(40.0f);
                    this.robe.f_104203_ += Mth.m_14089_((float)(pAgeInTicks * 0.09f)) * 0.1f + 0.1f;
                    this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
                    float f5 = Math.min(pLimbSwingAmount / 2.0f, 1.0f);
                    float degrees = wraith.m_21563_().m_186069_() ? 0.0f : MathHelper.modelDegrees(10.0f) - f5;
                    this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180) + degrees;
                    WraithModel.animateArms(this.LeftArm, this.RightArm, pLimbSwingAmount, pAgeInTicks);
                    this.RightBone.f_104203_ = -MathHelper.modelDegrees(12.5f);
                    this.LeftBone.f_104203_ = -MathHelper.modelDegrees(12.5f);
                }
            } else if (wraith.isBreathing()) {
                this.Ghost.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
                this.Ghost.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
            }
        } else {
            this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        }
    }

    public static void animateArms(ModelPart leftArm, ModelPart rightArm, float attackTime, float ageInTicks) {
        float f2;
        rightArm.f_104205_ = Math.min(attackTime / 0.9f, 1.0f);
        leftArm.f_104205_ = -Math.min(attackTime / 0.9f, 1.0f);
        rightArm.f_104204_ = -0.1f;
        leftArm.f_104204_ = 0.1f;
        rightArm.f_104203_ = f2 = -MathHelper.modelDegrees(40.0f);
        leftArm.f_104203_ = f2;
        AnimationUtils.m_102082_((ModelPart)rightArm, (ModelPart)leftArm, (float)ageInTicks);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

