/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.IEnchantedBlock;
import com.Polarice3.Goety.client.particles.AbsorbTrailParticleOption;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.client.particles.SpirallingParticleOption;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.OwnedBlockEntity;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.SEHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlackCrystalBlockEntity
extends OwnedBlockEntity
implements IEnchantedBlock {
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();
    public int tickCount;
    public int attackTick;
    @Nullable
    private LivingEntity target;

    public BlackCrystalBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.BLACK_CRYSTAL.get(), p_155229_, p_155230_);
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        super.readNetwork(tag);
        this.loadEnchants(tag);
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        this.saveEnchants(tag, ((Block)ModBlocks.BLACK_CRYSTAL.get()).m_5456_());
        return super.writeNetwork(tag);
    }

    @Override
    public Object2IntMap<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public void tick() {
        if (this.f_58857_ != null) {
            ++this.tickCount;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int radius = 8 + this.enchantments.getOrDefault(ModEnchantments.RADIUS.get(), 0);
                if (this.target == null) {
                    for (LivingEntity livingEntity : serverLevel.m_45976_(LivingEntity.class, new AABB(this.f_58858_).m_82400_((double)(radius * 2)))) {
                        boolean flag;
                        if (!EntitySelector.f_20406_.test(livingEntity) || !(livingEntity.m_20238_(this.m_58899_().m_252807_()) <= (double)Mth.m_144944_((int)radius))) continue;
                        boolean bl = flag = livingEntity.m_21223_() >= livingEntity.m_21233_() * 0.25f;
                        if (this.getTrueOwner() != null) {
                            flag &= !MobUtil.areAllies((Entity)this.getTrueOwner(), (Entity)livingEntity);
                        }
                        if (!flag) continue;
                        this.target = livingEntity;
                    }
                } else if (!this.target.m_6084_() || this.target.m_21223_() < this.target.m_21233_() * 0.25f || this.target.m_20238_(this.m_58899_().m_252807_()) > (double)Mth.m_144944_((int)radius)) {
                    this.attackTick = 0;
                    this.target = null;
                } else {
                    ++this.attackTick;
                    if (this.attackTick % 20 == 0) {
                        Vec3 vector3d1 = this.m_58899_().m_252807_();
                        DamageSource damageSource = this.getTrueOwner() != null ? ModDamageSource.soulLeech((Entity)this.getTrueOwner(), (Entity)this.getTrueOwner()) : this.f_58857_.m_269111_().m_269425_();
                        this.target.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.CURSED.get(), 5, 0, false, false));
                        if (this.target.m_6469_(damageSource, this.target.m_21233_() * 0.1f)) {
                            Vec3 vec31;
                            ColorUtil colorUtil1 = new ColorUtil(5257437);
                            serverLevel.m_8767_((ParticleOptions)new SpirallingParticleOption(1.0f, colorUtil1.red, colorUtil1.green, colorUtil1.blue, 5), vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, 1, 0.0, 0.0, 0.0, 1.0);
                            Vec3 vec3 = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)(this.target.m_20206_() / 2.0f), this.target.m_20189_());
                            serverLevel.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil1, vector3d1), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, 0.0, 0.0, 0.0, 0.5);
                            for (int i = 0; i < 8; ++i) {
                                vec31 = new Vec3(this.target.m_20208_(1.0), this.target.m_20187_(), this.target.m_20262_(1.0));
                                serverLevel.m_8767_((ParticleOptions)new AbsorbTrailParticleOption(vector3d1, 5257437, 10), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.SOUL_EAT.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
                            vec31 = this.getTrueOwner();
                            if (vec31 instanceof Player) {
                                Player player = (Player)vec31;
                                int enchantment = this.enchantments.getOrDefault(ModEnchantments.SOUL_EATER.get(), 0);
                                int soulEater = Mth.m_14045_((int)(enchantment + 1), (int)1, (int)10);
                                SEHelper.increaseSouls(player, (Integer)ItemConfig.DarkScytheSouls.get() * soulEater);
                            }
                        }
                    }
                }
            }
        }
    }
}

