/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.TrainingBlockEntity;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.ZombieServant;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;

public class GravestoneBlockEntity
extends TrainingBlockEntity {
    public GravestoneBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SHADE_GRAVESTONE.get(), p_155229_, p_155230_);
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        super.tick(level, blockPos, blockState, blockEntity);
        if (blockEntity.isTraining()) {
            if (blockEntity.trainTime != blockEntity.getMaxTrainTime() && blockEntity.trainTime % 20 == 0) {
                level.m_5594_(null, blockPos, SoundEvents.f_12404_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double d0 = (double)blockPos.m_123341_() + level.f_46441_.m_188500_();
                double d1 = (double)blockPos.m_123342_() + level.f_46441_.m_188500_();
                double d2 = (double)blockPos.m_123343_() + level.f_46441_.m_188500_();
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.NECRO_FIRE.get()), d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                if (level.f_46441_.m_188501_() < 0.3f && level.f_46441_.m_188501_() < 0.17f) {
                    ModNetwork.sendToALL(new SPlayWorldSoundPacket(blockPos, SoundEvents.f_11907_, 0.5f + level.f_46441_.m_188501_(), level.f_46441_.m_188501_() * 0.7f + 0.3f));
                }
            }
        }
    }

    @Override
    public void setVariant(ItemStack itemStack, Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ZombieServant zombieServant = new ZombieServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.ZOMBIE_SERVANT.get()), (Level)serverLevel);
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                this.setEntityType((EntityType)ModEntityType.DROWNED_SERVANT.get());
                this.markUpdated();
            } else if (this.getTrainMob() != zombieServant.getVariant(this.getPlayer(), (Level)serverLevel, blockPos.m_7494_())) {
                this.setEntityType(zombieServant.getVariant(this.getPlayer(), (Level)serverLevel, blockPos.m_7494_()));
                this.markUpdated();
            }
        }
    }

    @Override
    public void startTraining(int amount, ItemStack itemStack) {
        super.startTraining(amount, itemStack);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.GRAVESTONE_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public void playSpawnSound() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.NECROMANCER_SUMMON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public int maxTrainAmount() {
        return 5;
    }

    @Override
    public boolean summonLimit() {
        int count = 0;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!(entity instanceof ZombieServant)) continue;
                ZombieServant servant = (ZombieServant)entity;
                if (this.getTrueOwner() == null || servant.getTrueOwner() != this.getTrueOwner() || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count >= (Integer)SpellConfig.ZombieLimit.get();
    }

    @Override
    public boolean isFuel(ItemStack itemStack) {
        return itemStack.m_204117_(Tags.Items.NUGGETS_IRON);
    }
}

