/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.BoundStormCaster;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.spells.storm.DischargeSpell;
import com.Polarice3.Goety.common.magic.spells.storm.MonsoonSpell;
import com.Polarice3.Goety.common.magic.spells.storm.ShockingSpell;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SLightningPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class StormCasterServant
extends AbstractIllagerServant {
    private static final EntityDataAccessor<Byte> IS_CASTING_SPELL = SynchedEntityData.m_135353_(StormCasterServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(StormCasterServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String SHOCK = "shock";
    public static String CLOUD = "cloud";
    public static String DISCHARGE = "discharge";
    protected int castingTime;
    public static ItemStack STAFF = new ItemStack((ItemLike)ModItems.STORM_STAFF.get());
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shockAnimationState = new AnimationState();
    public AnimationState cloudAnimationState = new AnimationState();
    public AnimationState dischargeAnimationState = new AnimationState();

    public StormCasterServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new DischargeSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new MonsoonSpellGoal());
        this.f_21345_.m_25352_(3, (Goal)new ShockGoal());
        this.f_21345_.m_25352_(4, (Goal)new AvoidTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 3.0f, 1.0, 1.6){

            public boolean m_8036_() {
                return super.m_8036_() && !StormCasterServant.this.isAttacking();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new MoveToTargetGoal());
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.StormCasterHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.StormCasterArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.StormCasterDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.StormCasterHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.StormCasterArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.StormCasterDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CASTING_SPELL, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag p_33732_) {
        super.m_7378_(p_33732_);
        this.castingTime = p_33732_.m_128451_("StormSpellTicks");
    }

    @Override
    public void m_7380_(CompoundTag p_33734_) {
        super.m_7380_(p_33734_);
        p_33734_.m_128405_("StormSpellTicks", this.castingTime);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 1;
        }
        if (Objects.equals(animation, SHOCK)) {
            return 2;
        }
        if (Objects.equals(animation, CLOUD)) {
            return 3;
        }
        if (Objects.equals(animation, DISCHARGE)) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.shockAnimationState);
        list.add(this.cloudAnimationState);
        list.add(this.dischargeAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.shockAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.shockAnimationState);
                    break;
                }
                case 3: {
                    this.cloudAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.cloudAnimationState);
                    break;
                }
                case 4: {
                    this.dischargeAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.dischargeAnimationState);
                }
            }
        }
    }

    public boolean isCastingSpell() {
        if (this.f_19853_.f_46443_) {
            return (Byte)this.f_19804_.m_135370_(IS_CASTING_SPELL) > 0;
        }
        return this.castingTime > 0;
    }

    public void setIsCastingSpell(int id) {
        this.f_19804_.m_135381_(IS_CASTING_SPELL, (Object)((byte)id));
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.castingTime > 0) {
            --this.castingTime;
        }
    }

    protected int getSpellCastingTime() {
        return this.castingTime;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.STORM_CASTER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.STORM_CASTER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.STORM_CASTER_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    protected float m_6515_(DamageSource p_34149_, float p_34150_) {
        p_34150_ = super.m_6515_(p_34149_, p_34150_);
        if (p_34149_.m_7639_() == this) {
            p_34150_ = 0.0f;
        }
        if (ModDamageSource.shockAttacks(p_34149_) || p_34149_.m_269533_(DamageTypeTags.f_268725_)) {
            p_34150_ *= 0.15f;
        }
        if (p_34149_.m_269533_(DamageTypeTags.f_268725_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300));
        }
        return p_34150_;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    public boolean isAttacking() {
        return this.getCurrentAnimation() == this.getAnimationState(SHOCK) || this.getCurrentAnimation() == this.getAnimationState(CLOUD) || this.getCurrentAnimation() == this.getAnimationState(DISCHARGE);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        BoundStormCaster servant;
        if (!this.f_19853_.f_46443_ && this.getIdol() == null && this.getTrueOwner() != null && CuriosFinder.hasNamelessSet(this.getTrueOwner()) && (servant = (BoundStormCaster)this.m_21406_((EntityType)ModEntityType.BOUND_STORM_CASTER.get(), true)) != null) {
            servant.setTrueOwner(this.getTrueOwner());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)servant);
            if (!this.m_20067_()) {
                this.f_19853_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.m_246184_(!this.isAttacking() && !this.f_267362_.m_267780_(), this.f_19797_);
        } else {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.m_6084_()) {
                    ServerParticleUtil.windParticle(serverLevel, ColorUtil.WHITE, 0.5f + serverLevel.f_46441_.m_188501_() * 0.5f, 0.0f, this.m_19879_(), this.m_20182_());
                    ColorUtil colorUtil = new ColorUtil(9274237);
                    ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.STATION_CULT_SPELL.get(), (Entity)this, colorUtil.red(), colorUtil.green(), colorUtil.blue(), 0.5f);
                    if (serverLevel.f_46441_.m_188503_(20) == 0) {
                        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_20183_());
                        Vec3 vec31 = vec3.m_82520_(this.f_19796_.m_188500_(), 1.0, this.f_19796_.m_188500_());
                        ModNetwork.sendToALL(new SLightningPacket(vec3, vec31, 2));
                    }
                }
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0 && !this.m_20068_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
    }

    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSounds.WIND.get();
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.STORM_CASTER_CELEBRATE.get();
    }

    class CastingSpellGoal
    extends Goal {
        private CastingSpellGoal() {
        }

        public boolean m_8036_() {
            return StormCasterServant.this.getSpellCastingTime() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            StormCasterServant.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            StormCasterServant.this.setIsCastingSpell(0);
            StormCasterServant.this.setAnimationState(IDLE);
        }

        public void m_8037_() {
            if (StormCasterServant.this.m_5448_() != null) {
                StormCasterServant.this.m_21563_().m_24960_((Entity)StormCasterServant.this.m_5448_(), (float)StormCasterServant.this.m_8085_(), (float)StormCasterServant.this.m_8132_());
            }
        }
    }

    class DischargeSpellGoal
    extends StormCasterUseSpellGoal {
        DischargeSpellGoal() {
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && StormCasterServant.this.m_5448_() != null && (double)StormCasterServant.this.m_5448_().m_20270_((Entity)StormCasterServant.this) < 4.0;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            StormCasterServant.this.setAnimationState(DISCHARGE);
        }

        @Override
        protected void performSpellCasting() {
            if (StormCasterServant.this.m_5448_() != null) {
                new DischargeSpell().mobSpellResult((LivingEntity)StormCasterServant.this, STAFF);
            }
        }

        @Override
        protected int getCastingTime() {
            return 20;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.STORM_CASTER_DISCHARGE.get();
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }
    }

    class MonsoonSpellGoal
    extends StormCasterUseSpellGoal {
        MonsoonSpellGoal() {
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            StormCasterServant.this.setAnimationState(CLOUD);
        }

        @Override
        protected void performSpellCasting() {
            if (StormCasterServant.this.m_5448_() != null) {
                new MonsoonSpell().mobSpellResult((LivingEntity)StormCasterServant.this, STAFF);
            }
        }

        @Override
        protected int getCastingTime() {
            return 22;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.STORM_CASTER_MONSOON.get();
        }
    }

    class ShockGoal
    extends Goal {
        protected int nextAttackTickCount;
        public int shockTime;

        ShockGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = StormCasterServant.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && StormCasterServant.this.m_142582_((Entity)livingentity) && (double)StormCasterServant.this.m_20270_((Entity)livingentity) <= 8.0) {
                if (StormCasterServant.this.isCastingSpell()) {
                    return false;
                }
                return StormCasterServant.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = StormCasterServant.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && StormCasterServant.this.m_142582_((Entity)livingentity) && (double)StormCasterServant.this.m_20270_((Entity)livingentity) <= 8.0 && this.shockTime > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            LivingEntity livingentity = StormCasterServant.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && StormCasterServant.this.m_142582_((Entity)livingentity)) {
                StormCasterServant.this.m_21563_().m_24960_((Entity)livingentity, (float)StormCasterServant.this.m_8085_(), (float)StormCasterServant.this.m_8132_());
            }
            StormCasterServant.this.f_21344_.m_26573_();
            StormCasterServant.this.setAnimationState(SHOCK);
            this.nextAttackTickCount = StormCasterServant.this.f_19797_ + 100;
            this.shockTime = 30;
        }

        public void m_8041_() {
            super.m_8041_();
            StormCasterServant.this.setAnimationState(IDLE);
            this.shockTime = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (StormCasterServant.this.m_5448_() != null) {
                StormCasterServant.this.m_21563_().m_24960_((Entity)StormCasterServant.this.m_5448_(), (float)StormCasterServant.this.m_8085_(), (float)StormCasterServant.this.m_8132_());
                if (this.shockTime > 0) {
                    --this.shockTime;
                    if (this.shockTime < 20 && MobUtil.hasVisualLineOfSight((LivingEntity)StormCasterServant.this, (Entity)StormCasterServant.this.m_5448_())) {
                        new ShockingSpell().mobSpellResult((LivingEntity)StormCasterServant.this, STAFF);
                    }
                }
            }
        }
    }

    class MoveToTargetGoal
    extends Goal {
        @Nullable
        private LivingEntity target;

        MoveToTargetGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = StormCasterServant.this.m_5448_();
            if (StormCasterServant.this.isAttacking()) {
                return false;
            }
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return (double)this.target.m_20270_((Entity)StormCasterServant.this) > 13.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_() && (double)this.target.m_20270_((Entity)StormCasterServant.this) > 6.0 && !StormCasterServant.this.isAttacking();
        }

        public void m_8041_() {
            StormCasterServant.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.target != null) {
                StormCasterServant.this.m_21573_().m_5624_((Entity)this.target, (double)1.1f);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    protected abstract class StormCasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected StormCasterUseSpellGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = StormCasterServant.this.m_5448_();
            if (livingentity != null && livingentity.m_20270_((Entity)StormCasterServant.this) <= 16.0f && livingentity.m_6084_() && StormCasterServant.this.getCurrentAnimation() != StormCasterServant.this.getAnimationState(SHOCK)) {
                if (StormCasterServant.this.isCastingSpell()) {
                    return false;
                }
                return StormCasterServant.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = StormCasterServant.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            this.attackWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            StormCasterServant.this.castingTime = this.getCastingTime();
            this.nextAttackTickCount = StormCasterServant.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                StormCasterServant.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            StormCasterServant.this.setAnimationState(IDLE);
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                StormCasterServant.this.m_5496_(StormCasterServant.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        public boolean m_183429_() {
            return true;
        }
    }
}

