/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.AvoidTargetGoal;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.ally.illager.SpellcasterIllagerServant;
import com.Polarice3.Goety.common.entities.ally.undead.bound.BoundWindCaller;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.spells.wind.UpdraftSpell;
import com.Polarice3.Goety.common.magic.spells.wind.WindBlastSpell;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class WindCallerServant
extends SpellcasterIllagerServant {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(WindCallerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static String IDLE = "idle";
    public static String BLAST = "blast";
    public static String UPDRAFT = "updraft";
    public int blastCool = 0;
    public int updraftCool = 0;
    public ItemStack staff = new ItemStack((ItemLike)ModItems.WIND_STAFF.get());
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState blastAnimationState = new AnimationState();
    public AnimationState updraftAnimationState = new AnimationState();

    public WindCallerServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, new AvoidTargetGoal<LivingEntity>(this, LivingEntity.class, 3.0f, 1.0, 1.6));
        this.f_21345_.m_25352_(3, (Goal)new BlastGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new UpdraftGoal(this));
    }

    @Override
    public void miscGoal() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, new RaiderServant.RaiderWanderGoal<WindCallerServant>(this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.35).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.WindCallerServantFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.WindCallerServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.WindCallerServantHealth.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.WindCallerServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.WindCallerServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.WindCallerServantFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BlastCool", this.blastCool);
        compound.m_128405_("UpdraftCool", this.updraftCool);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BlastCool")) {
            this.blastCool = compound.m_128451_("BlastCool");
        }
        if (compound.m_128441_("UpdraftCool")) {
            this.updraftCool = compound.m_128451_("UpdraftCool");
        }
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 1;
        }
        if (Objects.equals(animation, BLAST)) {
            return 2;
        }
        if (Objects.equals(animation, UPDRAFT)) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.blastAnimationState);
        list.add(this.updraftAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.blastAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.blastAnimationState);
                    break;
                }
                case 3: {
                    this.updraftAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.updraftAnimationState);
                }
            }
        }
    }

    public boolean isAttacking() {
        return this.getCurrentAnimation() == this.getAnimationState(BLAST) || this.getCurrentAnimation() == this.getAnimationState(UPDRAFT);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        BoundWindCaller servant;
        if (!this.f_19853_.f_46443_ && this.getIdol() == null && this.getTrueOwner() != null && CuriosFinder.hasNamelessSet(this.getTrueOwner()) && (servant = (BoundWindCaller)this.m_21406_((EntityType)ModEntityType.BOUND_WIND_CALLER.get(), true)) != null) {
            servant.setTrueOwner(this.getTrueOwner());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)servant);
            if (!this.m_20067_()) {
                this.f_19853_.m_5898_((Player)null, 1026, this.m_20183_(), 0);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.WIND_CALLER_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WIND_CALLER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WIND_CALLER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_32654_) {
        return (SoundEvent)ModSounds.WIND_CALLER_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.m_5776_()) {
            this.idleAnimationState.m_246184_(!this.isAttacking() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        super.m_8119_();
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.blastCool > 0) {
                --this.blastCool;
            }
            if (this.updraftCool > 0) {
                --this.updraftCool;
            }
            if (this.m_6084_()) {
                ServerParticleUtil.windParticle(serverLevel, ColorUtil.WHITE, 0.5f + serverLevel.f_46441_.m_188501_() * 0.5f, 0.0f, this.m_19879_(), this.m_20182_());
                ColorUtil colorUtil = new ColorUtil(9274237);
                ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)ModParticleTypes.STATION_CULT_SPELL.get(), (Entity)this, colorUtil.red(), colorUtil.green(), colorUtil.blue(), 0.5f);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0 && !this.m_20068_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return null;
    }

    public static class BlastGoal
    extends Goal {
        public WindCallerServant windCaller;
        public boolean attack = false;
        public int spellTick;

        public BlastGoal(WindCallerServant windCaller) {
            this.windCaller = windCaller;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.windCaller.m_5448_() != null && this.windCaller.m_20270_((Entity)this.windCaller.m_5448_()) <= 6.75f) {
                return !this.windCaller.isAttacking() && this.windCaller.blastCool <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.spellTick <= MathHelper.secondsToTicks(2.55f) && this.windCaller.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.windCaller.setAnimationState(BLAST);
            this.windCaller.m_5496_((SoundEvent)ModSounds.WIND_CALLER_BLAST.get(), 1.2f, 1.0f);
            this.spellTick = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.attack = false;
            this.spellTick = 0;
            this.windCaller.blastCool = MathHelper.secondsToTicks(3);
            this.windCaller.setAnimationState(IDLE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.windCaller.m_5448_() == null) {
                this.m_8041_();
                return;
            }
            MobUtil.instaLook((Mob)this.windCaller, (Entity)this.windCaller.m_5448_());
            this.windCaller.m_21573_().m_26573_();
            ++this.spellTick;
            if (this.spellTick >= MathHelper.secondsToTicks(0.325f) && !this.attack) {
                new WindBlastSpell().mobSpellResult((LivingEntity)this.windCaller, this.windCaller.staff);
                this.attack = true;
            }
        }
    }

    public static class UpdraftGoal
    extends Goal {
        public WindCallerServant windCaller;
        public boolean attack = false;
        public boolean attack2 = false;
        public int spellTick;

        public UpdraftGoal(WindCallerServant windCaller) {
            this.windCaller = windCaller;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.windCaller.m_5448_() != null && (double)this.windCaller.m_20270_((Entity)this.windCaller.m_5448_()) <= this.windCaller.m_21133_(Attributes.f_22277_)) {
                return !this.windCaller.isAttacking() && this.windCaller.updraftCool <= 0;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.spellTick <= MathHelper.secondsToTicks(3.25f) && this.windCaller.m_5448_() != null;
        }

        public void m_8056_() {
            super.m_8056_();
            this.attack = false;
            this.attack2 = false;
            this.spellTick = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.attack = false;
            this.attack2 = false;
            this.spellTick = 0;
            this.windCaller.updraftCool = MathHelper.secondsToTicks(3);
            this.windCaller.setAnimationState(IDLE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.windCaller.m_5448_() == null) {
                this.m_8041_();
                return;
            }
            if ((double)this.windCaller.m_20270_((Entity)this.windCaller.m_5448_()) <= 13.0 || this.attack) {
                if (!this.attack) {
                    this.windCaller.setAnimationState(UPDRAFT);
                    this.windCaller.m_5496_((SoundEvent)ModSounds.WIND_CALLER_UPDRAFT.get(), 1.2f, 1.0f);
                    this.attack = true;
                }
                if (this.spellTick >= MathHelper.secondsToTicks(0.85f) && !this.attack2) {
                    new UpdraftSpell().mobSpellResult((LivingEntity)this.windCaller, this.windCaller.staff);
                    this.attack2 = true;
                }
                MobUtil.instaLook((Mob)this.windCaller, (Entity)this.windCaller.m_5448_());
                this.windCaller.m_21573_().m_26573_();
                ++this.spellTick;
            } else {
                this.windCaller.m_21573_().m_5624_((Entity)this.windCaller.m_5448_(), 1.1);
            }
        }
    }
}

