/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class SlashProjectile
extends Projectile {
    public static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(SlashProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int maxLifeSpan;
    public final int animationSeed;
    public float maxRadius;
    public AABB oldBB;
    public float damage = 6.0f;
    public int animationTime;
    private final List<Entity> victims = new ArrayList<Entity>();

    public SlashProjectile(EntityType<? extends SlashProjectile> entityType, Level level) {
        super(entityType, level);
        this.animationSeed = level.m_213780_().m_188503_(9999);
        this.setRadius(0.6f);
        this.maxRadius = 3.0f;
        this.maxLifeSpan = MathHelper.secondsToTicks(4);
        this.oldBB = this.m_20191_();
        this.m_20242_(true);
    }

    public SlashProjectile(EntityType<? extends SlashProjectile> entityType, Level levelIn, LivingEntity shooter) {
        this(entityType, levelIn);
        this.m_5602_((Entity)shooter);
        this.m_146922_(shooter.m_146908_());
        this.m_146926_(shooter.m_146909_());
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.5f));
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Lifespan", this.getMaxLifeSpan());
        pCompound.m_128350_("Radius", this.getRadius());
        pCompound.m_128350_("MaxRadius", this.getMaxRadius());
        pCompound.m_128350_("Damage", this.getDamage());
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Lifespan")) {
            this.setMaxLifeSpan(pCompound.m_128451_("Lifespan"));
        }
        if (pCompound.m_128441_("Radius")) {
            this.setRadius(pCompound.m_128457_("Radius"));
        }
        if (pCompound.m_128441_("MaxRadius")) {
            this.setMaxRadius(pCompound.m_128457_("MaxRadius"));
        }
        if (pCompound.m_128441_("Damage")) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (DATA_RADIUS.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public int getMaxLifeSpan() {
        return this.maxLifeSpan;
    }

    public void setMaxLifeSpan(int lifeSpan) {
        this.maxLifeSpan = lifeSpan;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)radius, (float)0.0f, (float)this.getMaxRadius())));
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(float radius) {
        this.maxRadius = radius;
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }

    public void slash(Vec3 rotation, double speed) {
        this.m_20256_(rotation.m_82490_(speed));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > this.getMaxLifeSpan()) {
            this.m_146870_();
            return;
        }
        this.oldBB = this.m_20191_();
        this.setRadius(this.getRadius() + 0.12f);
        if (!this.f_19853_.f_46443_) {
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)hitresult);
            }
            for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_())) {
                if (!this.m_5603_(entity) || this.victims.contains(entity)) continue;
                this.damageEntity(entity);
                this.victims.add(entity);
            }
        }
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        this.spawnParticles();
    }

    public void damageEntity(Entity entity) {
        entity.m_6469_(entity.m_269291_().m_269104_((Entity)this, this.m_19749_()), this.getDamage());
    }

    public ParticleOptions getParticle() {
        return ParticleTypes.f_123797_;
    }

    public void spawnParticles() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float width = (float)this.m_20191_().m_82362_();
            float step = 0.25f;
            float radians = (float)Math.PI / 180 * this.m_146908_();
            float speed = 0.1f;
            int i = 0;
            while ((float)i < width / step) {
                double x = this.m_20185_();
                double y = this.m_20186_();
                double z = this.m_20189_();
                double offset = step * ((float)i - width / step / 2.0f);
                double rotX = offset * Math.cos(radians);
                double rotZ = -offset * Math.sin(radians);
                double dx = Math.random() * (double)speed * 2.0 - (double)speed;
                double dy = Math.random() * (double)speed * 2.0 - (double)speed;
                double dz = Math.random() * (double)speed * 2.0 - (double)speed;
                serverLevel.m_8767_(this.getParticle(), x + rotX + dx, y + dy, z + rotZ + dz, 0, dx, dy, dz, 1.0);
                ++i;
            }
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        if (!this.f_19853_.m_8055_(hitResult.m_82425_()).m_60812_((BlockGetter)this.f_19853_, hitResult.m_82425_()).m_83281_() && !this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (this.m_19749_() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }
}

