ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event// kubejs/server_scripts/fstp.js
    event.register(
        Commands.literal("ftp_coord")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let dimension = ctx.source.getLevel().getDimension();
                let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepX")).getScore();
                let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepY")).getScore();
                let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepZ")).getScore();


                server.runCommandSilent(`execute in ${dimension} as ${username} at @s run tp ${x_value} ${y_value} ${z_value}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("vladat_wolf")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                server.runCommandSilent(`execute as ${username} run summon minecraft:wolf ~ ~1 ~ {Owner:${username},Tags:["controller"],CustomName:'"Minion"',CustomNameVisible:1}`);

                return 1;
            })
    );
});