/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.entity;

import insurgents.remake.project.init.InsurgentsModEntities;
import insurgents.remake.project.init.InsurgentsModItems;
import insurgents.remake.project.procedures.RifleRoundProjProjectileHitsBlockProcedure;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MGRoundProjEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)InsurgentsModItems.RIFLE_ROUND.get());
    public int lifeTicks = 0;
    private static final double BASE_SOUND_RADIUS = 64.0;
    private static final double MAX_SOUND_RADIUS = 150.0;

    public MGRoundProjEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)InsurgentsModEntities.MG_ROUND_PROJ.get(), world);
        this.m_20242_(true);
    }

    public MGRoundProjEntity(EntityType<? extends MGRoundProjEntity> type, Level world) {
        super(type, world);
        this.m_20242_(true);
    }

    public MGRoundProjEntity(EntityType<? extends MGRoundProjEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.m_20242_(true);
    }

    public MGRoundProjEntity(EntityType<? extends MGRoundProjEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.m_20242_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
        entity.f_19802_ = 0;
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        RifleRoundProjProjectileHitsBlockProcedure.execute((LevelAccessor)this.m_9236_(), blockHitResult.m_82425_().m_123341_(), blockHitResult.m_82425_().m_123342_(), blockHitResult.m_82425_().m_123343_());
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTicks;
        if (this.lifeTicks > 40 || this.f_36703_) {
            this.m_146870_();
        }
    }

    public static MGRoundProjEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return MGRoundProjEntity.shoot(world, entity, source, 1.25f, 5.0, 0);
    }

    public static MGRoundProjEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return MGRoundProjEntity.shoot(world, entity, source, pullingPower * 1.25f, 5.0, 0);
    }

    public static MGRoundProjEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        MGRoundProjEntity entityarrow = new MGRoundProjEntity((EntityType<? extends MGRoundProjEntity>)((EntityType)InsurgentsModEntities.MG_ROUND_PROJ.get()), entity, world);
        double inaccuracy = 0.03;
        double virtInaccuracy = 0.05;
        double dx = entity.m_20252_((float)1.0f).f_82479_ + (random.m_188500_() - 0.5) * inaccuracy;
        double dy = entity.m_20252_((float)1.0f).f_82480_ + (random.m_188500_() - 0.6) * virtInaccuracy;
        double dz = entity.m_20252_((float)1.0f).f_82481_ + (random.m_188500_() - 0.5) * inaccuracy;
        entityarrow.m_6686_(dx, dy, dz, power * 7.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        entityarrow.m_20242_(true);
        world.m_7967_((Entity)entityarrow);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            for (ServerPlayer sp : serverWorld.m_8795_(p -> !p.m_5833_())) {
                double distanceSq = sp.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                if (distanceSq <= 4096.0) {
                    sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:rpd_fire")))), SoundSource.PLAYERS, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f, 0L));
                    continue;
                }
                if (!(distanceSq <= 22500.0)) continue;
                sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:distant_rpd_fire")))), SoundSource.PLAYERS, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1.0f, 1.0f, 0L));
            }
        }
        return entityarrow;
    }

    public static MGRoundProjEntity shoot(LivingEntity shooter, LivingEntity target) {
        MGRoundProjEntity entityarrow = new MGRoundProjEntity((EntityType<? extends MGRoundProjEntity>)((EntityType)InsurgentsModEntities.MG_ROUND_PROJ.get()), shooter, shooter.m_9236_());
        double dx = target.m_20185_() - shooter.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - shooter.m_20188_();
        double dz = target.m_20189_() - shooter.m_20189_();
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double inaccuracy = 0.03;
        double virtInnaccuracy = 0.05;
        RandomSource rand = shooter.m_217043_();
        double nx = dx / distance + (rand.m_188500_() - 0.5) * inaccuracy;
        double ny = dy / distance + (rand.m_188500_() - 0.6) * virtInnaccuracy;
        double nz = dz / distance + (rand.m_188500_() - 0.5) * inaccuracy;
        entityarrow.m_6686_(nx, ny, nz, 4.5f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(2.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entityarrow.m_20242_(true);
        shooter.m_9236_().m_7967_((Entity)entityarrow);
        Level level = shooter.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            for (ServerPlayer sp : serverWorld.m_8795_(p -> !p.m_5833_())) {
                double distanceSq = sp.m_20275_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
                if (distanceSq <= 4096.0) {
                    sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:rpd_fire")))), SoundSource.PLAYERS, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f), 0L));
                    continue;
                }
                if (!(distanceSq <= 22500.0)) continue;
                sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:distant_rpd_fire")))), SoundSource.PLAYERS, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), 1.0f, 1.0f, 0L));
            }
        }
        return entityarrow;
    }
}

