/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.entity;

import insurgents.remake.project.entity.SniperRoundProjEntity;
import insurgents.remake.project.init.InsurgentsModEntities;
import insurgents.remake.project.procedures.InsurgentDeathTimeIsReachedProcedure;
import insurgents.remake.project.procedures.InsurgentEntityIsHurtProcedure;
import insurgents.remake.project.procedures.InsurgentNaturalEntitySpawningConditionProcedure;
import insurgents.remake.project.procedures.InsurgentOnEntityTickUpdateProcedure;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SniperInsurgentEntity
extends PathfinderMob
implements RangedAttackMob,
GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SniperInsurgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SniperInsurgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SniperInsurgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private int burstCount = 0;
    private int burstSize = 0;
    private int fireRateTicks = 20;
    private int burstDelayTicks = 0;
    private int reloadDelayTicks = 0;
    private boolean isFiring = false;
    private static final int MIN_BURST_SIZE = 1;
    private static final int MAX_BURST_SIZE = 1;
    private static final int MIN_RELOAD_DELAY = 20;
    private static final int MAX_RELOAD_DELAY = 60;
    private Random random = new Random();
    String prevAnim = "empty";

    public SniperInsurgentEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SniperInsurgentEntity>)((EntityType)InsurgentsModEntities.SNIPER_INSURGENT.get()), world);
    }

    public SniperInsurgentEntity(EntityType<SniperInsurgentEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 8;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"insurgent");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(10, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 5, 160.0f){

            @Override
            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        InsurgentEntityIsHurtProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128405_("BurstCount", this.burstCount);
        compound.m_128405_("BurstSize", this.burstSize);
        compound.m_128405_("FireRateTicks", this.fireRateTicks);
        compound.m_128405_("BurstDelayTicks", this.burstDelayTicks);
        compound.m_128405_("ReloadDelayTicks", this.reloadDelayTicks);
        compound.m_128379_("IsFiring", this.isFiring);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        this.burstCount = compound.m_128451_("BurstCount");
        this.burstSize = compound.m_128451_("BurstSize");
        this.fireRateTicks = compound.m_128451_("FireRateTicks");
        this.burstDelayTicks = compound.m_128451_("BurstDelayTicks");
        this.reloadDelayTicks = compound.m_128451_("ReloadDelayTicks");
        this.isFiring = compound.m_128471_("IsFiring");
    }

    public void m_6075_() {
        super.m_6075_();
        InsurgentOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public void m_6504_(LivingEntity target, float flval) {
        SniperRoundProjEntity.shoot((LivingEntity)this, target);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)InsurgentsModEntities.SNIPER_INSURGENT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int z;
            int y;
            int x = pos.m_123341_();
            return InsurgentNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y = pos.m_123342_(), z = pos.m_123343_()) && world.m_45524_(pos, 0) > 8;
        });
        DungeonHooks.addDungeonMob((EntityType)((EntityType)InsurgentsModEntities.SNIPER_INSURGENT.get()), (int)180);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 120.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk.Insurgent.Animation"));
            }
            if (this.m_21224_()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("Death.Insurgent.Animation"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("Idle.Insurgent.Animation"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
            InsurgentDeathTimeIsReachedProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 0, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class RangedAttackGoal
    extends Goal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public RangedAttackGoal(RangedAttackMob p_25768_, double p_25769_, int p_25770_, float p_25771_) {
            this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
        }

        public RangedAttackGoal(RangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
            if (!(p_25773_ instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackMob = p_25773_;
            this.mob = (Mob)p_25773_;
            this.speedModifier = p_25774_;
            this.attackIntervalMin = p_25775_;
            this.attackIntervalMax = p_25776_;
            this.attackRadius = p_25777_;
            this.attackRadiusSqr = p_25777_ * p_25777_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
            ((SniperInsurgentEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
            ((SniperInsurgentEntity)this.rangedAttackMob).isFiring = false;
            ((SniperInsurgentEntity)this.rangedAttackMob).burstCount = 0;
            ((SniperInsurgentEntity)this.rangedAttackMob).reloadDelayTicks = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            SniperInsurgentEntity sniperinsurgent = (SniperInsurgentEntity)this.rangedAttackMob;
            if (this.target == null || !this.target.m_6084_()) {
                return;
            }
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (sniperinsurgent.reloadDelayTicks > 0) {
                --sniperinsurgent.reloadDelayTicks;
                sniperinsurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                return;
            }
            if (!sniperinsurgent.isFiring) {
                sniperinsurgent.burstSize = sniperinsurgent.random.nextInt(1) + 1;
                sniperinsurgent.burstCount = 0;
                sniperinsurgent.isFiring = true;
                sniperinsurgent.burstDelayTicks = 0;
            }
            if (sniperinsurgent.isFiring) {
                if (sniperinsurgent.burstDelayTicks > 0) {
                    --sniperinsurgent.burstDelayTicks;
                    sniperinsurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                    return;
                }
                if (sniperinsurgent.burstCount < sniperinsurgent.burstSize) {
                    if (!flag) {
                        sniperinsurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                        sniperinsurgent.isFiring = false;
                        sniperinsurgent.burstCount = 0;
                        return;
                    }
                    sniperinsurgent.f_19804_.m_135381_(SHOOT, (Object)true);
                    float f = (float)Math.sqrt(d0) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    this.rangedAttackMob.m_6504_(this.target, f1);
                    ++sniperinsurgent.burstCount;
                    sniperinsurgent.burstDelayTicks = sniperinsurgent.fireRateTicks;
                } else {
                    sniperinsurgent.isFiring = false;
                    sniperinsurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                    sniperinsurgent.reloadDelayTicks = sniperinsurgent.random.nextInt(41) + 20;
                }
            }
        }
    }
}

