/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.entity.model;

import insurgents.remake.project.entity.InsurgentEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class InsurgentModel
extends GeoModel<InsurgentEntity> {
    public ResourceLocation getAnimationResource(InsurgentEntity entity) {
        return new ResourceLocation("insurgents", "animations/insurgent.animation.json");
    }

    public ResourceLocation getModelResource(InsurgentEntity entity) {
        return new ResourceLocation("insurgents", "geo/insurgent.geo.json");
    }

    public ResourceLocation getTextureResource(InsurgentEntity entity) {
        return new ResourceLocation("insurgents", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(InsurgentEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

