/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.init;

import insurgents.remake.project.entity.InsurgentEntity;
import insurgents.remake.project.entity.MGInsurgentEntity;
import insurgents.remake.project.entity.MGRoundProjEntity;
import insurgents.remake.project.entity.RifleRoundProjEntity;
import insurgents.remake.project.entity.SniperInsurgentEntity;
import insurgents.remake.project.entity.SniperRoundProjEntity;
import insurgents.remake.project.entity.SuicideInsurgentEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InsurgentsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"insurgents");
    public static final RegistryObject<EntityType<InsurgentEntity>> INSURGENT = InsurgentsModEntities.register("insurgent", EntityType.Builder.m_20704_(InsurgentEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(84).setUpdateInterval(3).setCustomClientFactory(InsurgentEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<RifleRoundProjEntity>> RIFLE_ROUND_PROJ = InsurgentsModEntities.register("rifle_round_proj", EntityType.Builder.m_20704_(RifleRoundProjEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(RifleRoundProjEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<SuicideInsurgentEntity>> SUICIDE_INSURGENT = InsurgentsModEntities.register("suicide_insurgent", EntityType.Builder.m_20704_(SuicideInsurgentEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SuicideInsurgentEntity::new).m_20699_(0.6f, 2.0f));
    public static final RegistryObject<EntityType<SniperInsurgentEntity>> SNIPER_INSURGENT = InsurgentsModEntities.register("sniper_insurgent", EntityType.Builder.m_20704_(SniperInsurgentEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(84).setUpdateInterval(3).setCustomClientFactory(SniperInsurgentEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<SniperRoundProjEntity>> SNIPER_ROUND_PROJ = InsurgentsModEntities.register("sniper_round_proj", EntityType.Builder.m_20704_(SniperRoundProjEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SniperRoundProjEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<MGInsurgentEntity>> MG_INSURGENT = InsurgentsModEntities.register("mg_insurgent", EntityType.Builder.m_20704_(MGInsurgentEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(84).setUpdateInterval(3).setCustomClientFactory(MGInsurgentEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<MGRoundProjEntity>> MG_ROUND_PROJ = InsurgentsModEntities.register("mg_round_proj", EntityType.Builder.m_20704_(MGRoundProjEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(MGRoundProjEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            InsurgentEntity.init();
            SuicideInsurgentEntity.init();
            SniperInsurgentEntity.init();
            MGInsurgentEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)INSURGENT.get(), InsurgentEntity.createAttributes().m_22265_());
        event.put((EntityType)SUICIDE_INSURGENT.get(), SuicideInsurgentEntity.createAttributes().m_22265_());
        event.put((EntityType)SNIPER_INSURGENT.get(), SniperInsurgentEntity.createAttributes().m_22265_());
        event.put((EntityType)MG_INSURGENT.get(), MGInsurgentEntity.createAttributes().m_22265_());
    }
}

