/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.entity;

import insurgents.remake.project.configuration.InsurgentsConfigConfiguration;
import insurgents.remake.project.init.InsurgentsModEntities;
import insurgents.remake.project.init.InsurgentsModItems;
import insurgents.remake.project.procedures.RifleRoundProjProjectileHitsBlockProcedure;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class MGRoundProjEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)InsurgentsModItems.RIFLE_ROUND.get());
    public int lifeTicks = 0;
    private static final double BASE_SOUND_RADIUS = 32.0;
    private static final double MAX_SOUND_RADIUS = 150.0;

    public MGRoundProjEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)InsurgentsModEntities.MG_ROUND_PROJ.get(), world);
        this.m_20242_(true);
    }

    public MGRoundProjEntity(EntityType<? extends MGRoundProjEntity> type, Level world) {
        super(type, world);
        this.m_20242_(true);
    }

    public MGRoundProjEntity(EntityType<? extends MGRoundProjEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.m_20242_(true);
    }

    public MGRoundProjEntity(EntityType<? extends MGRoundProjEntity> type, LivingEntity shooter, Level world) {
        super(type, shooter, world);
        this.m_20242_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
        entity.f_19802_ = 0;
    }

    public void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        RifleRoundProjProjectileHitsBlockProcedure.execute((LevelAccessor)this.m_9236_(), hit.m_82425_().m_123341_(), hit.m_82425_().m_123342_(), hit.m_82425_().m_123343_());
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTicks;
        if (this.lifeTicks > 40 || this.f_36703_) {
            this.m_146870_();
        }
    }

    public static MGRoundProjEntity shoot(Level world, LivingEntity shooter, RandomSource rand) {
        return MGRoundProjEntity.shoot(world, shooter, rand, 1.25f, (Double)InsurgentsConfigConfiguration.MGBASEDAMAGE.get(), 0);
    }

    public static MGRoundProjEntity shoot(Level world, LivingEntity shooter, RandomSource rand, float pullingPower) {
        return MGRoundProjEntity.shoot(world, shooter, rand, pullingPower * 1.25f, (Double)InsurgentsConfigConfiguration.MGBASEDAMAGE.get(), 0);
    }

    public static MGRoundProjEntity shoot(Level world, LivingEntity shooter, RandomSource rand, float power, double damage, int knockback) {
        MGRoundProjEntity bullet = new MGRoundProjEntity((EntityType<? extends MGRoundProjEntity>)((EntityType)InsurgentsModEntities.MG_ROUND_PROJ.get()), shooter, world);
        double horiz = (Double)InsurgentsConfigConfiguration.MGINACCURACY.get();
        double vert = (Double)InsurgentsConfigConfiguration.MGVIRTINACCURACY.get();
        double dx = shooter.m_20252_((float)1.0f).f_82479_ + (rand.m_188500_() - 0.5) * horiz;
        double dy = shooter.m_20252_((float)1.0f).f_82480_ + (rand.m_188500_() - 0.6) * vert;
        double dz = shooter.m_20252_((float)1.0f).f_82481_ + (rand.m_188500_() - 0.5) * horiz;
        bullet.m_6686_(dx, dy, dz, power * 7.0f, 0.0f);
        bullet.m_20225_(true);
        bullet.m_36762_(false);
        bullet.m_36781_(damage);
        bullet.m_36735_(knockback);
        bullet.m_20242_(true);
        world.m_7967_((Entity)bullet);
        MGRoundProjEntity.playShotSounds(world, shooter, rand, power);
        return bullet;
    }

    public static MGRoundProjEntity shoot(LivingEntity shooter, LivingEntity target) {
        MGRoundProjEntity bullet = new MGRoundProjEntity((EntityType<? extends MGRoundProjEntity>)((EntityType)InsurgentsModEntities.MG_ROUND_PROJ.get()), shooter, shooter.m_9236_());
        double damage = (Double)InsurgentsConfigConfiguration.MGBASEDAMAGE.get();
        double horiz = (Double)InsurgentsConfigConfiguration.MGINACCURACY.get();
        double vert = (Double)InsurgentsConfigConfiguration.MGVIRTINACCURACY.get();
        double dx = target.m_20185_() - shooter.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - shooter.m_20188_();
        double dz = target.m_20189_() - shooter.m_20189_();
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        RandomSource rand = shooter.m_217043_();
        double nx = dx / dist + (rand.m_188500_() - 0.5) * horiz;
        double ny = dy / dist + (rand.m_188500_() - 0.6) * vert;
        double nz = dz / dist + (rand.m_188500_() - 0.5) * horiz;
        bullet.m_6686_(nx, ny, nz, 4.5f, 0.0f);
        bullet.m_20225_(true);
        bullet.m_36781_(damage);
        bullet.m_36735_(0);
        bullet.m_36762_(false);
        bullet.m_20242_(true);
        shooter.m_9236_().m_7967_((Entity)bullet);
        MGRoundProjEntity.playShotSounds(shooter.m_9236_(), shooter, rand, 4.5f);
        return bullet;
    }

    private static void playShotSounds(Level world, LivingEntity shooter, RandomSource rand, float power) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (ServerPlayer sp : serverWorld.m_8795_(p -> !p.m_5833_())) {
                double d2 = sp.m_20275_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
                if (d2 <= 1024.0) {
                    sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:rpd_fire")))), SoundSource.PLAYERS, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), 1.0f, 1.0f / (rand.m_188501_() * 0.5f + 1.0f) + power / 2.0f, 0L));
                    continue;
                }
                if (!(d2 <= 22500.0)) continue;
                sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:distant_rpd_fire")))), SoundSource.PLAYERS, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), 1.0f, 1.0f, 0L));
            }
        }
    }
}

