/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.entity;

import insurgents.remake.project.configuration.InsurgentsConfigConfiguration;
import insurgents.remake.project.entity.SniperRoundProjEntity;
import insurgents.remake.project.init.InsurgentsModEntities;
import insurgents.remake.project.procedures.InsurgentDeathTimeIsReachedProcedure;
import insurgents.remake.project.procedures.InsurgentEntityIsHurtProcedure;
import insurgents.remake.project.procedures.InsurgentNaturalEntitySpawningConditionProcedure;
import insurgents.remake.project.procedures.InsurgentOnEntityTickUpdateProcedure;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SniperInsurgentEntity
extends PathfinderMob
implements RangedAttackMob,
GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SniperInsurgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SniperInsurgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SniperInsurgentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private int burstCount = 0;
    private int burstSize = 0;
    private int fireRateTicks = 20;
    private int burstDelayTicks = 0;
    private int reloadDelayTicks = 0;
    private boolean isFiring = false;
    private static final int MIN_BURST_SIZE = 1;
    private static final int MAX_BURST_SIZE = 1;
    private static final int MIN_RELOAD_DELAY = 20;
    private static final int MAX_RELOAD_DELAY = 60;
    private final Random random = new Random();
    private String prevAnim = "empty";

    public SniperInsurgentEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SniperInsurgentEntity>)((EntityType)InsurgentsModEntities.SNIPER_INSURGENT.get()), world);
    }

    public SniperInsurgentEntity(EntityType<SniperInsurgentEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 8;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.m_21530_();
        try {
            double hp = (Double)InsurgentsConfigConfiguration.SNIPERINSURGENTHEALTHVALUE.get();
            double move = (Double)InsurgentsConfigConfiguration.SNIPERINSURGENTMOVEMENTVALUE.get();
            double follow = (Double)InsurgentsConfigConfiguration.SNIPERINSURGENTFOLLOWVALUE.get();
            if (this.m_21051_(Attributes.f_22276_) != null) {
                this.m_21051_(Attributes.f_22276_).m_22100_(hp);
            }
            if (this.m_21051_(Attributes.f_22279_) != null) {
                this.m_21051_(Attributes.f_22279_).m_22100_(move);
            }
            if (this.m_21051_(Attributes.f_22277_) != null) {
                this.m_21051_(Attributes.f_22277_).m_22100_(follow);
            }
            this.m_21153_((float)hp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"insurgent");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(10, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 5, 160.0f){

            @Override
            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource src, float amt) {
        InsurgentEntityIsHurtProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        return super.m_6469_(src, amt);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("Texture", this.getTexture());
        tag.m_128405_("BurstCount", this.burstCount);
        tag.m_128405_("BurstSize", this.burstSize);
        tag.m_128405_("FireRateTicks", this.fireRateTicks);
        tag.m_128405_("BurstDelayTicks", this.burstDelayTicks);
        tag.m_128405_("ReloadDelayTicks", this.reloadDelayTicks);
        tag.m_128379_("IsFiring", this.isFiring);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Texture")) {
            this.setTexture(tag.m_128461_("Texture"));
        }
        this.burstCount = tag.m_128451_("BurstCount");
        this.burstSize = tag.m_128451_("BurstSize");
        this.fireRateTicks = tag.m_128451_("FireRateTicks");
        this.burstDelayTicks = tag.m_128451_("BurstDelayTicks");
        this.reloadDelayTicks = tag.m_128451_("ReloadDelayTicks");
        this.isFiring = tag.m_128471_("IsFiring");
    }

    public void m_6075_() {
        super.m_6075_();
        InsurgentOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.0f);
    }

    public void m_6504_(LivingEntity tgt, float p) {
        SniperRoundProjEntity.shoot((LivingEntity)this, tgt);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)InsurgentsModEntities.SNIPER_INSURGENT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> InsurgentNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) && world.m_45524_(pos, 0) > 8);
        DungeonHooks.addDungeonMob((EntityType)((EntityType)InsurgentsModEntities.SNIPER_INSURGENT.get()), (int)180);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 120.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData result = super.m_6518_(level, diff, reason, data, tag);
        double hp = (Double)InsurgentsConfigConfiguration.SNIPERINSURGENTHEALTHVALUE.get();
        double move = (Double)InsurgentsConfigConfiguration.SNIPERINSURGENTMOVEMENTVALUE.get();
        double follow = (Double)InsurgentsConfigConfiguration.SNIPERINSURGENTFOLLOWVALUE.get();
        if (this.m_21051_(Attributes.f_22276_) != null) {
            this.m_21051_(Attributes.f_22276_).m_22100_(hp);
        }
        if (this.m_21051_(Attributes.f_22279_) != null) {
            this.m_21051_(Attributes.f_22279_).m_22100_(move);
        }
        if (this.m_21051_(Attributes.f_22277_) != null) {
            this.m_21051_(Attributes.f_22277_).m_22100_(follow);
        }
        this.m_21153_((float)hp);
        return result;
    }

    private PlayState movementPredicate(AnimationState e) {
        if (this.animationprocedure.equals("empty")) {
            if (e.isMoving() || !(e.getLimbSwingAmount() > -0.15f) || !(e.getLimbSwingAmount() < 0.15f)) {
                return e.setAndContinue(RawAnimation.begin().thenLoop("walk.Insurgent.Animation"));
            }
            if (this.m_21224_()) {
                return e.setAndContinue(RawAnimation.begin().thenPlay("Death.Insurgent.Animation"));
            }
            return e.setAndContinue(RawAnimation.begin().thenLoop("Idle.Insurgent.Animation"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState e) {
        if (!this.animationprocedure.equals("empty") && e.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                e.getController().forceAnimationReset();
            }
            e.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (e.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                e.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 100) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
            InsurgentDeathTimeIsReachedProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 0, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class RangedAttackGoal
    extends Goal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        @Nullable
        private LivingEntity target;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public RangedAttackGoal(RangedAttackMob mob, double speed, int interval, float radius) {
            this(mob, speed, interval, interval, radius);
        }

        public RangedAttackGoal(RangedAttackMob mob, double speed, int min, int max, float radius) {
            if (!(mob instanceof LivingEntity)) {
                throw new IllegalArgumentException("Requires LivingEntity");
            }
            this.rangedAttackMob = mob;
            this.mob = (Mob)mob;
            this.speedModifier = speed;
            this.attackIntervalMin = min;
            this.attackIntervalMax = max;
            this.attackRadius = radius;
            this.attackRadiusSqr = radius * radius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null && target.m_6084_()) {
                this.target = target;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            ((SniperInsurgentEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
            ((SniperInsurgentEntity)this.rangedAttackMob).isFiring = false;
            ((SniperInsurgentEntity)this.rangedAttackMob).burstCount = 0;
            ((SniperInsurgentEntity)this.rangedAttackMob).reloadDelayTicks = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            SniperInsurgentEntity insurgent = (SniperInsurgentEntity)this.rangedAttackMob;
            if (this.target == null || !this.target.m_6084_()) {
                return;
            }
            double dist = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean sight = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = sight ? ++this.seeTime : 0;
            if (!(dist > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (insurgent.reloadDelayTicks > 0) {
                --insurgent.reloadDelayTicks;
                insurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                return;
            }
            if (!insurgent.isFiring) {
                insurgent.burstSize = insurgent.random.nextInt(1) + 1;
                insurgent.burstCount = 0;
                insurgent.isFiring = true;
                insurgent.burstDelayTicks = 0;
            }
            if (insurgent.isFiring) {
                if (insurgent.burstDelayTicks > 0) {
                    --insurgent.burstDelayTicks;
                    insurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                    return;
                }
                if (insurgent.burstCount < insurgent.burstSize) {
                    if (!sight) {
                        insurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                        insurgent.isFiring = false;
                        insurgent.burstCount = 0;
                        return;
                    }
                    insurgent.f_19804_.m_135381_(SHOOT, (Object)true);
                    float f = (float)Math.sqrt(dist) / this.attackRadius;
                    float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                    this.rangedAttackMob.m_6504_(this.target, f1);
                    ++insurgent.burstCount;
                    insurgent.burstDelayTicks = insurgent.fireRateTicks;
                } else {
                    insurgent.isFiring = false;
                    insurgent.f_19804_.m_135381_(SHOOT, (Object)false);
                    insurgent.reloadDelayTicks = insurgent.random.nextInt(41) + 20;
                }
            }
        }
    }
}

