/*
 * Decompiled with CFR 0.152.
 */
package insurgents.remake.project.entity;

import insurgents.remake.project.configuration.InsurgentsConfigConfiguration;
import insurgents.remake.project.init.InsurgentsModEntities;
import insurgents.remake.project.procedures.InsurgentEntityIsHurtProcedure;
import insurgents.remake.project.procedures.InsurgentNaturalEntitySpawningConditionProcedure;
import insurgents.remake.project.procedures.InsurgentOnEntityTickUpdateProcedure;
import insurgents.remake.project.procedures.SuicideInsurgentPlayerCollidesWithThisEntityProcedure;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SuicideInsurgentEntity
extends PathfinderMob {
    public SuicideInsurgentEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SuicideInsurgentEntity>)((EntityType)InsurgentsModEntities.SUICIDE_INSURGENT.get()), world);
    }

    public SuicideInsurgentEntity(EntityType<SuicideInsurgentEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 5;
        this.m_21557_(false);
        this.m_21530_();
        try {
            double hp = (Double)InsurgentsConfigConfiguration.SUICIDEINSURGENTHEALTHVALUE.get();
            double move = (Double)InsurgentsConfigConfiguration.SUICIDEINSURGENTMOVEMENTVALUE.get();
            double follow = (Double)InsurgentsConfigConfiguration.SUICIDEINSURGENTFOLLOWVALUE.get();
            if (this.m_21051_(Attributes.f_22276_) != null) {
                this.m_21051_(Attributes.f_22276_).m_22100_(hp);
            }
            if (this.m_21051_(Attributes.f_22279_) != null) {
                this.m_21051_(Attributes.f_22279_).m_22100_(move);
            }
            if (this.m_21051_(Attributes.f_22277_) != null) {
                this.m_21051_(Attributes.f_22277_).m_22100_(follow);
            }
            this.m_21153_((float)hp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal(this, 1.2, true){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(10, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:explosion"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        InsurgentEntityIsHurtProcedure.execute((LevelAccessor)this.m_9236_(), x, y, z);
        return super.m_6469_(damagesource, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        SuicideInsurgentPlayerCollidesWithThisEntityProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (!this.m_9236_().m_5776_()) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            for (Player player : this.m_9236_().m_6907_()) {
                double d2 = player.m_20275_(x, y, z);
                if (d2 <= 576.0) {
                    player.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:explosion")), 1.0f, 1.0f);
                    continue;
                }
                if (d2 <= 19600.0) {
                    player.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:distantexplosion")), 1.0f, 1.0f);
                    continue;
                }
                if (!(d2 <= 57600.0)) continue;
                player.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("insurgents:superdistantexplosion")), 1.0f, 1.0f);
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        InsurgentOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this);
    }

    public void m_6123_(Player sourceentity) {
        super.m_6123_(sourceentity);
        SuicideInsurgentPlayerCollidesWithThisEntityProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData result = super.m_6518_(level, diff, reason, data, tag);
        double hp = (Double)InsurgentsConfigConfiguration.SUICIDEINSURGENTHEALTHVALUE.get();
        double move = (Double)InsurgentsConfigConfiguration.SUICIDEINSURGENTMOVEMENTVALUE.get();
        double follow = (Double)InsurgentsConfigConfiguration.SUICIDEINSURGENTFOLLOWVALUE.get();
        if (this.m_21051_(Attributes.f_22276_) != null) {
            this.m_21051_(Attributes.f_22276_).m_22100_(hp);
        }
        if (this.m_21051_(Attributes.f_22279_) != null) {
            this.m_21051_(Attributes.f_22279_).m_22100_(move);
        }
        if (this.m_21051_(Attributes.f_22277_) != null) {
            this.m_21051_(Attributes.f_22277_).m_22100_(follow);
        }
        this.m_21153_((float)hp);
        return result;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)InsurgentsModEntities.SUICIDE_INSURGENT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> InsurgentNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) && world.m_45524_(pos, 0) > 8);
        DungeonHooks.addDungeonMob((EntityType)((EntityType)InsurgentsModEntities.SUICIDE_INSURGENT.get()), (int)180);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0);
    }
}

