/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.authBB;

import io.github.altkat.authBB.BossBars.LoginBossBar;
import io.github.altkat.authBB.BossBars.RegisterBossBar;
import io.github.altkat.authBB.Commands.AuthBBCommand;
import io.github.altkat.authBB.Commands.AuthBBTabCompleter;
import io.github.altkat.authBB.Handlers.ConfigUpdater;
import io.github.altkat.authBB.Handlers.ConnectionHandler;
import io.github.altkat.authBB.Handlers.Listeners;
import io.github.altkat.authBB.Handlers.MessageManager;
import io.github.altkat.authBB.Handlers.UpdateChecker;
import io.github.altkat.authBB.Titles.ConnectionTitle;
import io.github.altkat.authBB.Titles.LoginTitle;
import io.github.altkat.authBB.Titles.RegisterTitle;
import io.github.altkat.authBB.bukkit.Metrics;
import io.github.altkat.authBB.lib.paperlib.PaperLib;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class AuthBB
extends JavaPlugin {
    private ConnectionHandler connectionHandler;
    private MessageManager messageManager;
    private LoginBossBar loginBossBar;
    private RegisterBossBar registerBossBar;
    private LoginTitle loginTitle;
    private RegisterTitle registerTitle;
    private ConnectionTitle connectionTitle;
    private boolean isProxyModeActive = false;

    public void onEnable() {
        new Metrics(this, 23372);
        this.reload();
        this.registerListenersAndCommands();
        int SPIGOT_RESOURCE_ID = 118798;
        new UpdateChecker(this, 118798).getVersion(newVersion -> {
            if (UpdateChecker.isNewerVersion(this.getDescription().getVersion(), newVersion)) {
                this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eA new update is available! Version: " + newVersion);
                this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eDownload it from: https://www.spigotmc.org/resources/authbb-enhanced-boss-bar-integration-for-authme-proxy-teleport-multi-lobby-support.118798/");
            } else {
                this.getServer().getConsoleSender().sendMessage("\u00a7f[AuthBB] You are using the latest version. (" + this.getDescription().getVersion() + ")");
            }
        });
        this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7aAuthBB has been enabled!");
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7cAuthBB has been disabled!");
    }

    public void reload() {
        this.saveDefaultConfig();
        try {
            ConfigUpdater.update(this);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not update config.yml! Please check file permissions.");
            e.printStackTrace();
        }
        this.reloadConfig();
        if (this.getServer().getPluginManager().getPlugin("AuthMe") == null) {
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7cAuthMe is not installed! Disabling AuthBB...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.initializeManagers();
        this.setupProxy();
    }

    private void initializeManagers() {
        this.messageManager = new MessageManager(this);
        this.connectionHandler = new ConnectionHandler(this);
        this.loginBossBar = new LoginBossBar(this);
        this.registerBossBar = new RegisterBossBar(this);
        this.loginTitle = new LoginTitle(this);
        this.registerTitle = new RegisterTitle(this);
        this.connectionTitle = new ConnectionTitle(this);
    }

    private void setupProxy() {
        boolean isProxyEnabledInConfig = this.getConfig().getBoolean("Proxy.enabled", false);
        boolean isForceProxyEnabledInConfig = this.getConfig().getBoolean("Proxy.force-proxy", false);
        if (!isProxyEnabledInConfig) {
            this.isProxyModeActive = false;
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7cProxy support is disabled in the config file.");
            return;
        }
        if (isForceProxyEnabledInConfig) {
            this.isProxyModeActive = true;
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eForce Proxy mode is enabled. Skipping bungee/velocity checks! Forcing to enable the proxy mode.");
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this.connectionHandler);
            return;
        }
        if (this.isProxyDetected()) {
            this.isProxyModeActive = true;
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7aProxy mode is enabled. Server is running under a proxy (BungeeCord/Velocity).");
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this.connectionHandler);
        } else {
            this.isProxyModeActive = false;
        }
    }

    private void registerListenersAndCommands() {
        new Listeners(this);
        this.getCommand("authbb").setExecutor((CommandExecutor)new AuthBBCommand(this));
        this.getCommand("authbb").setTabCompleter((TabCompleter)new AuthBBTabCompleter(this));
    }

    private boolean isProxyDetected() {
        boolean isBungee = this.getServer().spigot().getConfig().getBoolean("settings.bungeecord", false);
        boolean isVelocity = this.isVelocitySupported();
        if (isBungee && isVelocity) {
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7c[CRITICAL CONFIG ERROR] Both BungeeCord and Velocity support are enabled at the same time!");
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7cThis will cause IP forwarding issues. Please choose ONLY ONE proxy type.");
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7cRecommendation: If you use Velocity, set 'bungeecord: false' in spigot.yml.");
            this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7cProxy features will be disabled until this is fixed. (If you want to bypass this, set force-proxy to true in the config file.)");
            return false;
        }
        if (isBungee || isVelocity) {
            return true;
        }
        this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eProxy mode is enabled in config.yml, but no proxy environment was detected.");
        this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eFor BungeeCord, set 'bungeecord: true' in spigot.yml.");
        this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eFor Velocity, enable velocity support in your proxy and server configs.");
        this.getServer().getConsoleSender().sendMessage("\u00a79[\u00a76AuthBB\u00a79] \u00a7eProxy features will now be disabled to prevent errors. (If you want to bypass this, set force-proxy to true in the config file.)");
        return false;
    }

    private boolean isVelocitySupported() {
        if (!PaperLib.isPaper()) {
            return false;
        }
        try {
            Class<?> globalConfigClass = Class.forName("io.papermc.paper.configuration.GlobalConfiguration");
            Method getMethod = globalConfigClass.getMethod("get", new Class[0]);
            Object globalConfig = getMethod.invoke(null, new Object[0]);
            Field proxiesField = globalConfig.getClass().getDeclaredField("proxies");
            proxiesField.setAccessible(true);
            Object proxies = proxiesField.get(globalConfig);
            Field velocityField = proxies.getClass().getDeclaredField("velocity");
            velocityField.setAccessible(true);
            Object velocity = velocityField.get(proxies);
            Field enabledField = velocity.getClass().getDeclaredField("enabled");
            enabledField.setAccessible(true);
            return (Boolean)enabledField.get(velocity);
        }
        catch (Exception ignored) {
            return this.getServer().spigot().getConfig().getBoolean("settings.velocity-support.enabled", false);
        }
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public LoginBossBar getLoginBossBar() {
        return this.loginBossBar;
    }

    public RegisterBossBar getRegisterBossBar() {
        return this.registerBossBar;
    }

    public LoginTitle getLoginTitle() {
        return this.loginTitle;
    }

    public RegisterTitle getRegisterTitle() {
        return this.registerTitle;
    }

    public ConnectionTitle getConnectionTitle() {
        return this.connectionTitle;
    }

    public boolean isProxyModeActive() {
        return this.isProxyModeActive;
    }
}

