/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.authBB.Commands;

import fr.xephi.authme.api.v3.AuthMeApi;
import io.github.altkat.authBB.AuthBB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AuthBBCommand
implements CommandExecutor {
    private final AuthBB plugin;
    private final AuthMeApi authMe;

    public AuthBBCommand(AuthBB plugin) {
        this.plugin = plugin;
        this.authMe = AuthMeApi.getInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            sender.sendMessage("\u00a7b/authbb help");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "help": {
                return this.handleHelpCommand(sender);
            }
            case "reload": {
                return this.handleReloadCommand(sender);
            }
            case "server": {
                return this.handleServerCommand(sender, args);
            }
            case "send": {
                return this.handleSendCommand(sender, args);
            }
        }
        sender.sendMessage(this.plugin.getMessageManager().WRONG_USAGE_SERVER.replace("/server servername", "/authbb help"));
        return true;
    }

    private boolean handleHelpCommand(CommandSender sender) {
        if (sender.hasPermission("AuthBB.admin")) {
            sender.sendMessage("\u00a7b==========[ AuthBossBar Admin HELP ]==========");
            sender.sendMessage("  \u00a7f/authbb server <server>: Connect to a lobby server.");
            sender.sendMessage("  \u00a7f/authbb send <player> <server>: Send a player to a lobby server.");
            sender.sendMessage("  \u00a7f/authbb reload: Reloads the configuration file.");
            sender.sendMessage("  \u00a7f/authbb help: Shows this help page.");
        } else {
            sender.sendMessage("\u00a7b==========[ AuthBossBar HELP ]==========");
            sender.sendMessage("  \u00a7f/authbb server <server>: Connect to a lobby server.");
            sender.sendMessage("  \u00a7f/authbb help: Shows this help page.");
        }
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        if (!sender.hasPermission("AuthBB.admin")) {
            sender.sendMessage(this.plugin.getMessageManager().NO_PERMISSION);
            return true;
        }
        this.plugin.reload();
        sender.sendMessage(ChatColor.GREEN + "AuthBB configuration has been reloaded.");
        return true;
    }

    private boolean handleServerCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("AuthBB.server")) {
            sender.sendMessage(this.plugin.getMessageManager().NO_PERMISSION);
            return true;
        }
        if (!this.plugin.isProxyModeActive()) {
            sender.sendMessage(this.plugin.getMessageManager().DISABLED);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().ONLY_PLAYERS);
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getMessageManager().WRONG_USAGE_SERVER.replace("servername", "<server>"));
            return true;
        }
        String targetServer = args[1];
        if (!this.plugin.getConfig().getStringList("Proxy.servers").contains(targetServer)) {
            sender.sendMessage(this.plugin.getMessageManager().SERVER_NOT_FOUND);
            return true;
        }
        this.plugin.getConnectionHandler().connectServer((Player)sender, targetServer);
        return true;
    }

    private boolean handleSendCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("AuthBB.send")) {
            sender.sendMessage(this.plugin.getMessageManager().NO_PERMISSION);
            return true;
        }
        if (!this.plugin.isProxyModeActive()) {
            sender.sendMessage(this.plugin.getMessageManager().DISABLED);
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(this.plugin.getMessageManager().WRONG_USAGE_SEND.replace("(player) (server)", "<player> <server>"));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayerExact((String)args[1]);
        if (targetPlayer == null) {
            sender.sendMessage(this.plugin.getMessageManager().PLAYER_NOT_FOUND);
            return true;
        }
        String targetServer = args[2];
        if (!this.plugin.getConfig().getStringList("Proxy.servers").contains(targetServer)) {
            sender.sendMessage(this.plugin.getMessageManager().SERVER_NOT_FOUND);
            return true;
        }
        if (!this.authMe.isAuthenticated(targetPlayer)) {
            sender.sendMessage(this.plugin.getMessageManager().PLAYER_NOT_AUTHENTICATED);
        } else if (this.plugin.getConnectionHandler().isPlayerSending(targetPlayer)) {
            sender.sendMessage(this.plugin.getMessageManager().PLAYER_ALREADY_CONNECTING);
        } else {
            this.plugin.getLogger().info("Sending player " + targetPlayer.getName() + " to server " + targetServer);
            this.plugin.getConnectionHandler().connectServer(targetPlayer, targetServer);
            sender.sendMessage(this.plugin.getMessageManager().SEND_SUCCESS_SENDER.replace("%player%", targetPlayer.getName()).replace("%server%", targetServer));
            targetPlayer.sendMessage(this.plugin.getMessageManager().SEND_SUCCESS_SENT);
        }
        return true;
    }
}

