/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.authBB.Commands;

import io.github.altkat.authBB.AuthBB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class AuthBBTabCompleter
implements TabCompleter {
    private final AuthBB plugin;

    public AuthBBTabCompleter(AuthBB plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>(Arrays.asList("help", "server"));
            if (sender.hasPermission("AuthBB.admin")) {
                subCommands.add("reload");
                subCommands.add("send");
            }
            return this.filterCompletions(subCommands, args[0]);
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("server") && args.length == 2) {
            if (this.plugin.isProxyModeActive() && sender.hasPermission("AuthBB.server")) {
                return this.filterCompletions(this.plugin.getConfig().getStringList("Proxy.servers"), args[1]);
            }
        } else if (subCommand.equals("send") && this.plugin.isProxyModeActive() && sender.hasPermission("AuthBB.send")) {
            if (args.length == 2) {
                List<String> playerNames = Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
                return this.filterCompletions(playerNames, args[1]);
            }
            if (args.length == 3) {
                return this.filterCompletions(this.plugin.getConfig().getStringList("Proxy.servers"), args[2]);
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(List<String> list, String input) {
        return list.stream().filter(s -> s.toLowerCase().startsWith(input.toLowerCase())).collect(Collectors.toList());
    }
}

