/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.authBB.Handlers;

import fr.xephi.authme.api.v3.AuthMeApi;
import io.github.altkat.authBB.AuthBB;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Listeners
implements Listener {
    private final AuthBB plugin;
    private final AuthMeApi authMe;

    public Listeners(AuthBB plugin) {
        this.plugin = plugin;
        this.authMe = AuthMeApi.getInstance();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (this.authMe.isRegistered(player.getName())) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.plugin.getLoginTitle().sendTitle(player);
                    this.plugin.getLoginBossBar().createBB(player);
                });
            } else {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    this.plugin.getRegisterTitle().sendTitle(player);
                    this.plugin.getRegisterBossBar().createBB(player);
                });
            }
        });
        if (this.plugin.getConfig().getBoolean("Extras.teleport-on-join", false)) {
            player.teleport(this.returnLocation(player.getWorld()));
        }
        if (this.plugin.getConfig().getBoolean("Extras.makeInvisible", false)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, -1, 0, true, false));
        }
        if (this.plugin.getConfig().getBoolean("Extras.removeJoinMessage", false)) {
            event.setJoinMessage("");
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        PotionEffect invisibilityEffect;
        Player player;
        if (this.plugin.getConfig().getBoolean("Extras.removeLeaveMessage", false)) {
            event.setQuitMessage("");
        }
        if ((player = event.getPlayer()).hasPotionEffect(PotionEffectType.INVISIBILITY) && (invisibilityEffect = player.getPotionEffect(PotionEffectType.INVISIBILITY)) != null && invisibilityEffect.isAmbient() && !invisibilityEffect.hasParticles()) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.plugin.getConfig().getBoolean("Extras.disableChat", false)) {
            if (this.authMe.isAuthenticated(event.getPlayer())) {
                event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cYou cannot chat in this server!"));
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (this.plugin.getConfig().getBoolean("Extras.preventMovement", false)) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (to == null) {
                return;
            }
            if (from.getBlockX() != to.getBlockX() || from.getBlockZ() != to.getBlockZ()) {
                event.setTo(from);
            }
        }
    }

    private Location returnLocation(World world) {
        List coordinateList = this.plugin.getConfig().getDoubleList("Extras.teleport-coordinates");
        if (coordinateList.size() < 5) {
            this.plugin.getLogger().warning("teleport-coordinates in config.yml is not configured correctly! Needs 5 values (x, y, z, yaw, pitch).");
            return world.getSpawnLocation();
        }
        double x = (Double)coordinateList.get(0);
        double y = (Double)coordinateList.get(1);
        double z = (Double)coordinateList.get(2);
        float yaw = ((Double)coordinateList.get(3)).floatValue();
        float pitch = ((Double)coordinateList.get(4)).floatValue();
        return new Location(world, x, y, z, yaw, pitch);
    }
}

