/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.core.ui.page;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.jan.moddirector.core.manage.select.InstallSelector;
import net.jan.moddirector.core.manage.select.SelectableInstallOption;

public class ModSelectionPage
extends JPanel {
    public ModSelectionPage(InstallSelector selector) {
        this.setLayout(new BoxLayout(this, 1));
        JLabel titleLabel = new JLabel("Select files to download", 0);
        titleLabel.setFont(new Font(titleLabel.getFont().getName(), 1, 20));
        titleLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, titleLabel.getMinimumSize().height));
        this.add(titleLabel);
        selector.getSingleOptions().forEach(this::setupSingleOption);
        selector.getGroupOptions().forEach(this::setupGroupOption);
    }

    private void setupSingleOption(SelectableInstallOption option) {
        String borderText = option.getSource().startsWith("http") ? "URL" : option.getSource();
        JPanel optionPanel = new JPanel(new BorderLayout());
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        optionPanel.setBorder(BorderFactory.createTitledBorder(borderText));
        String checkboxText = option.getSource().startsWith("http") ? option.getSource() : option.getName();
        JCheckBox installCheckBox = new JCheckBox(checkboxText, option.isSelected());
        installCheckBox.addItemListener(e -> option.setSelected(installCheckBox.isSelected()));
        optionPanel.add(installCheckBox);
        if (option.getDescription() != null) {
            optionPanel.add(new JLabel(this.asHtml(option.getDescription())));
        }
        this.add(optionPanel);
    }

    private void setupGroupOption(String groupName, List<SelectableInstallOption> options) {
        JPanel groupPanel = new JPanel();
        groupPanel.setLayout(new BoxLayout(groupPanel, 1));
        ButtonGroup group = new ButtonGroup();
        for (SelectableInstallOption option : options) {
            JPanel optionPanel = new JPanel();
            optionPanel.setLayout(new BoxLayout(optionPanel, 1));
            JRadioButton installRadioButton = new JRadioButton(option.getName(), option.isSelected());
            installRadioButton.addItemListener(e -> option.setSelected(installRadioButton.isSelected()));
            group.add(installRadioButton);
            optionPanel.add(installRadioButton);
            if (option.getDescription() != null) {
                optionPanel.add(new JLabel(this.asHtml(option.getDescription())));
            }
            groupPanel.add(optionPanel);
        }
        groupPanel.setBorder(BorderFactory.createTitledBorder(groupName));
        this.add(groupPanel);
    }

    private String asHtml(String content) {
        return "<html>" + content + "</html>";
    }
}

