/*
 * Decompiled with CFR 0.152.
 */
package net.jan.moddirector.launchwrapper;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jan.moddirector.core.ModDirector;
import net.jan.moddirector.core.logging.ModDirectorSeverityLevel;
import net.jan.moddirector.launchwrapper.LaunchwrapperModDirectorPlatform;
import net.jan.moddirector.launchwrapper.forge.ForgeLateLoader;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ModDirectorTweaker
implements ITweaker {
    private final ModDirector director = ModDirector.bootstrap(new LaunchwrapperModDirectorPlatform(this));
    private List<String> args;
    private File gameDir;
    private File assetsDir;
    private String profile;
    private LaunchClassLoader classLoader;

    public ModDirectorTweaker() {
        this.director.getLogger().log(ModDirectorSeverityLevel.INFO, "ModDirector/Tweaker", "Launchwrapper", "ModDirector bootstrapped from Launchwrapper!", new Object[0]);
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.args = args;
        this.gameDir = gameDir;
        if (gameDir == null) {
            this.gameDir = new File(".").getAbsoluteFile();
            this.director.getLogger().log(ModDirectorSeverityLevel.DEBUG, "ModDirector/Tweaker", "Launchwrapper", "Fixing null game directory to %s", this.gameDir.getPath());
        }
        this.assetsDir = assetsDir;
        this.profile = profile;
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.classLoader = classLoader;
        try {
            if (!this.director.activate(Long.MAX_VALUE, TimeUnit.DAYS)) {
                this.director.errorExit();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        ForgeLateLoader loader = new ForgeLateLoader(this, this.director, classLoader);
        loader.execute();
    }

    public String getLaunchTarget() {
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public String getProfile() {
        return this.profile;
    }

    public void callInjectedTweaker(ITweaker tweaker) {
        tweaker.acceptOptions(this.args, this.gameDir, this.assetsDir, this.profile);
        tweaker.injectIntoClassLoader(this.classLoader);
    }
}

