/*
 * Decompiled with CFR 0.152.
 */
package org.reprogle.dimensionpause.events;

import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.reprogle.dimensionpause.ConfigManager;
import org.reprogle.dimensionpause.DimensionPausePlugin;
import org.reprogle.dimensionpause.commands.CommandFeedback;

public class PlayerTeleportEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public static void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            return;
        }
        World.Environment env = event.getTo().getWorld().getEnvironment();
        Player p = event.getPlayer();
        if (env.equals((Object)World.Environment.NORMAL)) {
            return;
        }
        boolean netherBypass = ConfigManager.getPluginConfig().getBoolean("dimensions.nether.bypassable");
        boolean endBypass = ConfigManager.getPluginConfig().getBoolean("dimensions.end.bypassable");
        if (DimensionPausePlugin.ds.getState(env)) {
            if (DimensionPausePlugin.ds.canBypass(p, env.equals((Object)World.Environment.NETHER) ? netherBypass : endBypass)) {
                return;
            }
            event.setCancelled(true);
            String environment = env.equals((Object)World.Environment.NETHER) ? "nether" : "end";
            boolean sendTitle = ConfigManager.getPluginConfig().getBoolean("dimensions." + environment + ".alert.title.enabled");
            boolean sendChat = ConfigManager.getPluginConfig().getBoolean("dimensions." + environment + ".alert.chat.enabled");
            if (sendTitle) {
                p.showTitle(CommandFeedback.getTitleForDimension(env));
            }
            if (sendChat) {
                p.sendMessage(CommandFeedback.getChatForDimension(env));
            }
        }
    }
}

