/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2672;
import net.minecraft.class_6603;

public class CachedChunkPacket {
    private final int x;
    private final int z;
    private final byte[] bigHash;
    private final int hashCode;
    public int index;

    public CachedChunkPacket(class_2672 packet, int index) {
        this.x = packet.method_11523();
        this.z = packet.method_11524();
        this.bigHash = CachedChunkPacket.computePacketBigHash(packet);
        this.hashCode = Arrays.hashCode(this.bigHash);
        this.index = index;
    }

    private static byte[] computePacketBigHash(class_2672 packet) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                digest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e2) {
                throw new RuntimeException(e2);
            }
        }
        digest.update(CachedChunkPacket.intToByteArray(packet.method_11523()));
        digest.update(CachedChunkPacket.intToByteArray(packet.method_11524()));
        digest.update(packet.method_38598().field_34864);
        class_2540 frenBuffer = new class_2540(Unpooled.buffer());
        packet.field_34871.method_38603(frenBuffer);
        digest.update(frenBuffer.array(), 0, frenBuffer.writerIndex());
        frenBuffer.method_52935();
        digest.update(frenBuffer.array(), 0, frenBuffer.writerIndex());
        frenBuffer.method_52935();
        ArrayList<class_6603.class_6604> copy = new ArrayList<class_6603.class_6604>(packet.method_38598().field_34865);
        copy.sort(Comparator.comparingInt(a -> a.field_34867 << 8 | a.field_34866));
        for (class_6603.class_6604 blockEntitiesData : copy) {
            digest.update((byte)blockEntitiesData.field_34866);
            digest.update(CachedChunkPacket.intToByteArray(blockEntitiesData.field_34867));
            digest.update(class_2591.method_11033((class_2591)blockEntitiesData.field_34868).toString().getBytes(StandardCharsets.UTF_8));
            if (blockEntitiesData.field_34869 != null) {
                frenBuffer.method_10794((class_2520)blockEntitiesData.field_34869);
                digest.update(frenBuffer.array(), 0, frenBuffer.writerIndex());
                frenBuffer.method_52935();
                continue;
            }
            digest.update("NO_TAG".getBytes(StandardCharsets.UTF_8));
        }
        return digest.digest();
    }

    private static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CachedChunkPacket)) {
            return false;
        }
        CachedChunkPacket that = (CachedChunkPacket)o;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        if (this.x != that.x || this.z != that.z) {
            return false;
        }
        return Arrays.compare(this.bigHash, that.bigHash) == 0;
    }
}

