/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.GlobalCleaner;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;

public class FilePlayerSkin {
    private transient class_8685 playerSkin = null;
    private final String pathToSkin;

    public FilePlayerSkin(String pathToSkin) {
        this.pathToSkin = pathToSkin;
    }

    public class_8685 getSkin() {
        if (this.playerSkin != null) {
            return this.playerSkin;
        }
        Path path = Path.of(this.pathToSkin, new String[0]);
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
            int w = nativeImage.method_4307();
            int h = nativeImage.method_4323();
            int argb = nativeImage.method_61940(54 * w / 64, 20 * h / 64);
            class_8685.class_7920 model = class_8685.class_7920.field_41123;
            if ((argb >> 24 & 0xFF) < 20) {
                model = class_8685.class_7920.field_41122;
            }
            class_1043 dynamicTexture = new class_1043(() -> "file player skin", nativeImage);
            class_2960 resourceLocation = class_2960.method_60655((String)"flashback", (String)("skin_from_file/" + String.valueOf(UUID.randomUUID())));
            class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)dynamicTexture);
            GlobalCleaner.INSTANCE.register(this, new CleanState(resourceLocation));
            this.playerSkin = new class_8685(resourceLocation, null, null, null, model, false);
        }
        catch (Exception e) {
            Flashback.LOGGER.error("Unable to load skin from file", (Throwable)e);
            this.playerSkin = class_1068.method_62620();
        }
        return this.playerSkin;
    }

    private static class CleanState
    implements Runnable {
        private class_2960 skinResourceLocation;

        public CleanState(class_2960 skinResourceLocation) {
            this.skinResourceLocation = skinResourceLocation;
        }

        @Override
        public void run() {
            if (this.skinResourceLocation != null) {
                class_2960 toClean = this.skinResourceLocation;
                class_310.method_1551().execute(() -> {
                    Flashback.LOGGER.info("Cleaning player skin {} because it's no longer in use!", (Object)toClean);
                    class_310.method_1551().method_1531().method_4615(toClean);
                });
                this.skinResourceLocation = null;
            }
        }
    }
}

