/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui.windows;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.moulberry.flashback.FilePlayerSkin;
import com.moulberry.flashback.Utils;
import com.moulberry.flashback.combo_options.GlowingOverride;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.exporting.AsyncFileDialogs;
import com.moulberry.flashback.state.EditorState;
import imgui.flashback.ImGui;
import imgui.flashback.type.ImString;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1664;
import net.minecraft.class_2183;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_742;
import net.minecraft.class_8646;

public class SelectedEntityPopup {
    private static ImString changeSkinInput = ImGuiHelper.createResizableImString("");
    private static ImString changeNameInput;

    public static void open(class_1297 entity, EditorState editorState) {
        String nameOverride = editorState.nameOverride.get(entity.method_5667());
        if (nameOverride != null) {
            changeNameInput.set(nameOverride);
        } else {
            changeNameInput.set("");
        }
        GameProfile skinOverride = editorState.skinOverride.get(entity.method_5667());
        if (skinOverride != null) {
            changeSkinInput.set(skinOverride.getId().toString());
        } else {
            changeSkinInput.set("");
        }
    }

    public static void render(class_1297 entity, EditorState editorState) {
        UUID uuid = entity.method_5667();
        ImGui.textUnformatted(class_1074.method_4662((String)"flashback.entity_label", (Object[])new Object[]{uuid}));
        ImGui.separator();
        if (ImGui.button(class_1074.method_4662((String)"flashback.look_at", (Object[])new Object[0]))) {
            class_310.method_1551().field_1719.method_5702(class_2183.class_2184.field_9851, entity.method_33571());
        }
        ImGui.sameLine();
        if (ImGui.button(class_1074.method_4662((String)"flashback.spectate", (Object[])new Object[0]))) {
            class_310.method_1551().field_1724.field_3944.method_45730("spectate " + String.valueOf(entity.method_5667()));
            ImGui.closeCurrentPopup();
        }
        ImGui.sameLine();
        if (ImGui.button(class_1074.method_4662((String)"flashback.copy_uuid", (Object[])new Object[0]))) {
            class_310.method_1551().field_1774.method_1455(entity.method_5667().toString());
            ReplayUI.setInfoOverlay("Copied '" + String.valueOf(entity.method_5667()) + "'");
            ImGui.closeCurrentPopup();
        }
        if (uuid.equals(editorState.audioSourceEntity)) {
            if (ImGui.button(class_1074.method_4662((String)"flashback.unset_audio_source", (Object[])new Object[0]))) {
                editorState.audioSourceEntity = null;
                editorState.markDirty();
            }
        } else if (ImGui.button(class_1074.method_4662((String)"flashback.set_audio_source", (Object[])new Object[0]))) {
            editorState.audioSourceEntity = entity.method_5667();
            editorState.markDirty();
        }
        boolean isHiddenDuringExport = editorState.hideDuringExport.contains(entity.method_5667());
        if (ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_during_export", (Object[])new Object[0]), isHiddenDuringExport)) {
            if (isHiddenDuringExport) {
                editorState.hideDuringExport.remove(entity.method_5667());
            } else {
                editorState.hideDuringExport.add(entity.method_5667());
            }
            editorState.markDirty();
        }
        if (!isHiddenDuringExport) {
            if (entity instanceof class_742) {
                class_742 player = (class_742)entity;
                if (editorState.hideCape.contains(player.method_5667())) {
                    if (ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_cape", (Object[])new Object[0]), true)) {
                        editorState.hideCape.remove(player.method_5667());
                    }
                } else if (player.method_7348(class_1664.field_7559) && player.method_52814().comp_1627() != null && ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_cape", (Object[])new Object[0]), false)) {
                    editorState.hideCape.add(player.method_5667());
                }
                boolean hideNametag = editorState.hideNametags.contains(entity.method_5667());
                if (ImGui.checkbox(class_1074.method_4662((String)"flashback.render_nametag", (Object[])new Object[0]), !hideNametag)) {
                    if (hideNametag) {
                        editorState.hideNametags.remove(entity.method_5667());
                    } else {
                        editorState.hideNametags.add(entity.method_5667());
                    }
                }
                if (!hideNametag) {
                    class_268 team;
                    String nameTitle = class_1074.method_4662((String)"flashback.name", (Object[])new Object[0]);
                    boolean changedName = ImGui.inputTextWithHint(nameTitle + "##SetNameInput", player.method_5820(), changeNameInput);
                    if (changedName) {
                        String string = ImGuiHelper.getString(changeNameInput);
                        if (string.isEmpty()) {
                            editorState.nameOverride.remove(entity.method_5667());
                        } else {
                            editorState.nameOverride.put(entity.method_5667(), string);
                        }
                    }
                    if (editorState.hideTeamPrefix.contains(player.method_5667())) {
                        if (ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_team_prefix", (Object[])new Object[0]), true)) {
                            editorState.hideTeamPrefix.remove(player.method_5667());
                        }
                    } else {
                        team = player.method_5781();
                        if (team != null && !Utils.isComponentEmpty(team.method_1144()) && ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_team_prefix", (Object[])new Object[0]), false)) {
                            editorState.hideTeamPrefix.add(player.method_5667());
                        }
                    }
                    if (editorState.hideTeamSuffix.contains(player.method_5667())) {
                        if (ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_team_suffix", (Object[])new Object[0]), true)) {
                            editorState.hideTeamSuffix.remove(player.method_5667());
                        }
                    } else {
                        team = player.method_5781();
                        if (team != null && !Utils.isComponentEmpty(team.method_1136()) && ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_team_suffix", (Object[])new Object[0]), false)) {
                            editorState.hideTeamSuffix.add(player.method_5667());
                        }
                    }
                    if (editorState.hideBelowName.contains(player.method_5667())) {
                        if (ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_text_below_name", (Object[])new Object[0]), true)) {
                            editorState.hideBelowName.remove(player.method_5667());
                        }
                    } else {
                        class_269 scoreboard = player.method_7327();
                        class_266 objective = scoreboard.method_1189(class_8646.field_45158);
                        if (objective != null && ImGui.checkbox(class_1074.method_4662((String)"flashback.hide_text_below_name", (Object[])new Object[0]), false)) {
                            editorState.hideBelowName.add(player.method_5667());
                        }
                    }
                }
                SelectedEntityPopup.showGlowingDropdown(entity, editorState);
                ImGuiHelper.separatorWithText(class_1074.method_4662((String)"flashback.change_skin_and_cape", (Object[])new Object[0]));
                ImGui.setNextItemWidth(320.0f);
                ImGui.inputTextWithHint("##SetSkinInput", "e.g. d0e05de7-6067-454d-beae-c6d19d886191", changeSkinInput);
                if (!changeSkinInput.isEmpty()) {
                    String string = ImGuiHelper.getString(changeSkinInput);
                    try {
                        UUID changeSkinUuid = UUID.fromString(string);
                        if (ImGui.button(class_1074.method_4662((String)"flashback.apply_skin_from_uuid", (Object[])new Object[0]))) {
                            ProfileResult profile = class_310.method_1551().method_1495().fetchProfile(changeSkinUuid, true);
                            editorState.skinOverride.put(entity.method_5667(), profile.profile());
                            editorState.skinOverrideFromFile.remove(entity.method_5667());
                        }
                    }
                    catch (Exception changeSkinUuid) {
                        // empty catch block
                    }
                }
                if (ImGui.button(class_1074.method_4662((String)"flashback.upload_skin_from_file", (Object[])new Object[0]))) {
                    Path gameDir = FabricLoader.getInstance().getGameDir();
                    CompletableFuture<String> future = AsyncFileDialogs.openFileDialog(gameDir.toString(), "Skin Texture", "png");
                    future.thenAccept(pathStr -> {
                        if (pathStr != null) {
                            editorState.skinOverride.remove(entity.method_5667());
                            editorState.skinOverrideFromFile.put(entity.method_5667(), new FilePlayerSkin((String)pathStr));
                        }
                    });
                }
                if ((editorState.skinOverride.containsKey(entity.method_5667()) || editorState.skinOverrideFromFile.containsKey(entity.method_5667())) && ImGui.button(class_1074.method_4662((String)"flashback.reset_skin", (Object[])new Object[0]))) {
                    editorState.skinOverride.remove(entity.method_5667());
                    editorState.skinOverrideFromFile.remove(entity.method_5667());
                    changeSkinInput.set("");
                }
            } else {
                SelectedEntityPopup.showGlowingDropdown(entity, editorState);
            }
        }
    }

    private static void showGlowingDropdown(class_1297 entity, EditorState editorState) {
        GlowingOverride newGlowingOverride;
        GlowingOverride glowingOverride = GlowingOverride.DEFAULT;
        if (editorState.glowingOverride.containsKey(entity.method_5667())) {
            glowingOverride = editorState.glowingOverride.get(entity.method_5667());
        }
        if ((newGlowingOverride = ImGuiHelper.enumCombo(class_1074.method_4662((String)"flashback.glowing", (Object[])new Object[0]), glowingOverride)) != glowingOverride) {
            if (newGlowingOverride == GlowingOverride.DEFAULT) {
                editorState.glowingOverride.remove(entity.method_5667());
            } else {
                editorState.glowingOverride.put(entity.method_5667(), newGlowingOverride);
            }
        }
    }

    static {
        SelectedEntityPopup.changeSkinInput.inputData.allowedChars = "0123456789abcdef-";
        changeNameInput = ImGuiHelper.createResizableImString("");
    }
}

