/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.exporting;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.SneakyThrow;
import com.moulberry.flashback.combo_options.AudioCodec;
import com.moulberry.flashback.exporting.ExportSettings;
import com.moulberry.flashback.exporting.PixelFormatHelper;
import com.moulberry.flashback.exporting.VideoWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_1011;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVPixFmtDescriptor;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.FFmpegLogCallback;
import org.bytedeco.javacv.Frame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class AsyncFFmpegVideoWriter
implements AutoCloseable,
VideoWriter {
    @Nullable
    private final ArrayBlockingQueue<ImageFrame> rescaleQueue;
    private final ArrayBlockingQueue<ImageFrame> encodeQueue;
    @Nullable
    private final ArrayBlockingQueue<Long> reusePictureData;
    private final AtomicBoolean finishRescaleThread = new AtomicBoolean(false);
    private final AtomicBoolean finishEncodeThread = new AtomicBoolean(false);
    private final AtomicBoolean finishedWriting = new AtomicBoolean(false);
    private final AtomicReference<Throwable> threadedError = new AtomicReference<Object>(null);

    public AsyncFFmpegVideoWriter(ExportSettings settings, String filename) {
        int width = settings.resolutionX();
        int height = settings.resolutionY();
        int maxResolutionArea = 8294400;
        if (width * height > 8294400) {
            double factor = (double)(width * height) / 8294400.0;
            factor = Math.sqrt(factor);
            width = (int)Math.floor((double)width / factor);
            height = (int)Math.floor((double)height / factor);
        }
        int maxBitrate = Math.min(288000000, 5000 + (int)Math.ceil((double)(width * height) * settings.framerate()));
        if (settings.encoder().equals("libsvtav1")) {
            maxBitrate = Math.min(100000000, maxBitrate);
        }
        int bitrate = settings.bitrate() <= 0 ? maxBitrate : Math.min(settings.bitrate(), maxBitrate);
        double fps = settings.framerate();
        String extension = settings.container().extension();
        try {
            FFmpegLogCallback.set();
            boolean wantTransparency = settings.transparent();
            int dstPixelFormat = PixelFormatHelper.getBestPixelFormat(settings.encoder(), wantTransparency);
            Flashback.LOGGER.info("Encoding video with pixel format {}", (Object)PixelFormatHelper.pixelFormatToString(dstPixelFormat));
            boolean needsRescale = 26 != dstPixelFormat;
            int audioChannels = 0;
            if (settings.recordAudio()) {
                audioChannels = settings.audioCodec() == AudioCodec.VORBIS || settings.stereoAudio() ? 2 : 1;
            }
            FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(filename, width, height, audioChannels);
            recorder.setVideoBitrate(bitrate);
            recorder.setVideoCodec(settings.codec().codecId());
            recorder.setVideoCodecName(settings.encoder());
            recorder.setFormat(extension);
            recorder.setFrameRate(fps);
            recorder.setPixelFormat(dstPixelFormat);
            recorder.setGopSize((int)Math.max(20.0, Math.min(240.0, Math.ceil(fps * 2.0))));
            if (settings.recordAudio()) {
                recorder.setAudioCodec(settings.audioCodec().codecId());
                recorder.setSampleFormat(8);
                recorder.setSampleRate(48000);
                recorder.setAudioBitrate(256000);
            }
            recorder.start();
            this.encodeQueue = new ArrayBlockingQueue(needsRescale ? 24 : 32);
            this.rescaleQueue = needsRescale ? new ArrayBlockingQueue(8) : null;
            this.reusePictureData = needsRescale ? new ArrayBlockingQueue(32) : null;
            Thread encodeThread = this.createEncodeThread(recorder);
            if (needsRescale) {
                Thread rescaleThread = this.createRescaleThread(width, height, dstPixelFormat);
                rescaleThread.start();
            }
            encodeThread.start();
        }
        catch (IOException e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }

    @NotNull
    private Thread createEncodeThread(FFmpegFrameRecorder recorder) {
        Thread encodeThread = new Thread(() -> {
            while (true) {
                ImageFrame src;
                try {
                    src = this.encodeQueue.poll(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw SneakyThrow.sneakyThrow(e);
                }
                try {
                    if (src == null) {
                        if (!this.finishEncodeThread.get()) continue;
                        recorder.stop();
                        recorder.close();
                        this.finishedWriting.set(true);
                        return;
                    }
                    int size = src.height * src.stride * Frame.pixelSize(src.imageDepth);
                    ByteBuffer buffer = MemoryUtil.memByteBuffer((long)src.pointer, (int)size);
                    recorder.recordImage(src.width, src.height, src.imageDepth, src.channels, src.stride, src.pixelFormat, buffer);
                    if (src.audioBuffer != null) {
                        recorder.recordSamples(src.audioBuffer);
                    }
                    if (this.reusePictureData == null || !this.reusePictureData.offer(src.pointer)) continue;
                    src = null;
                    continue;
                }
                catch (Throwable t) {
                    try {
                        recorder.release();
                    }
                    catch (FFmpegFrameRecorder.Exception e) {
                        e.printStackTrace();
                    }
                    this.threadedError.set(t);
                    this.finishRescaleThread.set(true);
                    this.finishEncodeThread.set(true);
                    this.finishedWriting.set(true);
                    return;
                }
                finally {
                    if (src == null) continue;
                    src.close();
                    continue;
                }
                break;
            }
        });
        encodeThread.setName("Video Encode Thread");
        return encodeThread;
    }

    private Thread createRescaleThread(int dstWidth, int dstHeight, int dstPixelFormat) {
        byte dstChannels;
        int dstSize = avutil.av_image_get_buffer_size(dstPixelFormat, dstWidth, dstHeight, 1);
        int dstDepth = dstSize * 8 / dstWidth / dstHeight;
        try (AVPixFmtDescriptor descriptor = avutil.av_pix_fmt_desc_get(dstPixelFormat);){
            dstChannels = descriptor.nb_components();
        }
        AVFrame picture = avutil.av_frame_alloc();
        if (picture == null) {
            throw new RuntimeException("av_frame_alloc() error: Could not allocate picture.");
        }
        AVFrame tmp_picture = avutil.av_frame_alloc();
        if (tmp_picture == null) {
            throw new RuntimeException("av_frame_alloc() error: Could not allocate tmp_picture.");
        }
        PointerPointer tmp_picture_ptr = new PointerPointer(tmp_picture);
        PointerPointer picture_ptr = new PointerPointer(picture);
        Flashback.LOGGER.info("Rescaling to pixel format: {}", (Object)dstPixelFormat);
        boolean useItu709Colorspace = PixelFormatHelper.isYuvFormat(dstPixelFormat);
        Thread scaleThread = new Thread(() -> this.lambda$createRescaleThread$1(picture, tmp_picture, dstWidth, dstHeight, dstPixelFormat, useItu709Colorspace, dstSize, tmp_picture_ptr, picture_ptr, dstChannels, dstDepth));
        scaleThread.setName("Image Rescale Thread");
        return scaleThread;
    }

    private void checkEncodeError(@Nullable AutoCloseable closeable) {
        Throwable t = this.threadedError.get();
        if (t != null) {
            this.finishRescaleThread.set(true);
            this.finishEncodeThread.set(true);
            this.finishedWriting.set(true);
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    Flashback.LOGGER.error("Error while trying to close passed AutoClosable", (Throwable)e);
                }
            }
            SneakyThrow.sneakyThrow(t);
        }
    }

    @Override
    public void encode(class_1011 src, @Nullable FloatBuffer audioBuffer) {
        this.checkEncodeError((AutoCloseable)src);
        if (this.finishRescaleThread.get() || this.finishEncodeThread.get() || this.finishedWriting.get()) {
            src.close();
            throw new IllegalStateException("Cannot encode after finish()");
        }
        while (true) {
            try {
                ImageFrame imageFrame = new ImageFrame(src.field_4988, (int)src.field_4987, src.method_4307(), src.method_4323(), 4, -32, src.method_4307(), 26, audioBuffer);
                if (this.rescaleQueue != null) {
                    this.rescaleQueue.put(imageFrame);
                    break;
                }
                this.encodeQueue.put(imageFrame);
            }
            catch (InterruptedException interruptedException) {
                this.checkEncodeError((AutoCloseable)src);
                continue;
            }
            break;
        }
    }

    @Override
    public void finish() {
        this.checkEncodeError(null);
        if (this.rescaleQueue != null) {
            while (!this.rescaleQueue.isEmpty()) {
                this.checkEncodeError(null);
                LockSupport.parkNanos("waiting for rescale queue to empty", 100000L);
            }
        }
        while (!this.encodeQueue.isEmpty()) {
            this.checkEncodeError(null);
            LockSupport.parkNanos("waiting for encode queue to empty", 100000L);
        }
        this.finishRescaleThread.set(true);
        if (this.rescaleQueue == null) {
            this.finishEncodeThread.set(true);
        }
        while (!this.finishedWriting.get()) {
            LockSupport.parkNanos("waiting for encoder thread to finish", 100000L);
        }
        this.checkEncodeError(null);
    }

    @Override
    public void close() {
        if (this.rescaleQueue != null) {
            for (ImageFrame src : this.rescaleQueue) {
                src.close();
            }
        }
        for (ImageFrame src : this.encodeQueue) {
            src.close();
        }
        this.finishRescaleThread.set(true);
        this.finishEncodeThread.set(true);
        while (!this.finishedWriting.get()) {
            LockSupport.parkNanos("waiting for encoder thread to finish", 100000L);
        }
        if (this.reusePictureData != null) {
            for (Long address : this.reusePictureData) {
                if (address == null || address == 0L) continue;
                MemoryUtil.nmemFree((long)address);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$createRescaleThread$1(AVFrame picture, AVFrame tmp_picture, int dstWidth, int dstHeight, int dstPixelFormat, boolean useItu709Colorspace, final int dstSize, PointerPointer tmp_picture_ptr, PointerPointer picture_ptr, int dstChannels, int dstDepth) {
        img_convert_ctx = null;
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                src = this.rescaleQueue.poll(10L, TimeUnit.MILLISECONDS);
                try {
                    if (src == null) {
                        if (!this.finishRescaleThread.get()) ** GOTO lbl-1000
                        avutil.av_frame_free(picture);
                        avutil.av_frame_free(tmp_picture);
                        swscale.sws_freeContext(img_convert_ctx);
                        this.finishEncodeThread.set(true);
                        return;
                    }
                    if ((img_convert_ctx = swscale.sws_getCachedContext(img_convert_ctx, src.width, src.height, src.pixelFormat, dstWidth, dstHeight, dstPixelFormat, 270848, null, null, (DoublePointer)null)) == null) {
                        throw new RuntimeException("sws_getCachedContext() error: Cannot initialize the conversion context.");
                    }
                    if (useItu709Colorspace) {
                        coefficients = swscale.sws_getCoefficients(1);
                        swscale.sws_setColorspaceDetails(img_convert_ctx, coefficients, 1, coefficients, 0, 0, 65536, 65536);
                    }
                    data = new BytePointer(this){
                        {
                            this.address = src.pointer;
                            this.position = 0L;
                            this.limit = src.size;
                            this.capacity = src.size;
                        }
                    };
                    tempPointerAddressLong = this.reusePictureData.poll();
                    if (tempPointerAddressLong == null && (tempPointerAddressLong = Long.valueOf(MemoryUtil.nmemAlloc((long)dstSize))) == 0L) {
                        throw new OutOfMemoryError();
                    }
                    tempPointerAddress = tempPointerAddressLong;
                    tempPointer = new BytePointer(this){
                        {
                            this.address = tempPointerAddress;
                            this.position = 0L;
                            this.limit = dstSize;
                            this.capacity = dstSize;
                        }
                    };
                    avutil.av_image_fill_arrays(tmp_picture_ptr, tmp_picture.linesize(), data, src.pixelFormat, src.width, src.height, 1);
                    avutil.av_image_fill_arrays(picture_ptr, picture.linesize(), tempPointer, dstPixelFormat, dstWidth, dstHeight, 1);
                    step = src.stride * Math.abs(src.imageDepth) / 8;
                    tmp_picture.linesize(0, step);
                    tmp_picture.format(src.pixelFormat);
                    tmp_picture.width(src.width);
                    tmp_picture.height(src.height);
                    picture.format(dstPixelFormat);
                    picture.width(dstWidth);
                    picture.height(dstHeight);
                    swscale.sws_scale(img_convert_ctx, tmp_picture_ptr, tmp_picture.linesize(), 0, src.height, picture_ptr, picture.linesize());
                    this.encodeQueue.put(new ImageFrame(tempPointerAddress, dstSize, dstWidth, dstHeight, dstChannels, dstDepth, dstWidth, dstPixelFormat, src.audioBuffer));
                }
                finally {
                    if (src == null) continue;
                    src.close();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            try {
                avutil.av_frame_free(picture);
                avutil.av_frame_free(tmp_picture);
                swscale.sws_freeContext(img_convert_ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.threadedError.set(t);
            this.finishRescaleThread.set(true);
            this.finishEncodeThread.set(true);
            this.finishedWriting.set(true);
            return;
        }
        ** GOTO lbl-1000
    }

    private record ImageFrame(long pointer, int size, int width, int height, int channels, int imageDepth, int stride, int pixelFormat, @Nullable FloatBuffer audioBuffer) implements AutoCloseable
    {
        @Override
        public void close() {
            MemoryUtil.nmemFree((long)this.pointer);
        }
    }
}

