/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.exporting;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.FramebufferUtils;
import com.moulberry.flashback.FreezeSlowdownFormula;
import com.moulberry.flashback.Utils;
import com.moulberry.flashback.WindowSizeTracker;
import com.moulberry.flashback.combo_options.VideoContainer;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.editor.ui.windows.ExportDoneWindow;
import com.moulberry.flashback.exporting.AsyncFFmpegVideoWriter;
import com.moulberry.flashback.exporting.ExportJobQueue;
import com.moulberry.flashback.exporting.ExportSettings;
import com.moulberry.flashback.exporting.PNGSequenceVideoWriter;
import com.moulberry.flashback.exporting.PerfectFrames;
import com.moulberry.flashback.exporting.SaveableFramebuffer;
import com.moulberry.flashback.exporting.SaveableFramebufferQueue;
import com.moulberry.flashback.exporting.VideoWriter;
import com.moulberry.flashback.exporting.taskbar.TaskbarManager;
import com.moulberry.flashback.keyframe.handler.MinecraftKeyframeHandler;
import com.moulberry.flashback.keyframe.handler.TickrateKeyframeCapture;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.sound.FlashbackAudioManager;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.visuals.AccurateEntityPositionHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.class_1011;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11278;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.openal.SOFTLoopback;

public class ExportJob {
    private final ExportSettings settings;
    private boolean running = false;
    private boolean shouldChangeFramebufferSize = false;
    private long lastRenderMillis;
    private long escapeCancelStartMillis = -1L;
    private long renderStartTime;
    private final Random particleRandom;
    private long currentClientTickSeed = 0L;
    private long currentInitialEntityTickSeed = 0L;
    private boolean showingDebug = false;
    private boolean pressedDebugKey = false;
    private long serverTickTimeNanos = 0L;
    private long clientTickTimeNanos = 0L;
    private long renderTimeNanos = 0L;
    private long encodeTimeNanos = 0L;
    private long downloadTimeNanos = 0L;
    private boolean patreonLinkClicked = false;
    private int extraDummyFrames = 0;
    public int progressCount = 0;
    public int progressOutOf = 0;
    private double currentTickDouble = 0.0;
    private double audioSamples = 0.0;
    private final AtomicBoolean finishedServerTick = new AtomicBoolean(false);
    private class_1011 firstFrame = null;
    private int writtenFrames = 0;
    public static final int SRC_PIXEL_FORMAT = 26;
    private static class_11278 projectionBuffers = null;

    public ExportJob(ExportSettings settings) {
        this.settings = settings;
        this.particleRandom = this.settings.resetRng() ? new Random(2000L) : null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void onFinishedServerTick() {
        this.finishedServerTick.set(true);
    }

    public boolean shouldChangeFramebufferSize() {
        return this.running && this.shouldChangeFramebufferSize;
    }

    public int getWidth() {
        return this.settings.resolutionX() * (this.settings.ssaa() ? 2 : 1);
    }

    public int getHeight() {
        return this.settings.resolutionY() * (this.settings.ssaa() ? 2 : 1);
    }

    public double getCurrentTickDouble() {
        return this.currentTickDouble;
    }

    public Random getParticleRandom() {
        return this.particleRandom;
    }

    public long getSeedForCurrentClientTick() {
        return this.currentClientTickSeed;
    }

    public long getInitialEntitySeedForCurrentClientTick() {
        ++this.currentInitialEntityTickSeed;
        return this.currentInitialEntityTickSeed;
    }

    public ExportSettings getSettings() {
        return this.settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (this.running) throw new IllegalStateException("run() called twice");
        if (replayServer == null) {
            throw new IllegalStateException("run() called twice");
        }
        this.running = true;
        class_310.method_1551().field_1729.method_1610();
        class_310.method_1551().method_1483().method_4881();
        class_310.method_1551().method_1483().method_18670(true);
        TaskbarManager.launchTaskbarManager();
        UUID uuid = UUID.randomUUID();
        String tempFileName = "replay_export_temp/" + String.valueOf(uuid) + "." + this.settings.container().extension();
        Path exportTempFile = Path.of(tempFileName, new String[0]);
        Path exportTempFolder = exportTempFile.getParent();
        int oldGuiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        this.extraDummyFrames = Flashback.getConfig().exporting.exportRenderDummyFrames;
        try {
            Files.createDirectories(exportTempFolder, new FileAttribute[0]);
            try (VideoWriter encoder = ExportJob.createVideoWriter(this.settings, tempFileName);
                 SaveableFramebufferQueue downloader = new SaveableFramebufferQueue(this.settings.resolutionX(), this.settings.resolutionY());){
                this.doExport(encoder, downloader);
            }
            if (this.settings.container() != VideoContainer.PNG_SEQUENCE) {
                Files.move(exportTempFile, this.settings.output(), StandardCopyOption.REPLACE_EXISTING);
            }
            try {
                long size = 0L;
                double duration = (double)this.writtenFrames / this.settings.framerate();
                Path output = this.settings.output();
                if (this.settings.container() != VideoContainer.PNG_SEQUENCE && Files.exists(output, new LinkOption[0]) && Files.isRegularFile(output, new LinkOption[0])) {
                    size = Files.size(output);
                }
                ExportDoneWindow.addFinishedExportEntry(new ExportDoneWindow.FinishedExportEntry(this.settings, this.firstFrame, duration, size));
                this.firstFrame = null;
            }
            catch (IOException size) {
                // empty catch block
            }
            this.running = false;
            this.shouldChangeFramebufferSize = false;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.running = false;
                this.shouldChangeFramebufferSize = false;
                class_310.method_1551().field_1690.method_42474().method_41748((Object)oldGuiScale);
                class_310.method_1551().method_15993();
                replayServer.replayPaused = true;
                class_638 level2 = class_310.method_1551().field_1687;
                if (level2 != null) {
                    level2.method_54719().method_54675(true);
                }
                class_310.method_1551().method_1483().method_4881();
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14725, (float)1.0f));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14793, (float)1.0f));
                if (this.firstFrame != null) {
                    this.firstFrame.close();
                    this.firstFrame = null;
                }
                try {
                    Files.deleteIfExists(exportTempFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    boolean empty;
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(exportTempFolder);){
                        empty = !stream.iterator().hasNext();
                    }
                    if (!empty) throw throwable;
                    Files.deleteIfExists(exportTempFolder);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        class_310.method_1551().field_1690.method_42474().method_41748((Object)oldGuiScale);
        class_310.method_1551().method_15993();
        replayServer.replayPaused = true;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            level.method_54719().method_54675(true);
        }
        class_310.method_1551().method_1483().method_4881();
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14725, (float)1.0f));
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_14793, (float)1.0f));
        if (this.firstFrame != null) {
            this.firstFrame.close();
            this.firstFrame = null;
        }
        try {
            Files.deleteIfExists(exportTempFile);
        }
        catch (IOException downloader) {
            // empty catch block
        }
        try {
            boolean empty;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(exportTempFolder);){
                empty = !stream.iterator().hasNext();
            }
            if (!empty) return;
            Files.deleteIfExists(exportTempFolder);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static VideoWriter createVideoWriter(ExportSettings settings, String tempFileName) {
        if (settings.container() == VideoContainer.PNG_SEQUENCE) {
            return new PNGSequenceVideoWriter(settings);
        }
        return new AsyncFFmpegVideoWriter(settings, tempFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(VideoWriter videoWriter, SaveableFramebufferQueue downloader) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer == null) {
            return;
        }
        Random random = new Random(1000L);
        Random mathRandom = this.settings.resetRng() ? Utils.getInternalMathRandom() : null;
        this.setup(replayServer);
        this.updateRandoms(random, mathRandom);
        this.shouldChangeFramebufferSize = true;
        if (this.settings.ssaa()) {
            class_310.method_1551().field_1690.method_42474().method_41748((Object)((Integer)class_310.method_1551().field_1690.method_42474().method_41753() * 2));
        }
        class_310.method_1551().method_15993();
        List<TickInfo> ticks = ExportJob.calculateTicks(this.settings.editorState(), this.settings.startTick(), this.settings.endTick(), this.settings.framerate());
        int clientTickCount = 0;
        this.renderStartTime = System.currentTimeMillis();
        double lastClientTickDouble = 0.0;
        for (int tickIndex = 0; tickIndex < ticks.size(); ++tickIndex) {
            class_276 renderTarget;
            TickInfo tickInfo = ticks.get(tickIndex);
            boolean frozen = tickInfo.frozen;
            this.currentTickDouble = tickInfo.serverTick;
            int targetServerTick = this.settings.startTick() + (int)this.currentTickDouble;
            float deltaTicksFloat = (float)(tickInfo.clientTick - lastClientTickDouble);
            lastClientTickDouble = tickInfo.clientTick;
            double partialClientTick = tickInfo.clientTick - (double)((int)tickInfo.clientTick);
            long start = System.nanoTime();
            this.setServerTickAndWait(replayServer, targetServerTick, false);
            this.serverTickTimeNanos += System.nanoTime() - start;
            while (clientTickCount < (int)tickInfo.clientTick) {
                start = System.nanoTime();
                this.updateRandoms(random, mathRandom);
                this.runClientTick(frozen);
                this.clientTickTimeNanos += System.nanoTime() - start;
                ++clientTickCount;
            }
            this.updateClientFreeze(frozen);
            class_9779.class_9781 timer = class_310.method_1551().field_52750;
            timer.method_60644(frozen);
            timer.method_60642(false);
            timer.field_51958 = deltaTicksFloat;
            timer.field_51960 = deltaTicksFloat;
            timer.field_51959 = (float)partialClientTick;
            timer.field_51961 = (float)partialClientTick;
            AccurateEntityPositionHandler.apply(class_310.method_1551().field_1687, (class_9779)timer);
            if (frozen) {
                FlashbackAudioManager.pauseAll();
            } else {
                FlashbackAudioManager.startHandling();
            }
            try {
                MinecraftKeyframeHandler keyframeHandler = new MinecraftKeyframeHandler(class_310.method_1551());
                this.settings.editorState().applyKeyframes(keyframeHandler, (float)((double)this.settings.startTick() + this.currentTickDouble));
            }
            finally {
                if (!frozen) {
                    FlashbackAudioManager.finishHandling();
                }
            }
            long pauseScreenStart = System.currentTimeMillis();
            int additionalDummyFrames = this.extraDummyFrames;
            while (class_310.method_1551().method_18506() != null || class_310.method_1551().field_1755 != null || additionalDummyFrames > 0) {
                if (class_310.method_1551().method_18506() != null || class_310.method_1551().field_1755 != null) {
                    this.runClientTick(frozen);
                }
                if (additionalDummyFrames > 0) {
                    --additionalDummyFrames;
                }
                class_1041 window = class_310.method_1551().method_22683();
                renderTarget = class_310.method_1551().field_1689;
                RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(renderTarget.method_30277(), 0, renderTarget.method_30278(), 1.0);
                class_310.method_1551().field_1773.method_3192((class_9779)class_310.method_1551().field_52750, true);
                this.shouldChangeFramebufferSize = false;
                if (!class_310.method_1551().method_22683().method_65966()) {
                    renderTarget.method_1237();
                }
                window.method_15998(null);
                this.shouldChangeFramebufferSize = true;
                if (class_310.method_1551().method_18506() != null || class_310.method_1551().field_1755 != null) {
                    LockSupport.parkNanos("waiting for pause overlay to disappear", 50000000L);
                    long currentTime = System.currentTimeMillis();
                    if (pauseScreenStart > currentTime) {
                        pauseScreenStart = currentTime;
                    }
                    if (currentTime - pauseScreenStart > 5000L) {
                        class_310.method_1551().method_1507(null);
                    }
                    if (currentTime - pauseScreenStart > 15000L) {
                        class_310.method_1551().method_18502(null);
                    }
                }
                this.updateClientFreeze(frozen);
                timer.method_60644(frozen);
                timer.method_60642(false);
                timer.field_51958 = deltaTicksFloat;
                timer.field_51960 = deltaTicksFloat;
                timer.field_51959 = (float)partialClientTick;
                timer.field_51961 = (float)partialClientTick;
            }
            SaveableFramebuffer saveable = downloader.take();
            renderTarget = class_310.method_1551().field_1689;
            PerfectFrames.waitUntilFrameReady();
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(renderTarget.method_30277(), 0, renderTarget.method_30278(), 1.0);
            start = System.nanoTime();
            class_310.method_1551().field_1773.method_3192((class_9779)timer, true);
            this.renderTimeNanos += System.nanoTime() - start;
            FloatBuffer audioBuffer = null;
            if (this.settings.recordAudio()) {
                long device = class_310.method_1551().method_1483().field_5590.field_18945.field_18898;
                this.audioSamples += 48000.0 / this.settings.framerate();
                int renderSamples = (int)this.audioSamples;
                this.audioSamples -= (double)renderSamples;
                int channels = this.settings.stereoAudio() ? 2 : 1;
                audioBuffer = ByteBuffer.allocateDirect(renderSamples * 4 * channels).order(ByteOrder.nativeOrder()).asFloatBuffer();
                SOFTLoopback.alcRenderSamplesSOFT((long)device, (FloatBuffer)audioBuffer, (int)renderSamples);
            }
            saveable.audioBuffer = audioBuffer;
            downloader.startDownload(renderTarget, saveable, this.settings.ssaa());
            this.submitDownloadedFrames(videoWriter, downloader, false);
            this.shouldChangeFramebufferSize = false;
            boolean cancel = this.finishFrame(renderTarget, tickIndex, ticks.size());
            this.shouldChangeFramebufferSize = true;
            if (!cancel) continue;
            ExportJobQueue.drainingQueue = false;
            break;
        }
        this.submitDownloadedFrames(videoWriter, downloader, true);
        videoWriter.finish();
    }

    private void updateRandoms(Random random, Random mathRandom) {
        if (!this.settings.resetRng()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        long connectionSeed = random.nextLong();
        long levelSeed = random.nextLong();
        long entitySeed = random.nextLong();
        long mathSeed = random.nextLong();
        long particleSeed = random.nextLong();
        this.currentClientTickSeed = random.nextLong();
        this.currentInitialEntityTickSeed = random.nextLong();
        if (minecraft.method_1562() != null) {
            minecraft.method_1562().field_3687.method_43052(connectionSeed);
        }
        if (minecraft.field_1687 != null) {
            minecraft.field_1687.field_9229.method_43052(levelSeed);
            for (class_1297 entity : minecraft.field_1687.method_18112()) {
                if (entity == null) continue;
                entity.method_59922().method_43052(entitySeed ^ entity.method_5667().getMostSignificantBits());
            }
        }
        if (mathRandom != null) {
            mathRandom.setSeed(mathSeed);
        }
        this.particleRandom.setSeed(particleSeed);
    }

    private void setup(ReplayServer replayServer) {
        class_310 minecraft = class_310.method_1551();
        replayServer.setDesiredTickRate(20.0f, true);
        if (replayServer.getReplayTick() != this.settings.startTick()) {
            int currentTick = Math.max(0, this.settings.startTick() - 40);
            this.setServerTickAndWait(replayServer, currentTick, true);
            this.runClientTick(false);
            minecraft.field_1713.method_48015();
            for (class_1297 entity : minecraft.field_1687.method_18112()) {
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    livingEntity.field_42108.method_61433();
                }
                entity.field_6012 = 0;
            }
            while (currentTick < this.settings.startTick()) {
                this.setServerTickAndWait(replayServer, ++currentTick, true);
                this.runClientTick(false);
            }
            class_746 player = minecraft.field_1724;
            if (player != null) {
                class_243 position = this.settings.initialCameraPosition();
                player.method_5808(position.field_1352, position.field_1351, position.field_1350, this.settings.initialCameraYaw(), this.settings.initialCameraPitch());
                player.method_66233().method_66272();
                player.method_18799(class_243.field_1353);
            }
            this.settings.editorState().applyKeyframes(new MinecraftKeyframeHandler(class_310.method_1551()), this.settings.startTick());
            this.runClientTick(false);
            this.setServerTickAndWait(replayServer, this.settings.startTick(), true);
            this.runClientTick(false);
        }
        minecraft.method_1507(null);
    }

    private void setServerTickAndWait(ReplayServer replayServer, int targetTick, boolean force) {
        if (force || replayServer.getReplayTick() != targetTick) {
            this.finishedServerTick.set(false);
            replayServer.jumpToTick = targetTick;
            replayServer.replayPaused = true;
            replayServer.sendFinishedServerTick.set(true);
            while (!this.finishedServerTick.compareAndExchange(true, false)) {
                LockSupport.parkNanos("waiting for server thread", 100000L);
            }
        }
    }

    private void runClientTick(boolean frozen) {
        this.updateClientFreeze(frozen);
        class_310 minecraft = class_310.method_1551();
        while (minecraft.method_16075()) {
        }
        this.updateClientFreeze(frozen);
        minecraft.method_1574();
        this.updateSoundSource(minecraft);
        this.updateClientFreeze(frozen);
    }

    private void updateSoundSource(class_310 minecraft) {
        class_4184 audioCamera;
        EditorState editorState = this.settings.editorState();
        if (editorState != null && (audioCamera = editorState.getAudioCamera()) != null) {
            minecraft.method_1483().method_4876(audioCamera);
            return;
        }
        minecraft.method_1483().method_4876(class_310.method_1551().field_1773.method_19418());
    }

    private void updateClientFreeze(boolean frozen) {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            level.method_54719().method_54675(frozen);
        }
    }

    private void submitDownloadedFrames(VideoWriter videoWriter, SaveableFramebufferQueue downloader, boolean drain) {
        while (true) {
            long start = System.nanoTime();
            SaveableFramebufferQueue.DownloadedFrame frame = downloader.finishDownload(drain);
            this.downloadTimeNanos += System.nanoTime() - start;
            if (frame == null) break;
            if (this.firstFrame == null) {
                this.firstFrame = frame.image().method_48462(x -> 0xFF000000 | x);
            }
            ++this.writtenFrames;
            start = System.nanoTime();
            videoWriter.encode(frame.image(), frame.audioBuffer());
            this.encodeTimeNanos += System.nanoTime() - start;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean finishFrame(class_276 framebuffer, int currentFrame, int totalFrames) {
        boolean cancel;
        block22: {
            class_4597.class_4598 bufferSource;
            class_1041 window;
            block24: {
                int patreonWidth;
                String patreon;
                int y;
                int x;
                Matrix4f matrix;
                class_327 font;
                block23: {
                    boolean debugPressed;
                    cancel = false;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - this.lastRenderMillis <= 16L && currentFrame != totalFrames) break block22;
                    this.progressCount = currentFrame;
                    this.progressOutOf = totalFrames;
                    window = class_310.method_1551().method_22683();
                    this.lastRenderMillis = currentTime;
                    font = class_310.method_1551().field_1772;
                    bufferSource = class_310.method_1551().method_22940().method_23000();
                    bufferSource.method_22993();
                    RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(framebuffer.method_30278(), 1.0);
                    float guiScale = 4.0f;
                    int scaledWidth = (int)Math.ceil((float)framebuffer.field_1482 / guiScale);
                    int scaledHeight = (int)Math.ceil((float)framebuffer.field_1481 / guiScale);
                    if (projectionBuffers == null) {
                        projectionBuffers = new class_11278("flashback export", 1000.0f, 21000.0f, true);
                    }
                    RenderSystem.setProjectionMatrix((GpuBufferSlice)projectionBuffers.method_71092((float)scaledWidth, (float)scaledHeight), (class_10366)class_10366.field_54954);
                    matrix = new Matrix4f();
                    matrix.translate(0.0f, 0.0f, -1001.0f);
                    ArrayList<Object> lines = new ArrayList<Object>();
                    if (this.settings.name() != null) {
                        lines.add(this.settings.name());
                        lines.add("");
                    }
                    lines.add("Exported Frames: " + currentFrame + "/" + totalFrames);
                    long elapsed = currentTime - this.renderStartTime;
                    lines.add("Time elapsed: " + this.formatTime(elapsed));
                    if ((double)currentFrame >= this.settings.framerate()) {
                        long estimatedRemaining = (currentTime - this.renderStartTime) * (long)(totalFrames - currentFrame) / (long)currentFrame;
                        lines.add("Estimated time remaining: " + this.formatTime(estimatedRemaining));
                    } else {
                        lines.add("Estimated time remaining: ~");
                    }
                    lines.add("");
                    boolean bl = debugPressed = GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)292) != 0;
                    if (this.pressedDebugKey != debugPressed) {
                        this.pressedDebugKey = debugPressed;
                        if (this.pressedDebugKey) {
                            boolean bl2 = this.showingDebug = !this.showingDebug;
                        }
                    }
                    if (this.showingDebug) {
                        lines.add("ST: " + this.serverTickTimeNanos / 1000000L + ", CT: " + this.clientTickTimeNanos / 1000000L);
                        lines.add("RT: " + this.renderTimeNanos / 1000000L + ", ET: " + this.encodeTimeNanos / 1000000L);
                        lines.add("DT: " + this.downloadTimeNanos / 1000000L);
                    } else {
                        lines.add("Press [F3] to show debug info");
                    }
                    lines.add("");
                    if (currentFrame == totalFrames) {
                        lines.add("Saving...");
                    } else if (GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)256) != 0) {
                        long current = System.currentTimeMillis();
                        if (this.escapeCancelStartMillis <= 0L || current < this.escapeCancelStartMillis) {
                            this.escapeCancelStartMillis = current;
                        }
                        if (current - this.escapeCancelStartMillis > 3000L) {
                            cancel = true;
                            lines.add("Saving...");
                        } else {
                            long remainingSeconds = 3L - (current - this.escapeCancelStartMillis) / 1000L;
                            lines.add("Hold [ESC] to cancel (" + remainingSeconds + "s)");
                        }
                    } else {
                        lines.add("Hold [ESC] to cancel");
                        this.escapeCancelStartMillis = -1L;
                    }
                    x = scaledWidth / 2;
                    int n = scaledHeight / 2;
                    Objects.requireNonNull(font);
                    y = n - 9 * (lines.size() + 1) / 2;
                    for (String string : lines) {
                        if (string.isEmpty()) {
                            Objects.requireNonNull(font);
                            y += 9 / 2 + 1;
                            continue;
                        }
                        font.method_27521(string, (float)x - (float)font.method_1727(string) / 2.0f, (float)y, -1, true, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                        Objects.requireNonNull(font);
                        y += 9;
                    }
                    double mouseX = ReplayUI.imguiGlfw.rawMouseX / (double)window.method_4480() * (double)scaledWidth;
                    double mouseY = ReplayUI.imguiGlfw.rawMouseY / (double)window.method_4507() * (double)scaledHeight;
                    Objects.requireNonNull(font);
                    y += 9 / 2 + 1;
                    patreon = "https://www.patreon.com/flashbackmod";
                    patreonWidth = font.method_1727(patreon);
                    if (!(mouseX > (double)((float)x - (float)patreonWidth / 2.0f)) || !(mouseX < (double)((float)x + (float)patreonWidth / 2.0f)) || !(mouseY > (double)y)) break block23;
                    Objects.requireNonNull(font);
                    if (!(mouseY < (double)(y + 9))) break block23;
                    font.method_27522((class_2561)class_2561.method_43470((String)patreon).method_27692(class_124.field_1073), (float)x - (float)patreonWidth / 2.0f, (float)y, -1, true, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                    if (GLFW.glfwGetMouseButton((long)window.method_4490(), (int)0) != 0) {
                        if (!this.patreonLinkClicked) {
                            this.patreonLinkClicked = true;
                            class_156.method_668().method_670(patreon);
                        }
                        break block24;
                    } else {
                        this.patreonLinkClicked = false;
                    }
                    break block24;
                }
                font.method_27521(patreon, (float)x - (float)patreonWidth / 2.0f, (float)y, -1, true, matrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                this.patreonLinkClicked = false;
            }
            bufferSource.method_22993();
            if (!window.method_65966()) {
                int windowFramebufferWidth = WindowSizeTracker.getWidth(window);
                int windowFramebufferHeight = WindowSizeTracker.getHeight(window);
                FramebufferUtils.blitToScreenPartial(framebuffer, windowFramebufferWidth, windowFramebufferHeight, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            window.method_15998(null);
        }
        return cancel;
    }

    private String formatTime(long millis) {
        long seconds = millis / 1000L % 60L;
        long minutes = millis / 1000L / 60L % 60L;
        long hours = millis / 1000L / 60L / 60L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m " + seconds + "s";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds + "s";
        }
        return seconds + "s";
    }

    private static List<TickInfo> calculateTicks(EditorState editorState, int startTick, int endTick, double fps) {
        ArrayList<TickInfo> ticks = new ArrayList<TickInfo>();
        ticks.add(new TickInfo(0.0, 0.0, false));
        double residual = 0.0;
        int currentTick = 0;
        TickrateKeyframeCapture capture = new TickrateKeyframeCapture();
        int count = endTick - startTick;
        int startFrozen = -1;
        while (currentTick <= count) {
            double freezeDerivative;
            capture.tickrate = 20.0f;
            capture.frozen = false;
            editorState.applyKeyframes(capture, (float)(startTick + currentTick) + (float)residual);
            int roundedResidual = (int)(residual += (double)capture.tickrate / fps);
            residual -= (double)roundedResidual;
            if ((currentTick += roundedResidual) > count) break;
            double currentTickDouble = (double)currentTick + residual;
            if (!capture.frozen) {
                startFrozen = -1;
                ticks.add(new TickInfo(currentTickDouble, currentTickDouble, false));
                continue;
            }
            if (startFrozen < 0) {
                startFrozen = currentTick;
            }
            if (capture.frozenDelay == 0) {
                ticks.add(new TickInfo(currentTickDouble, Math.min(currentTickDouble, (double)startFrozen), true));
                continue;
            }
            double deltaFromStart = currentTickDouble - (double)startFrozen;
            double freezeClientTicks = capture.frozenDelay <= 5 ? 0.999 : 1.999;
            double d = freezeDerivative = capture.frozenDelay <= 5 ? 1.0 : 0.5;
            if (deltaFromStart > (double)capture.frozenDelay) {
                ticks.add(new TickInfo(currentTickDouble, Math.min(currentTickDouble, (double)startFrozen + freezeClientTicks), true));
                continue;
            }
            if (capture.frozenDelay == 1) {
                ticks.add(new TickInfo(currentTickDouble, Math.min(currentTickDouble, (double)startFrozen + freezeClientTicks), false));
                continue;
            }
            double freezePowerBase = FreezeSlowdownFormula.getFreezePowerBase(capture.frozenDelay, freezeDerivative);
            double clientTicks = freezeClientTicks * FreezeSlowdownFormula.calculateFreezeClientTick(deltaFromStart, capture.frozenDelay, freezePowerBase);
            ticks.add(new TickInfo(currentTickDouble, Math.min(currentTickDouble, (double)startFrozen + clientTicks), false));
        }
        return ticks;
    }

    private record TickInfo(double serverTick, double clientTick, boolean frozen) {
    }
}

