/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin.compat.bobby;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import de.johni0702.minecraft.bobby.ChunkSerializer;
import de.johni0702.minecraft.bobby.FakeChunkManager;
import java.util.function.Supplier;
import net.minecraft.class_2818;
import net.minecraft.class_634;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@IfModLoaded(value="bobby")
@Pseudo
@Mixin(value={FakeChunkManager.class}, remap=false)
public class MixinBobbyFakeChunkManager {
    @Inject(method={"getCurrentWorldOrServerName"}, require=0, at={@At(value="HEAD")}, cancellable=true)
    private static void getCurrentWorldOrServerName(class_634 networkHandler, CallbackInfoReturnable<String> cir) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            FlashbackMeta meta = replayServer.getMetadata();
            if (meta != null && meta.bobbyWorldName != null) {
                Flashback.LOGGER.info("Overriding Bobby World Name: {}", (Object)meta.bobbyWorldName);
                cir.setReturnValue((Object)meta.bobbyWorldName);
            } else {
                cir.setReturnValue((Object)"unknown_flashback");
            }
        }
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, require=0, cancellable=true)
    public void save(class_2818 chunk, CallbackInfoReturnable<Supplier<class_2818>> cir) {
        if (Flashback.isInReplay()) {
            Pair copy = ChunkSerializer.shallowCopy((class_2818)chunk);
            cir.setReturnValue((Object)((Supplier)copy.getRight()));
        }
    }
}

