/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.screen;

import com.google.gson.JsonElement;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.FlashbackGson;
import com.moulberry.flashback.FlashbackTextComponents;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.screen.BottomTextWidget;
import com.moulberry.flashback.screen.CombineReplayScreen;
import com.moulberry.flashback.screen.ReplaySummary;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class EditReplayScreen
extends class_437 {
    @Nullable
    private final class_437 lastScreen;
    private final FlashbackMeta metadata;
    private String changedReplayName;
    private class_4185 saveChangesButton;
    private final Path replayPath;

    public EditReplayScreen(@Nullable class_437 lastScreen, ReplaySummary summary) {
        super(FlashbackTextComponents.EDIT_REPLAY);
        this.lastScreen = lastScreen;
        this.metadata = summary.getReplayMetadata();
        this.changedReplayName = summary.getReplayName();
        this.replayPath = summary.getPath();
    }

    protected void method_56131() {
    }

    protected void method_25426() {
        super.method_25426();
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46458().method_46466(4, 4, 4, 0);
        class_7845.class_7939 rowHelper = gridLayout.method_47610(2);
        rowHelper.method_47613((class_8021)new class_7842(204, 20, FlashbackTextComponents.EDIT_REPLAY, this.field_22793), 2);
        rowHelper.method_47613((class_8021)new BottomTextWidget(204, 10, FlashbackTextComponents.REPLAY_NAME, this.field_22793).alignLeft(), 2);
        class_342 replayNameEditBox = new class_342(this.field_22793, 0, 0, 204, 20, (class_2561)class_2561.method_43470((String)this.changedReplayName));
        replayNameEditBox.method_1880(128);
        replayNameEditBox.method_1852(this.changedReplayName);
        replayNameEditBox.method_1863(this::setReplayName);
        rowHelper.method_47613((class_8021)replayNameEditBox, 2);
        rowHelper.method_47613((class_8021)new BottomTextWidget(204, 10, class_5244.field_39003, this.field_22793), 2);
        rowHelper.method_47613((class_8021)class_4185.method_46430((class_2561)FlashbackTextComponents.COMBINE_WITH_OTHER_REPLAY, button -> this.field_22787.method_1507((class_437)new CombineReplayScreen(this, this.replayPath, null, null))).method_46432(204).method_46431(), 2);
        this.saveChangesButton = (class_4185)rowHelper.method_47612((class_8021)class_4185.method_46430((class_2561)FlashbackTextComponents.SAVE_CHANGES, button -> this.applyChanges()).method_46432(98).method_46431());
        this.saveChangesButton.field_22763 = false;
        rowHelper.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.field_22787.method_1507(this.lastScreen)).method_46432(98).method_46431());
        gridLayout.method_48222();
        class_7843.method_46443((class_8021)gridLayout, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (float)0.5f, (float)0.5f);
        gridLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.updateSaveChangesActive();
        this.method_48265((class_364)replayNameEditBox);
    }

    private void applyChanges() {
        this.metadata.name = this.changedReplayName;
        try (FileSystem fileSystem = FileSystems.newFileSystem(this.replayPath);){
            Path metadataPath = fileSystem.getPath("/metadata.json", new String[0]);
            String metadataJson = FlashbackGson.PRETTY.toJson((JsonElement)this.metadata.toJson());
            Files.writeString(metadataPath, (CharSequence)metadataJson, new OpenOption[0]);
        }
        catch (IOException e) {
            Flashback.LOGGER.error("Unable to edit replay", (Throwable)e);
            class_310.method_1551().method_1507((class_437)new class_403(() -> class_310.method_1551().method_1507(this.lastScreen), FlashbackTextComponents.UNABLE_TO_EDIT_REPLAY, (class_2561)class_2561.method_43470((String)e.toString())));
        }
        this.updateSaveChangesActive();
        this.method_48267();
    }

    private void setReplayName(String name) {
        this.changedReplayName = name;
        this.updateSaveChangesActive();
    }

    private void updateSaveChangesActive() {
        this.saveChangesButton.field_22763 = !Objects.equals(this.metadata.name, this.changedReplayName);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }
}

