/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.screen;

import com.moulberry.flashback.record.FlashbackMeta;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ReplaySummary
implements Comparable<ReplaySummary> {
    private final Path path;
    private final FlashbackMeta metadata;
    private final String replayId;
    private final long lastModified;
    private final long filesize;
    private final byte[] iconBytes;
    private class_2561 info = null;
    private class_2561 hoverInfo = null;
    private boolean canOpen = true;
    private boolean hasWarning = false;
    private boolean hasNamespaceMismatch = false;

    public ReplaySummary(Path path, FlashbackMeta metadata, LinkedHashMap<String, LinkedHashSet<String>> currentNamespacesForRegistries, String replayId, long lastModified, long filesize, @Nullable byte[] iconBytes) {
        this.path = path;
        this.metadata = metadata;
        this.replayId = replayId;
        this.lastModified = lastModified;
        this.filesize = filesize;
        this.iconBytes = iconBytes;
        if (metadata.namespacesForRegistries != null && !currentNamespacesForRegistries.equals(metadata.namespacesForRegistries)) {
            this.hasNamespaceMismatch = true;
        }
        if (metadata.protocolVersion != 0 && metadata.protocolVersion != class_155.method_31372()) {
            this.canOpen = false;
            this.hoverInfo = metadata.versionString != null && !metadata.versionString.equals("1.21.8") ? class_2561.method_43469((String)"flashback.incompatible_replay_version", (Object[])new Object[]{class_2561.method_43470((String)metadata.versionString), class_2561.method_43470((String)"1.21.8")}) : class_2561.method_43469((String)"flashback.incompatible_replay_version_protocol", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(metadata.protocolVersion)), class_2561.method_43470((String)String.valueOf(class_155.method_31372()))});
        } else if (metadata.dataVersion != 0 && metadata.dataVersion != class_155.method_16673().comp_4026().comp_4038()) {
            this.hasWarning = true;
            this.hoverInfo = metadata.versionString != null && !metadata.versionString.equals("1.21.8") ? class_2561.method_43469((String)"flashback.maybe_incompatible_replay_version", (Object[])new Object[]{class_2561.method_43470((String)metadata.versionString), class_2561.method_43470((String)"1.21.8")}) : class_2561.method_43469((String)"flashback.incompatible_replay_version_data", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(metadata.dataVersion)), class_2561.method_43470((String)String.valueOf(class_155.method_16673().comp_4026().comp_4038()))});
        } else if (this.hasNamespaceMismatch) {
            this.hasWarning = true;
            this.hoverInfo = class_2561.method_43471((String)"flashback.maybe_incompatible_registry_data");
        }
    }

    public Path getPath() {
        return this.path;
    }

    public String getReplayId() {
        return this.replayId;
    }

    public FlashbackMeta getReplayMetadata() {
        return this.metadata;
    }

    public String getReplayName() {
        return this.metadata.name.isEmpty() ? this.replayId : this.metadata.name;
    }

    @Nullable
    public String getWorldName() {
        return this.metadata.worldName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public class_2561 getInfo() {
        if (this.info == null) {
            class_5250 mutable = class_2561.method_43473();
            if (this.metadata.totalTicks > 0) {
                int ticks = this.metadata.totalTicks;
                int seconds = ticks / 20 % 60;
                int minutes = ticks / 20 / 60 % 60;
                int hours = ticks / 20 / 60 / 60;
                StringBuilder builder = new StringBuilder();
                if (hours > 0) {
                    builder.append(hours).append('h');
                }
                if (minutes > 0) {
                    if (!builder.isEmpty()) {
                        builder.append(' ');
                    }
                    builder.append(minutes).append('m');
                }
                if (seconds > 0) {
                    if (!builder.isEmpty()) {
                        builder.append(' ');
                    }
                    builder.append(seconds).append('s');
                }
                if (builder.isEmpty()) {
                    builder.append("0s");
                }
                mutable.method_10852((class_2561)class_2561.method_43469((String)"flashback.select_replay.duration", (Object[])new Object[]{builder}));
            }
            this.info = mutable;
        }
        return this.info;
    }

    public byte[] getIconBytes() {
        return this.iconBytes;
    }

    public class_2561 getHoverInfo() {
        return this.hoverInfo;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean hasNamespaceMismatch() {
        return this.hasNamespaceMismatch;
    }

    public boolean canOpen() {
        return this.canOpen;
    }

    @Override
    public int compareTo(ReplaySummary levelSummary) {
        if (this.getLastModified() < levelSummary.getLastModified()) {
            return 1;
        }
        if (this.getLastModified() > levelSummary.getLastModified()) {
            return -1;
        }
        return this.replayId.compareTo(levelSummary.replayId);
    }
}

