/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.screen.select_replay;

import com.mojang.logging.LogUtils;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.RegistryMetaHelper;
import com.moulberry.flashback.screen.EditReplayScreen;
import com.moulberry.flashback.screen.ReplaySummary;
import com.moulberry.flashback.screen.select_replay.ReplaySelectionList;
import com.moulberry.flashback.screen.select_replay.SelectReplayScreen;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_424;
import net.minecraft.class_4280;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7413;
import net.minecraft.class_8573;
import net.minecraft.class_8666;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class ReplaySelectionEntry
extends class_4280.class_4281<ReplaySelectionEntry>
implements AutoCloseable {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
    private static final class_2960 FOLDER_SPRITE = Flashback.createResourceLocation("folder");
    private static final class_2960 ERROR_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"world_list/error_highlighted");
    private static final class_2960 ERROR_SPRITE = class_2960.method_60656((String)"world_list/error");
    private static final class_2960 WARNING_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"world_list/warning_highlighted");
    private static final class_2960 WARNING_SPRITE = class_2960.method_60656((String)"world_list/warning");
    private static final class_2960 JOIN_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"world_list/join_highlighted");
    private static final class_2960 JOIN_SPRITE = class_2960.method_60656((String)"world_list/join");
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public void close() {
    }

    public static class ReplayListEntry
    extends ReplaySelectionEntry
    implements AutoCloseable {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private final class_310 minecraft;
        private final ReplaySelectionList replaySelectionList;
        final ReplaySummary summary;
        private class_8573 icon;
        private long lastClickTime;

        public ReplayListEntry(ReplaySelectionList replaySelectionList, class_310 minecraft, ReplaySummary ReplaySummary2) {
            this.minecraft = minecraft;
            this.replaySelectionList = replaySelectionList;
            this.summary = ReplaySummary2;
            this.icon = class_8573.method_52200((class_1060)this.minecraft.method_1531(), (String)ReplaySummary2.getReplayId());
            this.loadIcon();
        }

        public class_2561 method_37006() {
            class_5250 component = class_2561.method_43469((String)"narrator.select.world_info", (Object[])new Object[]{this.summary.getReplayName(), class_2561.method_54157((Date)new Date(this.summary.getLastModified())), this.summary.getInfo()});
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{component});
        }

        public void method_25343(class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            Object title = this.summary.getReplayName();
            Object fileAndTime = this.summary.getReplayId();
            long p = this.summary.getLastModified();
            if (p != -1L) {
                fileAndTime = (String)fileAndTime + " (" + DATE_FORMAT.format(Instant.ofEpochMilli(p)) + ")";
            }
            if (StringUtils.isEmpty((CharSequence)title)) {
                title = class_1074.method_4662((String)"flashback.select_replay.replay", (Object[])new Object[0]) + " " + (index + 1);
            }
            class_2561 info = this.summary.getInfo();
            int titleColour = -1;
            if (!this.summary.canOpen()) {
                titleColour = -43691;
            } else if (this.summary.hasWarning()) {
                titleColour = -21931;
            }
            guiGraphics.method_51433(this.minecraft.field_1772, (String)title, x + 32 + 3, y + 1, titleColour, false);
            int titleEnd = x + 32 + 3 + this.minecraft.field_1772.method_1727((String)title);
            String worldName = this.summary.getWorldName();
            if (worldName != null) {
                guiGraphics.method_51433(this.minecraft.field_1772, "(" + worldName + ")", titleEnd + 4, y + 1, -8355712, false);
            }
            class_327 class_3272 = this.minecraft.field_1772;
            Objects.requireNonNull(this.minecraft.field_1772);
            guiGraphics.method_51433(class_3272, (String)fileAndTime, x + 32 + 3, y + 9 + 3, -8355712, false);
            class_327 class_3273 = this.minecraft.field_1772;
            Objects.requireNonNull(this.minecraft.field_1772);
            Objects.requireNonNull(this.minecraft.field_1772);
            guiGraphics.method_51439(class_3273, info, x + 32 + 3, y + 9 + 9 + 3, -8355712, false);
            guiGraphics.method_25290(class_10799.field_56883, this.icon.method_52201(), x, y, 0.0f, 0.0f, 32, 32, 32, 32);
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                boolean hoveredIcon;
                guiGraphics.method_25294(x, y, x + 32, y + 32, -1601138544);
                int q = mouseX - x;
                boolean bl = hoveredIcon = q < 32;
                if (hovered && this.summary.getHoverInfo() != null) {
                    guiGraphics.method_51447(this.minecraft.field_1772, this.minecraft.field_1772.method_1728((class_5348)this.summary.getHoverInfo(), 240), mouseX, mouseY);
                }
                class_2960 iconOverlay = !this.summary.canOpen() ? (hoveredIcon ? ERROR_HIGHLIGHTED_SPRITE : ERROR_SPRITE) : (this.summary.hasWarning() ? (hoveredIcon ? WARNING_HIGHLIGHTED_SPRITE : WARNING_SPRITE) : (hoveredIcon ? JOIN_HIGHLIGHTED_SPRITE : JOIN_SPRITE));
                guiGraphics.method_52706(class_10799.field_56883, iconOverlay, x, y, 32, 32);
            }
        }

        public boolean method_25402(double d, double e, int i) {
            if (!this.summary.canOpen()) {
                return true;
            }
            this.replaySelectionList.setSelected(this);
            if (d - (double)this.replaySelectionList.method_25342() <= 32.0 || class_156.method_658() - this.lastClickTime < 250L) {
                if (this.canOpen()) {
                    this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                    this.openReplay();
                }
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return super.method_25402(d, e, i);
        }

        public boolean canOpen() {
            return this.summary.canOpen();
        }

        public void openReplay() {
            if (this.summary.canOpen()) {
                if (this.summary.hasNamespaceMismatch()) {
                    class_437 previousScreen = this.minecraft.field_1755;
                    BooleanConsumer afterWarning = doLoad -> {
                        if (doLoad) {
                            this.minecraft.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"flashback.select_replay.data_read")));
                            Flashback.openReplayWorld(this.summary.getPath());
                        } else {
                            this.minecraft.method_1507(previousScreen);
                        }
                    };
                    class_2561 message = RegistryMetaHelper.createMismatchWarning(this.replaySelectionList.currentNamespacesForRegistries, this.summary.getReplayMetadata().namespacesForRegistries);
                    this.minecraft.method_1507((class_437)new class_410(afterWarning, (class_2561)class_2561.method_43471((String)"flashback.screen_registry_mismatch"), message, (class_2561)class_2561.method_43471((String)"selectWorld.backupJoinSkipButton"), class_5244.field_24335));
                } else {
                    this.minecraft.method_29970((class_437)new class_424((class_2561)class_2561.method_43471((String)"flashback.select_replay.data_read")));
                    Flashback.openReplayWorld(this.summary.getPath());
                }
            }
        }

        public void deleteReplay() {
            this.minecraft.method_1507((class_437)new class_410(bl -> {
                if (bl) {
                    this.minecraft.method_1507((class_437)new class_435(true));
                    this.doDeleteReplay();
                }
                this.minecraft.method_1507((class_437)this.replaySelectionList.getScreen());
            }, (class_2561)class_2561.method_43471((String)"flashback.select_replay.delete_question"), (class_2561)class_2561.method_43469((String)"selectWorld.deleteWarning", (Object[])new Object[]{this.summary.getReplayName()}), (class_2561)class_2561.method_43471((String)"selectWorld.deleteButton"), class_5244.field_24335));
        }

        private void doDeleteReplay() {
            String id = this.summary.getReplayId();
            try {
                Files.delete(this.summary.getPath());
            }
            catch (IOException e) {
                class_370.method_27025((class_310)this.minecraft, (String)id);
                LOGGER.error("Failed to delete replay {}", (Object)id, (Object)e);
            }
            this.replaySelectionList.reloadReplayList();
        }

        public void editReplay() {
            class_310.method_1551().method_1507((class_437)new EditReplayScreen(class_310.method_1551().field_1755, this.summary));
        }

        private void loadIcon() {
            byte[] iconBytes = this.summary.getIconBytes();
            if (iconBytes != null) {
                try {
                    this.icon.method_52199(class_1011.method_49277((byte[])iconBytes));
                    return;
                }
                catch (Throwable t) {
                    LOGGER.error("Invalid icon for replay {}", (Object)this.summary.getReplayId(), (Object)t);
                }
            }
            this.icon.method_52198();
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
                this.icon = null;
            }
        }
    }

    public static class ReplayFolder
    extends ReplaySelectionEntry
    implements AutoCloseable {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private final class_310 minecraft;
        private final ReplaySelectionList replaySelectionList;
        private final Path path;
        private final String nameString;
        private final class_2561 nameComponent;
        private final long modifiedTime;
        private final int replayCount;
        private long lastClickTime;

        public ReplayFolder(ReplaySelectionList replaySelectionList, class_310 minecraft, Path path, long modifiedTime, int replayCount) {
            this.minecraft = minecraft;
            this.replaySelectionList = replaySelectionList;
            this.path = path;
            this.nameString = path.getFileName().toString();
            this.nameComponent = class_2561.method_43470((String)this.nameString).method_27692(class_124.field_1067);
            this.modifiedTime = modifiedTime;
            this.replayCount = replayCount;
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.nameComponent});
        }

        public void method_25343(class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            guiGraphics.method_51439(this.minecraft.field_1772, this.nameComponent, x + 32 + 3, y + 1, -1, false);
            Objects.requireNonNull(this.minecraft.field_1772);
            int textY = y + 9 + 2;
            if (this.modifiedTime > 0L) {
                String time = "Created: " + DATE_FORMAT.format(Instant.ofEpochMilli(this.modifiedTime));
                guiGraphics.method_51433(this.minecraft.field_1772, time, x + 32 + 3, textY + 1, -8355712, false);
                Objects.requireNonNull(this.minecraft.field_1772);
                textY += 9;
            }
            guiGraphics.method_51433(this.minecraft.field_1772, "Replays: " + this.replayCount, x + 32 + 3, textY + 3, -8355712, false);
            guiGraphics.method_52706(class_10799.field_56883, FOLDER_SPRITE, x, y, 32, 32);
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                guiGraphics.method_25294(x, y, x + 32, y + 32, -1601138544);
                int q = mouseX - x;
                boolean hoveredIcon = q < 32;
                class_2960 iconOverlay = hoveredIcon ? JOIN_HIGHLIGHTED_SPRITE : JOIN_SPRITE;
                guiGraphics.method_52706(class_10799.field_56883, iconOverlay, x, y, 32, 32);
            }
        }

        public boolean method_25402(double d, double e, int i) {
            this.replaySelectionList.setSelected(this);
            if (d - (double)this.replaySelectionList.method_25342() <= 32.0 || class_156.method_658() - this.lastClickTime < 250L) {
                this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.minecraft.method_1507((class_437)new SelectReplayScreen(this.replaySelectionList.getScreen(), this.path));
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return super.method_25402(d, e, i);
        }
    }

    public static class LoadingHeader
    extends ReplaySelectionEntry {
        private static final class_2561 LOADING_LABEL = class_2561.method_43471((String)"flashback.select_replay.loading_replays");
        private final class_310 minecraft;

        public LoadingHeader(class_310 minecraft) {
            this.minecraft = minecraft;
        }

        public void method_25343(class_332 guiGraphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
            int p = (this.minecraft.field_1755.field_22789 - this.minecraft.field_1772.method_27525((class_5348)LOADING_LABEL)) / 2;
            Objects.requireNonNull(this.minecraft.field_1772);
            int q = j + (m - 9) / 2;
            guiGraphics.method_51439(this.minecraft.field_1772, LOADING_LABEL, p, q, -1, false);
            String string = class_7413.method_43449((long)class_156.method_658());
            int r = (this.minecraft.field_1755.field_22789 - this.minecraft.field_1772.method_1727(string)) / 2;
            Objects.requireNonNull(this.minecraft.field_1772);
            int s = q + 9;
            guiGraphics.method_51433(this.minecraft.field_1772, string, r, s, -8355712, false);
        }

        public class_2561 method_37006() {
            return LOADING_LABEL;
        }
    }

    public static class LoadFromDeviceHeader
    extends ReplaySelectionEntry {
        private static final class_2561 LOAD_REPLAY_LABEL = class_2561.method_43471((String)"flashback.select_replay.load_replay_from_file");
        private static final class_8666 SPRITES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));
        private final class_310 minecraft;

        public LoadFromDeviceHeader(class_310 minecraft) {
            this.minecraft = minecraft;
        }

        public void method_25343(class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            guiGraphics.method_52706(class_10799.field_56883, SPRITES.method_52729(true, hovered), x + 4, y + 2, width - 8, height - 4);
            int p = (this.minecraft.field_1755.field_22789 - this.minecraft.field_1772.method_27525((class_5348)LOAD_REPLAY_LABEL)) / 2;
            Objects.requireNonNull(this.minecraft.field_1772);
            int q = y + (height - 9) / 2 + 1;
            guiGraphics.method_51439(this.minecraft.field_1772, LOAD_REPLAY_LABEL, p, q, -1, true);
        }

        public class_2561 method_37006() {
            return LOAD_REPLAY_LABEL;
        }
    }
}

