/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.flashback.visuals.ShaderManager;
import java.util.OptionalInt;
import net.minecraft.class_10366;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_6367;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public class FramebufferUtils {
    private static class_276 tempRenderTarget = null;

    public static void clear(class_276 renderTarget, int colour) {
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        GpuTexture colourTexture = renderTarget.method_30277();
        GpuTexture depthTexture = renderTarget.method_30278();
        if (colourTexture != null && !colourTexture.isClosed() && depthTexture != null && !depthTexture.isClosed()) {
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(colourTexture, colour, depthTexture, 1.0);
        } else if (colourTexture != null && !colourTexture.isClosed()) {
            RenderSystem.getDevice().createCommandEncoder().clearColorTexture(colourTexture, colour);
        } else if (depthTexture != null && !depthTexture.isClosed()) {
            RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(depthTexture, 1.0);
        }
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }

    public static class_276 resizeOrCreateFramebuffer(class_276 renderTarget, int width, int height) {
        if (renderTarget == null) {
            renderTarget = new class_6367(null, width, height, true);
        } else if (renderTarget.field_1482 != width || renderTarget.field_1481 != height) {
            renderTarget.method_1234(width, height);
        }
        return renderTarget;
    }

    private static void blitTo(GpuTexture from, class_276 to, int width, int height, float x1, float y1, float x2, float y2) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.set((Matrix4fc)new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        Matrix4f oldProjectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        class_10366 oldProjectionType = RenderSystem.getProjectionType();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, 3000.0f), (class_10366)class_10366.field_54954);
        class_287 builder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1585);
        builder.method_22912((float)width * x1, (float)height * y2, 0.0f).method_22913(0.0f, 0.0f);
        builder.method_22912((float)width * x2, (float)height * y2, 0.0f).method_22913(1.0f, 0.0f);
        builder.method_22912((float)width * x2, (float)height * y1, 0.0f).method_22913(1.0f, 1.0f);
        builder.method_22912((float)width * x1, (float)height * y1, 0.0f).method_22913(0.0f, 1.0f);
        try (class_9801 meshData = builder.method_60800();){
            RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
            GpuBuffer gpuBuffer = autoStorageIndexBuffer.method_68274(6);
            GpuBuffer vertexBuffer = class_290.field_1585.uploadImmediateVertexBuffer(meshData.method_60818());
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(to.method_30277(), OptionalInt.empty());){
                renderPass.setPipeline(ShaderManager.BLIT_SCREEN_WITH_UV);
                renderPass.setVertexBuffer(0, vertexBuffer);
                renderPass.setIndexBuffer(gpuBuffer, autoStorageIndexBuffer.method_31924());
                renderPass.bindSampler("InSampler", from);
                renderPass.drawIndexed(0, 6);
            }
        }
        RenderSystem.setProjectionMatrix((Matrix4f)oldProjectionMatrix, (class_10366)oldProjectionType);
        modelViewStack.popMatrix();
    }

    public static void blitToScreenPartial(class_276 renderTarget, int width, int height, float x1, float y1, float x2, float y2) {
        GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        tempRenderTarget = FramebufferUtils.resizeOrCreateFramebuffer(tempRenderTarget, width, height);
        FramebufferUtils.clear(tempRenderTarget, 0);
        FramebufferUtils.blitTo(renderTarget.method_30277(), tempRenderTarget, width, height, x1, y1, x2, y2);
        tempRenderTarget.method_1237();
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }
}

