/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui.windows;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.Utils;
import com.moulberry.flashback.combo_options.VideoContainer;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.editor.ui.windows.StartExportWindow;
import com.moulberry.flashback.exporting.AsyncFileDialogs;
import com.moulberry.flashback.exporting.ExportJob;
import com.moulberry.flashback.exporting.ExportSettings;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import imgui.flashback.ImGui;
import java.nio.file.Path;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ExportScreenshotWindow {
    private static boolean open = false;
    private static boolean close = false;

    public static void render() {
        String title;
        if (open) {
            open = false;
            ImGui.openPopup("###ExportScreenshot");
        }
        if (ImGuiHelper.beginPopupModalCloseable((title = class_1074.method_4662((String)"flashback.export_screenshot", (Object[])new Object[0])) + "###ExportScreenshot", 64)) {
            if (close) {
                close = false;
                ImGui.closeCurrentPopup();
                ImGuiHelper.endPopupModalCloseable();
                return;
            }
            FlashbackConfigV1 config = Flashback.getConfig();
            config.forceDefaultExportSettings.apply(config.internalExport);
            if (config.internalExport.resolution == null || config.internalExport.resolution.length != 2) {
                config.internalExport.resolution = new int[]{1920, 1080};
            }
            ImGuiHelper.inputInt(class_1074.method_4662((String)"flashback.resolution", (Object[])new Object[0]), config.internalExport.resolution);
            config.internalExport.resolution[0] = Math.max(1, config.internalExport.resolution[0]);
            config.internalExport.resolution[1] = Math.max(1, config.internalExport.resolution[1]);
            EditorState editorState = EditorStateManager.getCurrent();
            if (ImGui.checkbox(class_1074.method_4662((String)"flashback.ssaa", (Object[])new Object[0]), config.internalExport.ssaa)) {
                config.internalExport.ssaa = !config.internalExport.ssaa;
            }
            ImGuiHelper.tooltip(class_1074.method_4662((String)"flashback.ssaa_tooltip", (Object[])new Object[0]));
            ImGui.sameLine();
            if (ImGui.checkbox(class_1074.method_4662((String)"flashback.no_gui", (Object[])new Object[0]), config.internalExport.noGui)) {
                config.internalExport.noGui = !config.internalExport.noGui;
            }
            ImGuiHelper.tooltip(class_1074.method_4662((String)"flashback.no_gui_tooltip", (Object[])new Object[0]));
            if (editorState != null && !editorState.replayVisuals.renderSky && ImGui.checkbox(class_1074.method_4662((String)"flashback.transparent_sky", (Object[])new Object[0]), config.internalExport.transparentBackground)) {
                boolean bl = config.internalExport.transparentBackground = !config.internalExport.transparentBackground;
            }
            if (editorState != null && ImGui.button(class_1074.method_4662((String)"flashback.take_screenshot", (Object[])new Object[0]))) {
                String defaultName = StartExportWindow.getDefaultFilename(null, "png", config);
                String defaultExportPathString = config.internalExport.defaultExportPath;
                AsyncFileDialogs.saveFileDialog(defaultExportPathString, defaultName, "PNG", "png").thenAccept(pathStr -> {
                    if (pathStr != null) {
                        Path path = Path.of(pathStr, new String[0]);
                        config.internalExport.defaultExportPath = path.getParent().toString();
                        class_746 player = class_310.method_1551().field_1724;
                        int tick = Flashback.getReplayServer().getReplayTick();
                        boolean transparent = config.internalExport.transparentBackground && !editorState.replayVisuals.renderSky;
                        boolean ssaa = config.internalExport.ssaa;
                        boolean noGui = config.internalExport.noGui;
                        EditorState copiedEditorState = editorState.copyWithoutKeyframes();
                        ExportSettings settings = new ExportSettings(null, copiedEditorState, player.method_73189(), player.method_36454(), player.method_36455(), config.internalExport.resolution[0], config.internalExport.resolution[1], tick, tick, 1.0, false, VideoContainer.PNG_SEQUENCE, null, null, 0, transparent, ssaa, noGui, false, false, null, path, null);
                        close = true;
                        ++Utils.exportSequenceCount;
                        Flashback.EXPORT_JOB = new ExportJob(settings);
                        config.delayedSaveToDefaultFolder();
                    }
                });
            }
            ImGuiHelper.endPopupModalCloseable();
        }
        close = false;
    }

    public static void open() {
        open = true;
    }
}

