/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui.windows;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.editor.ui.windows.ExportQueueWindow;
import com.moulberry.flashback.editor.ui.windows.ExportScreenshotWindow;
import com.moulberry.flashback.editor.ui.windows.PreferencesWindow;
import com.moulberry.flashback.editor.ui.windows.StartExportWindow;
import com.moulberry.flashback.exporting.ExportJobQueue;
import com.moulberry.flashback.screen.select_replay.SelectReplayScreen;
import imgui.flashback.ImGui;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;

public class MainMenuBar {
    public static void render() {
        if (ImGui.beginMainMenuBar()) {
            MainMenuBar.renderInner();
            ImGui.endMainMenuBar();
        }
    }

    public static void renderInner() {
        FlashbackConfigV1 config = Flashback.getConfig();
        if (ImGui.beginMenu(class_1074.method_4662((String)"flashback.menu.file", (Object[])new Object[0]) + "##File")) {
            String name;
            if (ImGui.menuItem(class_1074.method_4662((String)"flashback.menu.file.export_video", (Object[])new Object[0]) + "##ExportVideo")) {
                StartExportWindow.open();
            }
            if (!ExportJobQueue.queuedJobs.isEmpty() && ImGui.menuItem((name = class_1074.method_4662((String)"flashback.menu.file.export_queue", (Object[])new Object[]{ExportJobQueue.count()})) + "###QueuedJobs")) {
                ExportQueueWindow.open();
            }
            if (ImGui.menuItem(class_1074.method_4662((String)"flashback.export_screenshot", (Object[])new Object[0]) + "##ExportScreenshot")) {
                ExportScreenshotWindow.open();
            }
            ImGui.separator();
            if (ImGui.menuItem(class_1074.method_4662((String)"flashback.select_replay.open", (Object[])new Object[0]) + "##Open")) {
                Flashback.openReplayFromFileBrowser();
            }
            if (!config.internal.recentReplays.isEmpty() && ImGui.beginMenu(class_1074.method_4662((String)"flashback.open_recent_replay", (Object[])new Object[0]) + "##OpenRecentReplay")) {
                Path replayFolder = Flashback.getReplayFolder();
                for (String recentReplay : config.internal.recentReplays) {
                    Path path = Path.of(recentReplay, new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    String display = path.toString();
                    try {
                        Path relative = replayFolder.relativize(path);
                        String relativeStr = relative.toString();
                        if (!relativeStr.contains("..")) {
                            display = relativeStr;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!ImGui.menuItem(display)) continue;
                    Flashback.openReplayWorld(path);
                    break;
                }
                ImGui.endMenu();
            }
            if (ImGui.menuItem(class_1074.method_4662((String)"flashback.exit_replay", (Object[])new Object[0]) + "##ExitReplay")) {
                class_310 minecraft = class_310.method_1551();
                if (minecraft.field_1687 != null) {
                    minecraft.field_1687.method_8525((class_2561)class_2561.method_43473());
                }
                minecraft.method_72100();
                minecraft.method_1507((class_437)new SelectReplayScreen((class_437)new class_442()));
            }
            ImGui.endMenu();
        }
        if (ImGui.menuItem(class_1074.method_4662((String)"flashback.preferences", (Object[])new Object[0]) + "##Preferences")) {
            PreferencesWindow.open();
        }
        ImGui.separator();
        if (ImGui.menuItem(class_1074.method_4662((String)"flashback.player_list", (Object[])new Object[0]) + "##PlayerList")) {
            MainMenuBar.toggleWindow("player_list");
        }
        if (ImGui.menuItem(class_1074.method_4662((String)"flashback.movement", (Object[])new Object[0]) + "##Movement")) {
            MainMenuBar.toggleWindow("movement");
        }
        if (ImGui.menuItem(class_1074.method_4662((String)"flashback.render_filter", (Object[])new Object[0]) + "##RenderFilter")) {
            MainMenuBar.toggleWindow("render_filter");
        }
        ImGui.separator();
        if (ImGui.menuItem(class_1074.method_4662((String)"flashback.hide_replay_ui", (Object[])new Object[0]) + "##HideReplayUI")) {
            class_310.method_1551().field_1690.field_1842 = true;
        }
    }

    private static void toggleWindow(String windowName) {
        Set<String> openedWindows = Flashback.getConfig().internal.openedWindows;
        boolean playerListIsOpen = openedWindows.contains(windowName);
        if (playerListIsOpen) {
            openedWindows.remove(windowName);
        } else {
            openedWindows.add(windowName);
        }
        Flashback.getConfig().delayedSaveToDefaultFolder();
    }
}

