/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.ReplayVisuals;
import com.moulberry.flashback.visuals.ShaderManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.OptionalInt;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_11531;
import net.minecraft.class_11532;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_761;
import net.minecraft.class_846;
import net.minecraft.class_8679;
import net.minecraft.class_8921;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9922;
import net.minecraft.class_9960;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class}, priority=1100)
public abstract class MixinLevelRenderer {
    @Shadow
    @Final
    public ObjectArrayList<class_846.class_851> field_45616;
    @Shadow
    @Nullable
    private class_846 field_45614;
    @Shadow
    @Final
    public class_8679 field_45615;
    @Shadow
    private int field_4073;
    @Shadow
    @Final
    private class_9960 field_53081;
    @Unique
    private GpuTexture roundAlphaBuffer = null;
    @Unique
    private GpuTextureView roundAlphaBufferView = null;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            this.field_4073 = replayServer.getReplayTick();
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/TickRateManager;runsNormally()Z")})
    public boolean tick_runsNormally(class_8921 instance, Operation<Boolean> original) {
        if (Flashback.isInReplay()) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    public void renderLevel(class_9922 graphicsResourceAllocator, class_9779 deltaTracker, boolean bl, class_4184 camera, Matrix4f matrix4f, Matrix4f matrix4f2, Matrix4f projection, GpuBufferSlice gpuBufferSlice, Vector4f clearColour, boolean bl2, CallbackInfo ci) {
        ReplayUI.lastProjectionMatrix = projection;
        ReplayUI.lastViewQuaternion = camera.method_23767();
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null) {
            ReplayVisuals visuals = editorState.replayVisuals;
            if (!visuals.renderSky) {
                if (Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
                    clearColour.set(0.0f, 0.0f, 0.0f, 0.0f);
                } else {
                    float[] skyColour = visuals.skyColour;
                    clearColour.set(skyColour[0], skyColour[1], skyColour[2], 1.0f);
                }
            }
        }
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        if (this.roundAlphaBuffer != null) {
            this.roundAlphaBuffer.close();
            this.roundAlphaBuffer = null;
        }
        if (this.roundAlphaBufferView != null) {
            this.roundAlphaBufferView.close();
            this.roundAlphaBufferView = null;
        }
    }

    @Inject(method={"renderBlockDestroyAnimation"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void renderBlockDestroyAnimation(CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"method_62214"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/chunk/ChunkSectionsToRender;renderGroup(Lnet/minecraft/client/renderer/chunk/ChunkSectionLayerGroup;)V")})
    public void method_62214_renderChunkGroup(class_11532 instance, class_11531 chunkSectionLayerGroup, Operation<Void> original) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            return;
        }
        original.call(new Object[]{instance, chunkSectionLayerGroup});
        if (chunkSectionLayerGroup == class_11531.field_61022 && Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
            class_276 main = class_310.method_1551().field_1689;
            if (this.roundAlphaBuffer == null) {
                this.roundAlphaBuffer = RenderSystem.getDevice().createTexture(() -> "flashback round alpha buffer", 8, TextureFormat.RGBA8, main.field_1482, main.field_1481, 1, 1);
                this.roundAlphaBufferView = RenderSystem.getDevice().createTextureView(this.roundAlphaBuffer);
            } else if (this.roundAlphaBuffer.getWidth(0) != main.field_1482 || this.roundAlphaBuffer.getHeight(0) != main.field_1481) {
                this.roundAlphaBuffer.close();
                this.roundAlphaBufferView.close();
                this.roundAlphaBuffer = RenderSystem.getDevice().createTexture(() -> "flashback round alpha buffer", 8, TextureFormat.RGBA8, main.field_1482, main.field_1481, 1, 1);
                this.roundAlphaBufferView = RenderSystem.getDevice().createTextureView(this.roundAlphaBuffer);
            }
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "flashback round alpha render pass 1", this.roundAlphaBufferView, OptionalInt.empty());){
                renderPass.setPipeline(ShaderManager.BLIT_SCREEN);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.bindSampler("InSampler", main.method_71639());
                renderPass.draw(0, 3);
            }
            renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "flashback round alpha render pass 2", main.method_71639(), OptionalInt.empty());
            try {
                renderPass.setPipeline(ShaderManager.BLIT_SCREEN_ROUND_ALPHA);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.bindSampler("InSampler", this.roundAlphaBufferView);
                renderPass.draw(0, 3);
            }
            finally {
                if (renderPass != null) {
                    renderPass.close();
                }
            }
        }
    }

    @Inject(method={"submitBlockEntities"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBlockEntities(CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            ci.cancel();
        }
    }

    @WrapWithCondition(method={"submitEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;submit(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;Lnet/minecraft/client/renderer/state/CameraRenderState;DDDLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;)V")})
    public boolean renderEntity(class_898 instance, class_10017 entityRenderState, class_12075 cameraRenderState, double d, double e, double f, class_4587 poseStack, class_11659 submitNodeCollector) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (entityRenderState instanceof class_10055) {
            return editorState == null || editorState.replayVisuals.renderPlayers;
        }
        return editorState == null || editorState.replayVisuals.renderEntities;
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;getCloudsType()Lnet/minecraft/client/CloudStatus;")}, require=0)
    public class_4063 renderLevel_getCloudsType(class_315 instance, Operation<class_4063> original) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderSky) {
            return class_4063.field_18162;
        }
        return (class_4063)original.call(new Object[]{instance});
    }

    @Inject(method={"addParticlesPass"}, at={@At(value="HEAD")}, cancellable=true)
    public void addParticlesPass(CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderParticles) {
            ci.cancel();
        }
    }

    @Inject(method={"addSkyPass"}, at={@At(value="HEAD")}, cancellable=true)
    public void addSkyPass(CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderSky) {
            ci.cancel();
        }
    }
}

