/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.record;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.PacketHelper;
import com.moulberry.flashback.RegistryMetaHelper;
import com.moulberry.flashback.action.ActionAccuratePlayerPosition;
import com.moulberry.flashback.action.ActionCreateLocalPlayer;
import com.moulberry.flashback.action.ActionMoveEntities;
import com.moulberry.flashback.action.ActionNextTick;
import com.moulberry.flashback.action.PositionAndAngle;
import com.moulberry.flashback.compat.DistantHorizonsSupport;
import com.moulberry.flashback.io.AsyncReplaySaver;
import com.moulberry.flashback.io.ReplayWriter;
import com.moulberry.flashback.mixin.compat.bobby.FakeChunkManagerAccessor;
import com.moulberry.flashback.packet.FlashbackAccurateEntityPosition;
import com.moulberry.flashback.record.FlashbackChunkMeta;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.record.IgnoredPacketSet;
import com.moulberry.flashback.record.ReplayMarker;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_10584;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_1259;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_155;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2616;
import net.minecraft.class_2620;
import net.minecraft.class_2629;
import net.minecraft.class_2653;
import net.minecraft.class_2658;
import net.minecraft.class_266;
import net.minecraft.class_2668;
import net.minecraft.class_2672;
import net.minecraft.class_2673;
import net.minecraft.class_2678;
import net.minecraft.class_268;
import net.minecraft.class_2683;
import net.minecraft.class_269;
import net.minecraft.class_2703;
import net.minecraft.class_2720;
import net.minecraft.class_2735;
import net.minecraft.class_2736;
import net.minecraft.class_2739;
import net.minecraft.class_2740;
import net.minecraft.class_2743;
import net.minecraft.class_2744;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_2751;
import net.minecraft.class_2752;
import net.minecraft.class_2757;
import net.minecraft.class_2759;
import net.minecraft.class_276;
import net.minecraft.class_2761;
import net.minecraft.class_2765;
import net.minecraft.class_2767;
import net.minecraft.class_2772;
import net.minecraft.class_2781;
import net.minecraft.class_2784;
import net.minecraft.class_2790;
import net.minecraft.class_2818;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_337;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_355;
import net.minecraft.class_3928;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5889;
import net.minecraft.class_5900;
import net.minecraft.class_631;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.class_6606;
import net.minecraft.class_6864;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_742;
import net.minecraft.class_7438;
import net.minecraft.class_7439;
import net.minecraft.class_746;
import net.minecraft.class_7659;
import net.minecraft.class_7701;
import net.minecraft.class_7782;
import net.minecraft.class_7832;
import net.minecraft.class_8042;
import net.minecraft.class_8589;
import net.minecraft.class_8646;
import net.minecraft.class_8732;
import net.minecraft.class_8734;
import net.minecraft.class_9011;
import net.minecraft.class_9044;
import net.minecraft.class_9053;
import net.minecraft.class_9095;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9157;
import net.minecraft.class_9209;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;

public class Recorder {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final int CHUNK_LENGTH_SECONDS = 300;
    private final AsyncReplaySaver asyncReplaySaver;
    private final class_9139<ByteBuf, class_2596<? super class_8732>> configurationPacketCodec;
    private class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec;
    private int writtenTicksInChunk = 0;
    private int writtenTicks = 0;
    private final FlashbackMeta metadata = new FlashbackMeta();
    private boolean hasTakenScreenshot = false;
    private class_1011 finishedScreenshot = null;
    private final Queue<PacketWithPhase> pendingPackets = new ConcurrentLinkedQueue<PacketWithPhase>();
    private final WeakHashMap<class_1297, Position> lastPositions = new WeakHashMap();
    private WeakReference<class_746> lastLocalPlayer = null;
    private final List<Object> lastPlayerEntityMeta = new ArrayList<Object>();
    private final Map<class_1304, class_1799> lastPlayerEquipment = new EnumMap<class_1304, class_1799>(class_1304.class);
    private final class_1799[] lastHotbarItems = new class_1799[9];
    private class_2338 lastDestroyPos = null;
    private int lastDestroyProgress = -1;
    private int lastSelectedSlot = -1;
    private float lastExperienceProgress = -1.0f;
    private int lastTotalExperience = -1;
    private int lastExperienceLevel = -1;
    private int lastFoodLevel = -1;
    private float lastSaturationLevel = -1.0f;
    private boolean wasSwinging = false;
    private int lastSwingTime = -1;
    private boolean isConfiguring = false;
    private boolean finishedConfiguration = false;
    private boolean finishedPausing = false;
    private class_5321<class_1937> lastDimensionType = null;
    private volatile boolean needsInitialSnapshot = true;
    private volatile boolean closeForWriting = false;
    private volatile boolean isPaused = false;
    private volatile boolean wasPaused = false;
    private volatile boolean skippedPacketDueToWaitingForWrite = false;
    private PositionAndAngle lastPlayerPositionAndAngle = null;
    private float lastPlayerPositionAndAnglePartialTick;
    private final TreeMap<Float, PositionAndAngle> partialPositions = new TreeMap();
    private int trackAccuratePositionCounter = 10;

    public Recorder(class_5455 registryAccess) {
        this.asyncReplaySaver = new AsyncReplaySaver(registryAccess);
        this.configurationPacketCodec = class_9157.field_48699.comp_2236();
        this.gamePacketCodec = class_9095.field_48173.method_68874(class_9129.method_56350((class_5455)registryAccess)).comp_2236();
        this.metadata.dataVersion = class_155.method_16673().comp_4026().comp_4038();
        this.metadata.protocolVersion = class_155.method_31372();
        this.metadata.versionString = FabricLoader.getInstance().getRawGameVersion();
        if (FabricLoader.getInstance().isModLoaded("bobby")) {
            try {
                String bobbyWorldName;
                this.metadata.bobbyWorldName = bobbyWorldName = FakeChunkManagerAccessor.getCurrentWorldOrServerName(class_310.method_1551().method_1562());
            }
            catch (Throwable bobbyWorldName) {
                // empty catch block
            }
        }
        if (Flashback.supportsDistantHorizons) {
            this.metadata.distantHorizonPaths.putAll(DistantHorizonsSupport.getDimensionPaths());
        }
        this.metadata.namespacesForRegistries = RegistryMetaHelper.calculateNamespacesForRegistries();
        String worldName = null;
        class_642 serverData = class_310.method_1551().method_1558();
        if (serverData != null) {
            worldName = serverData.field_3752;
            if (worldName.equalsIgnoreCase(class_1074.method_4662((String)"selectServer.defaultName", (Object[])new Object[0]))) {
                worldName = null;
            }
        } else {
            class_1132 integratedServer = class_310.method_1551().method_1576();
            if (integratedServer != null && (worldName = integratedServer.field_24372.method_150()).equalsIgnoreCase(class_1074.method_4662((String)"selectWorld.newWorld", (Object[])new Object[0]))) {
                worldName = null;
            }
        }
        this.metadata.worldName = worldName;
    }

    public boolean readyToWrite() {
        return !this.closeForWriting && !this.needsInitialSnapshot && !this.wasPaused;
    }

    public void putDistantHorizonsPaths(Map<String, File> paths) {
        this.metadata.distantHorizonPaths.putAll(paths);
    }

    public void addMarker(ReplayMarker marker) {
        this.metadata.replayMarkers.put(this.writtenTicks, marker);
    }

    public void submitCustomTask(Consumer<ReplayWriter> consumer) {
        if (!this.readyToWrite()) {
            return;
        }
        this.asyncReplaySaver.submit(consumer);
    }

    public void setRegistryAccess(class_5455 registryAccess) {
        this.asyncReplaySaver.submit(writer -> writer.setRegistryAccess(registryAccess));
        this.gamePacketCodec = class_9095.field_48173.method_68874(class_9129.method_56350((class_5455)registryAccess)).comp_2236();
    }

    public String getDebugString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Flashback] Recording. T: ");
        builder.append(this.writtenTicks);
        builder.append(". S: ");
        builder.append(this.metadata.chunks.size());
        builder.append(" (");
        builder.append(this.writtenTicksInChunk);
        builder.append("/");
        builder.append(6000);
        builder.append(")");
        return builder.toString();
    }

    public void trackPartialPosition(class_1297 entity, float partialTick) {
        int localPlayerUpdatesPerSecond = Flashback.getConfig().recording.localPlayerUpdatesPerSecond;
        if (localPlayerUpdatesPerSecond <= 20) {
            return;
        }
        double x = class_3532.method_16436((double)partialTick, (double)entity.field_6014, (double)entity.method_23317());
        double y = class_3532.method_16436((double)partialTick, (double)entity.field_6036, (double)entity.method_23318());
        double z = class_3532.method_16436((double)partialTick, (double)entity.field_5969, (double)entity.method_23321());
        float yaw = entity.method_5705(partialTick);
        float pitch = entity.method_5695(partialTick);
        this.partialPositions.put(Float.valueOf(partialTick), new PositionAndAngle(x, y, z, yaw, pitch));
    }

    public void endTick(boolean close) {
        if (this.closeForWriting) {
            return;
        }
        if (close) {
            this.closeForWriting = true;
        }
        if (this.isPaused) {
            this.wasPaused = true;
        }
        if (this.needsInitialSnapshot) {
            this.needsInitialSnapshot = false;
            this.writeSnapshot(true);
        }
        this.finishedConfiguration |= this.flushPackets();
        class_310 minecraft = class_310.method_1551();
        boolean isLevelLoaded = !(class_310.method_1551().field_1755 instanceof class_3928);
        boolean changedDimensions = false;
        int localPlayerUpdatesPerSecond = Flashback.getConfig().recording.localPlayerUpdatesPerSecond;
        boolean trackAccurateFirstPersonPosition = localPlayerUpdatesPerSecond > 20;
        boolean wroteNewTick = false;
        if (!(minecraft.field_1687 == null || minecraft.method_18506() != null && minecraft.method_18506().method_18640() || minecraft.method_1493() || this.isPaused || !isLevelLoaded)) {
            this.writeEntityPositions();
            this.writeLocalData();
            if (trackAccurateFirstPersonPosition) {
                this.writeAccurateFirstPersonPosition(localPlayerUpdatesPerSecond);
            }
            wroteNewTick = true;
            this.asyncReplaySaver.submit(writer -> writer.startAndFinishAction(ActionNextTick.INSTANCE));
            ++this.writtenTicksInChunk;
            ++this.writtenTicks;
            if (this.finishedScreenshot != null) {
                this.asyncReplaySaver.writeIcon(this.finishedScreenshot);
                this.finishedScreenshot = null;
            }
            if (!this.hasTakenScreenshot && (this.writtenTicks >= 20 && minecraft.field_1755 == null || close)) {
                class_318.method_1663((class_276)minecraft.method_1522(), image -> {
                    this.finishedScreenshot = image;
                });
                this.hasTakenScreenshot = true;
            }
            class_5321 dimension = minecraft.field_1687.method_27983();
            if (this.lastDimensionType == null) {
                this.lastDimensionType = dimension;
            } else if (this.lastDimensionType != dimension) {
                this.lastDimensionType = dimension;
                changedDimensions = true;
            }
        } else if (trackAccurateFirstPersonPosition) {
            this.updateLastPlayerPositionAndAngle(class_310.method_1551().field_1724);
            this.partialPositions.clear();
        }
        this.finishedPausing |= this.wasPaused && !this.isPaused;
        boolean writeChunk = close;
        if (minecraft.field_1687 != null) {
            boolean finished = this.finishedConfiguration || this.finishedPausing;
            writeChunk |= this.writtenTicksInChunk >= 6000 || finished || changedDimensions;
        }
        if (writeChunk) {
            if (this.writtenTicksInChunk == 0 || !wroteNewTick) {
                this.asyncReplaySaver.submit(writer -> writer.startAndFinishAction(ActionNextTick.INSTANCE));
                ++this.writtenTicksInChunk;
                ++this.writtenTicks;
            }
            int chunkId = this.metadata.chunks.size();
            String chunkName = "c" + chunkId + ".flashback";
            if (changedDimensions && Flashback.getConfig().recording.markDimensionChanges) {
                this.addMarker(new ReplayMarker(0xAA00AA, null, "Changed Dimension"));
            }
            FlashbackChunkMeta chunkMeta = new FlashbackChunkMeta();
            chunkMeta.duration = this.writtenTicksInChunk;
            this.metadata.chunks.put(chunkName, chunkMeta);
            this.metadata.totalTicks = this.writtenTicks;
            String metadata = GSON.toJson((JsonElement)this.metadata.toJson());
            this.asyncReplaySaver.writeReplayChunk(chunkName, metadata);
            this.writtenTicksInChunk = 0;
            if (!close) {
                if (this.finishedPausing) {
                    this.asyncReplaySaver.submit(ReplayWriter::startSnapshot);
                    this.asyncReplaySaver.submit(ReplayWriter::endSnapshot);
                    this.writeSnapshot(false);
                } else {
                    this.writeSnapshot(true);
                }
            }
            this.finishedPausing = false;
            this.finishedConfiguration = false;
            if (minecraft.field_1687 != null) {
                this.lastDimensionType = minecraft.field_1687.method_27983();
            }
        }
        if (!this.isPaused) {
            this.wasPaused = false;
        }
    }

    private void writeAccurateFirstPersonPosition(int localPlayerUpdatesPerSecond) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            this.lastPlayerPositionAndAngle = null;
            this.partialPositions.clear();
            return;
        }
        if (this.lastPlayerPositionAndAngle != null) {
            int divisions = localPlayerUpdatesPerSecond / 20;
            class_310.method_1551().field_1729.method_55793();
            float nextPartialTick = class_310.method_1551().field_52750.method_60637(true);
            double nextX = class_3532.method_16436((double)nextPartialTick, (double)player.field_6014, (double)player.method_23317());
            double nextY = class_3532.method_16436((double)nextPartialTick, (double)player.field_6036, (double)player.method_23318());
            double nextZ = class_3532.method_16436((double)nextPartialTick, (double)player.field_5969, (double)player.method_23321());
            float nextYaw = player.method_5705(nextPartialTick);
            float nextPitch = player.method_5695(nextPartialTick);
            PositionAndAngle nextPosition = new PositionAndAngle(nextX, nextY, nextZ, nextYaw, nextPitch);
            if (!this.lastPlayerPositionAndAngle.equals(nextPosition)) {
                this.trackAccuratePositionCounter = 10;
            } else if (this.trackAccuratePositionCounter > 0) {
                --this.trackAccuratePositionCounter;
            }
            if (this.trackAccuratePositionCounter > 0) {
                ArrayList<PositionAndAngle> interpolatedPositions = new ArrayList<PositionAndAngle>();
                for (int i = 0; i <= divisions; ++i) {
                    float amount = (float)i / (float)divisions;
                    float floorPartial = -1.0f + this.lastPlayerPositionAndAnglePartialTick;
                    PositionAndAngle floorPosition = this.lastPlayerPositionAndAngle;
                    float ceilPartial = 1.0f + nextPartialTick;
                    PositionAndAngle ceilPosition = nextPosition;
                    Map.Entry<Float, PositionAndAngle> floorEntry = this.partialPositions.floorEntry(Float.valueOf(amount));
                    Map.Entry<Float, PositionAndAngle> ceilEntry = this.partialPositions.ceilingEntry(Float.valueOf(Math.nextUp(amount)));
                    if (floorEntry != null) {
                        floorPartial = floorEntry.getKey().floatValue();
                        floorPosition = floorEntry.getValue();
                    }
                    if (ceilEntry != null) {
                        ceilPartial = ceilEntry.getKey().floatValue();
                        ceilPosition = ceilEntry.getValue();
                    }
                    double lerpAmount = 0.5;
                    if (!Objects.equals(Float.valueOf(floorPartial), Float.valueOf(ceilPartial))) {
                        lerpAmount = (amount - floorPartial) / (ceilPartial - floorPartial);
                    }
                    PositionAndAngle interpolatedPosition = floorPosition.lerp(ceilPosition, lerpAmount);
                    interpolatedPositions.add(interpolatedPosition);
                }
                FlashbackAccurateEntityPosition accurateEntityPosition = new FlashbackAccurateEntityPosition(player.method_5628(), interpolatedPositions);
                this.asyncReplaySaver.submit(writer -> {
                    writer.startAction(ActionAccuratePlayerPosition.INSTANCE);
                    FlashbackAccurateEntityPosition.STREAM_CODEC.encode((Object)writer.friendlyByteBuf(), (Object)accurateEntityPosition);
                    writer.finishAction(ActionAccuratePlayerPosition.INSTANCE);
                });
            }
        }
        this.updateLastPlayerPositionAndAngle(player);
        this.partialPositions.clear();
    }

    private void updateLastPlayerPositionAndAngle(@Nullable class_746 player) {
        Map.Entry<Float, PositionAndAngle> floorEntry = this.partialPositions.floorEntry(Float.valueOf(1.0f));
        if (floorEntry != null) {
            this.lastPlayerPositionAndAngle = floorEntry.getValue();
            this.lastPlayerPositionAndAnglePartialTick = floorEntry.getKey().floatValue();
        } else if (player != null) {
            double x = player.field_6014;
            double y = player.field_6036;
            double z = player.field_5969;
            float yaw = player.method_5705(0.0f);
            float pitch = player.method_5695(0.0f);
            this.lastPlayerPositionAndAngle = new PositionAndAngle(x, y, z, yaw, pitch);
            this.lastPlayerPositionAndAnglePartialTick = 1.0f;
        } else {
            this.lastPlayerPositionAndAngle = null;
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void setPaused(boolean paused) {
        this.isPaused = paused;
    }

    public Path finish() {
        return this.asyncReplaySaver.finish();
    }

    private void writeLocalData() {
        class_636 multiPlayerGameMode;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (this.lastLocalPlayer == null || this.lastLocalPlayer.get() != player) {
            this.resetLastLocalData();
            this.lastLocalPlayer = new WeakReference<class_746>(player);
        }
        ArrayList<class_2596<? super class_2602>> gamePackets = new ArrayList<class_2596<? super class_2602>>();
        if (Flashback.getConfig().recording.recordHotbar) {
            int selectedSlot;
            class_1702 foodData;
            if (player.field_7510 != this.lastExperienceProgress || player.field_7495 != this.lastTotalExperience || player.field_7520 != this.lastExperienceLevel) {
                this.lastExperienceProgress = player.field_7510;
                this.lastTotalExperience = player.field_7495;
                this.lastExperienceLevel = player.field_7520;
                gamePackets.add((class_2596<? super class_2602>)new class_2748(player.field_7510, player.field_7495, player.field_7520));
            }
            if ((foodData = player.method_7344()).method_7586() != this.lastFoodLevel || foodData.method_7589() != this.lastSaturationLevel) {
                this.lastFoodLevel = foodData.method_7586();
                this.lastSaturationLevel = foodData.method_7589();
                gamePackets.add((class_2596<? super class_2602>)new class_2749(player.method_6032(), foodData.method_7586(), foodData.method_7589()));
            }
            if ((selectedSlot = player.method_31548().method_67532()) != this.lastSelectedSlot) {
                gamePackets.add((class_2596<? super class_2602>)new class_2735(selectedSlot));
                this.lastSelectedSlot = selectedSlot;
            }
        }
        class_2945.class_2946[] items = class_310.method_1551().field_1724.method_5841().field_13331;
        ArrayList<class_2945.class_7834> changedData = new ArrayList<class_2945.class_7834>();
        for (int i = 0; i < items.length; ++i) {
            class_1304[] dataItem = items[i];
            Object value = dataItem.method_46359().comp_1117();
            if (i >= this.lastPlayerEntityMeta.size()) {
                this.lastPlayerEntityMeta.add(i, value);
                continue;
            }
            Object old = this.lastPlayerEntityMeta.get(i);
            if (Objects.equals(old, value)) continue;
            this.lastPlayerEntityMeta.set(i, value);
            changedData.add(dataItem.method_46359());
        }
        if (!changedData.isEmpty()) {
            gamePackets.add((class_2596<? super class_2602>)new class_2739(player.method_5628(), changedData));
        }
        ArrayList<Pair> changedSlots = new ArrayList<Pair>();
        for (class_1304 equipmentSlot : class_1304.values()) {
            class_1799 itemStack = player.method_6118(equipmentSlot);
            if (this.lastPlayerEquipment.containsKey(equipmentSlot) && class_1799.method_7973((class_1799)this.lastPlayerEquipment.get(equipmentSlot), (class_1799)itemStack)) continue;
            class_1799 copied = itemStack.method_7972();
            this.lastPlayerEquipment.put(equipmentSlot, copied);
            changedSlots.add(Pair.of((Object)equipmentSlot, (Object)copied));
        }
        if (!changedSlots.isEmpty()) {
            gamePackets.add((class_2596<? super class_2602>)new class_2744(player.method_5628(), changedSlots));
        }
        if (Flashback.getConfig().recording.recordHotbar) {
            for (int i = 0; i < this.lastHotbarItems.length; ++i) {
                class_1799 copied;
                class_1799 hotbarItem = player.method_31548().method_5438(i);
                if (this.lastHotbarItems[i] != null && class_1799.method_7973((class_1799)this.lastHotbarItems[i], (class_1799)hotbarItem)) continue;
                this.lastHotbarItems[i] = copied = hotbarItem.method_7972();
                gamePackets.add((class_2596<? super class_2602>)new class_2653(0, 0, i, copied));
            }
        }
        if ((multiPlayerGameMode = class_310.method_1551().field_1761) == null) {
            this.lastDestroyPos = null;
            this.lastDestroyProgress = -1;
        } else {
            boolean changed;
            class_2338 destroyPos = multiPlayerGameMode.field_3714.method_10062();
            int destroyProgress = multiPlayerGameMode.method_51888();
            boolean bl = changed = destroyProgress != this.lastDestroyProgress;
            if (destroyProgress >= 0) {
                changed |= !destroyPos.equals((Object)this.lastDestroyPos);
            }
            if (changed) {
                gamePackets.add((class_2596<? super class_2602>)new class_2620(player.method_5628(), destroyPos, destroyProgress));
            }
            this.lastDestroyPos = destroyPos;
            this.lastDestroyProgress = destroyProgress;
        }
        if (player.field_6252 && (!this.wasSwinging || this.lastSwingTime > player.field_6279)) {
            int animation = player.field_6266 == class_1268.field_5808 ? 0 : 3;
            gamePackets.add((class_2596<? super class_2602>)new class_2616((class_1297)player, animation));
        }
        this.lastSwingTime = player.field_6279;
        this.wasSwinging = player.field_6252;
        gamePackets.add((class_2596<? super class_2602>)new class_2743(player.method_5628(), player.method_18798()));
        this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
    }

    private void resetLastLocalData() {
        this.lastPlayerEntityMeta.clear();
        this.lastPlayerEquipment.clear();
        this.lastDestroyPos = null;
        this.lastDestroyProgress = -1;
        this.lastSelectedSlot = -1;
        this.lastExperienceProgress = -1.0f;
        this.lastTotalExperience = -1;
        this.lastExperienceLevel = -1;
        this.lastFoodLevel = -1;
        this.lastSaturationLevel = -1.0f;
        Arrays.fill(this.lastHotbarItems, null);
    }

    private void writeEntityPositions() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            this.lastPositions.clear();
            return;
        }
        record IdWithPosition(int id, Position position) {
        }
        ArrayList<IdWithPosition> changedPositions = new ArrayList<IdWithPosition>();
        for (class_1297 entity : level.method_18112()) {
            Position lastPosition;
            Position position;
            class_10584 interpolation;
            if (PacketHelper.shouldIgnoreEntity(entity)) continue;
            float headRot = entity.method_5791();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                float f = headRot = livingEntity.field_6265 > 0 ? (float)livingEntity.field_45123 : livingEntity.method_5791();
            }
            if ((interpolation = entity.method_66233()) != null && interpolation.method_66270()) {
                xyz = interpolation.method_66265();
                position = new Position(xyz.field_1352, xyz.field_1351, xyz.field_1350, interpolation.method_66268(), interpolation.method_66269(), headRot, entity.method_24828());
            } else {
                xyz = entity.method_43390();
                position = new Position(xyz.field_1352, xyz.field_1351, xyz.field_1350, entity.method_36454(), entity.method_36455(), headRot, entity.method_24828());
            }
            if (Objects.equals(position, lastPosition = this.lastPositions.get(entity))) continue;
            this.lastPositions.put(entity, position);
            changedPositions.add(new IdWithPosition(entity.method_5628(), position));
        }
        if (changedPositions.isEmpty()) {
            return;
        }
        this.asyncReplaySaver.submit(writer -> {
            writer.startAction(ActionMoveEntities.INSTANCE);
            class_9129 friendlyByteBuf = writer.friendlyByteBuf();
            friendlyByteBuf.method_10804(1);
            friendlyByteBuf.method_44116(level.method_27983());
            friendlyByteBuf.method_10804(changedPositions.size());
            for (IdWithPosition changedPosition : changedPositions) {
                friendlyByteBuf.method_10804(changedPosition.id);
                friendlyByteBuf.method_52940(changedPosition.position.x);
                friendlyByteBuf.method_52940(changedPosition.position.y);
                friendlyByteBuf.method_52940(changedPosition.position.z);
                friendlyByteBuf.method_52941(changedPosition.position.yaw);
                friendlyByteBuf.method_52941(changedPosition.position.pitch);
                friendlyByteBuf.method_52941(changedPosition.position.headYRot);
                friendlyByteBuf.method_52964(changedPosition.position.onGround);
            }
            writer.finishAction(ActionMoveEntities.INSTANCE);
        });
    }

    public boolean flushPackets() {
        PacketWithPhase packet;
        if (this.pendingPackets.isEmpty()) {
            return false;
        }
        boolean endedConfiguration = false;
        ArrayList<class_2596<? super class_2602>> gamePackets = new ArrayList<class_2596<? super class_2602>>();
        ArrayList<class_2596<? super class_8732>> configurationPackets = new ArrayList<class_2596<? super class_8732>>();
        while ((packet = this.pendingPackets.poll()) != null) {
            if (packet.phase == class_2539.field_20591) {
                if (!configurationPackets.isEmpty()) {
                    this.asyncReplaySaver.writeConfigurationPackets(this.configurationPacketCodec, configurationPackets);
                    configurationPackets.clear();
                }
                gamePackets.add(packet.packet);
                if (packet.packet instanceof class_2678) {
                    this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
                    gamePackets.clear();
                    this.writeCreateLocalPlayer();
                }
                if (!this.isConfiguring) continue;
                endedConfiguration = true;
                this.isConfiguring = false;
                continue;
            }
            if (packet.phase == class_2539.field_45671) {
                if (!gamePackets.isEmpty()) {
                    this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
                    gamePackets.clear();
                }
                configurationPackets.add(packet.packet);
                this.isConfiguring = true;
                continue;
            }
            throw new IllegalArgumentException("Unsupported phase: " + String.valueOf(packet.phase));
        }
        if (!configurationPackets.isEmpty()) {
            this.asyncReplaySaver.writeConfigurationPackets(this.configurationPacketCodec, configurationPackets);
        }
        if (!gamePackets.isEmpty()) {
            this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
            if (this.isConfiguring) {
                endedConfiguration = true;
                this.isConfiguring = false;
            }
        }
        return endedConfiguration;
    }

    private void writeCreateLocalPlayer() {
        class_746 localPlayer = class_310.method_1551().field_1724;
        if (localPlayer != null) {
            UUID uuid = localPlayer.method_5667();
            double x = localPlayer.method_23317();
            double y = localPlayer.method_23318();
            double z = localPlayer.method_23321();
            float xRot = localPlayer.method_36455();
            float yRot = localPlayer.method_36454();
            float yHeadRot = localPlayer.method_5791();
            class_243 deltaMovement = localPlayer.method_18798();
            GameProfile currentProfile = localPlayer.method_7334();
            ImmutableMultimap.Builder propertyMapBuilder = ImmutableMultimap.builder();
            propertyMapBuilder.putAll((Multimap)class_310.method_1551().method_53462().properties());
            propertyMapBuilder.putAll((Multimap)currentProfile.properties());
            GameProfile newProfile = new GameProfile(currentProfile.id(), currentProfile.name(), new PropertyMap((Multimap)propertyMapBuilder.build()));
            int gameModeId = class_310.method_1551().field_1761.method_2920().method_8379();
            this.asyncReplaySaver.submit(writer -> {
                writer.startAction(ActionCreateLocalPlayer.INSTANCE);
                class_9129 registryFriendlyByteBuf = writer.friendlyByteBuf();
                registryFriendlyByteBuf.method_10797(uuid);
                registryFriendlyByteBuf.method_52940(x);
                registryFriendlyByteBuf.method_52940(y);
                registryFriendlyByteBuf.method_52940(z);
                registryFriendlyByteBuf.method_52941(xRot);
                registryFriendlyByteBuf.method_52941(yRot);
                registryFriendlyByteBuf.method_52941(yHeadRot);
                registryFriendlyByteBuf.method_52955(deltaMovement);
                class_9135.field_49679.encode((Object)registryFriendlyByteBuf, (Object)newProfile);
                registryFriendlyByteBuf.method_10804(gameModeId);
                writer.finishAction(ActionCreateLocalPlayer.INSTANCE);
            });
        }
    }

    public void writeLevelEvent(int type, class_2338 blockPos, int data, boolean globalEvent) {
        if (!this.readyToWrite()) {
            return;
        }
        this.pendingPackets.add(new PacketWithPhase((class_2596<?>)new class_2673(type, blockPos, data, globalEvent), class_2539.field_20591));
    }

    public void writeSound(class_6880<class_3414> holder, class_3419 soundSource, double x, double y, double z, float volume, float pitch, long seed) {
        if (!this.readyToWrite()) {
            return;
        }
        this.pendingPackets.add(new PacketWithPhase((class_2596<?>)new class_2767(holder, soundSource, x, y, z, volume, pitch, seed), class_2539.field_20591));
    }

    public void writeEntitySound(class_6880<class_3414> holder, class_3419 soundSource, class_1297 entity, float volume, float pitch, long seed) {
        if (!this.readyToWrite()) {
            return;
        }
        this.pendingPackets.add(new PacketWithPhase((class_2596<?>)new class_2765(holder, soundSource, entity, volume, pitch, seed), class_2539.field_20591));
    }

    public void writePacketAsync(class_2596<?> packet, class_2539 phase) {
        class_2658 customPayloadPacket;
        if (!this.readyToWrite()) {
            this.skippedPacketDueToWaitingForWrite = true;
            return;
        }
        if (packet instanceof class_8042) {
            class_8042 bundlePacket = (class_8042)packet;
            for (class_2596 subPacket : bundlePacket.method_48324()) {
                this.writePacketAsync(subPacket, phase);
            }
            return;
        }
        if (packet instanceof class_7438) {
            class_7438 playerChatPacket = (class_7438)packet;
            try {
                class_2561 content = playerChatPacket.comp_1103() != null ? playerChatPacket.comp_1103() : class_2561.method_43470((String)playerChatPacket.comp_1102().comp_1090());
                class_2561 decorated = playerChatPacket.comp_943().method_44837(content);
                packet = new class_7439(decorated, false);
            }
            catch (Exception e) {
                return;
            }
        }
        if (packet instanceof class_2658 && (customPayloadPacket = (class_2658)packet).method_65080().comp_2231().method_12836().startsWith("fabric-screen-handler-api")) {
            return;
        }
        if (IgnoredPacketSet.isIgnored(packet)) {
            return;
        }
        class_746 localPlayer = class_310.method_1551().field_1724;
        if (localPlayer != null) {
            class_2744 entityEquipmentPacket;
            class_2739 entityDataPacket;
            int localPlayerId = localPlayer.method_5628();
            if (packet instanceof class_2739 && (entityDataPacket = (class_2739)packet).comp_1127() == localPlayerId) {
                return;
            }
            if (packet instanceof class_2744 && (entityEquipmentPacket = (class_2744)packet).method_11820() == localPlayerId) {
                return;
            }
        }
        this.pendingPackets.add(new PacketWithPhase((class_2596<?>)packet, phase));
    }

    /*
     * WARNING - void declaration
     */
    public void writeSnapshot(boolean asActualSnapshot) {
        int i;
        void var26_39;
        boolean isValidProperties;
        class_310 minecraft = class_310.method_1551();
        if (this.skippedPacketDueToWaitingForWrite) {
            this.skippedPacketDueToWaitingForWrite = false;
            while (minecraft.method_16075()) {
            }
        }
        if (asActualSnapshot) {
            this.asyncReplaySaver.submit(ReplayWriter::startSnapshot);
        }
        class_638 level = minecraft.field_1687;
        class_746 localPlayer = minecraft.field_1724;
        class_634 connection = minecraft.method_1562();
        class_636 gameMode = minecraft.field_1761;
        class_631 clientChunkCache = level.method_2935();
        AtomicReferenceArray chunks = clientChunkCache.field_16246.field_16251;
        ArrayList<class_2596<? super class_8732>> configurationPackets = new ArrayList<class_2596<? super class_8732>>();
        configurationPackets.add((class_2596<? super class_8732>)new class_7832(class_7701.field_40180.method_45392(level.method_45162())));
        class_6903 dynamicOps = localPlayer.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        class_7782.method_56598((DynamicOps)dynamicOps, (class_5455)localPlayer.method_56673(), Set.of(), (resourceKey, list) -> configurationPackets.add((class_2596<? super class_8732>)new class_8734(resourceKey, list)));
        HashMap serializedTags = new HashMap();
        class_7659.method_45139().method_45926().method_40311().forEach(entry -> {
            class_6864.class_5748 tags;
            if (entry.comp_351().method_10204() > 0 && !(tags = class_6864.method_40102((class_2378)entry.comp_351())).method_61315()) {
                serializedTags.put(entry.comp_350(), tags);
            }
        });
        localPlayer.method_56673().method_40311().forEach(entry -> {
            class_6864.class_5748 tags;
            if (serializedTags.containsKey(entry.comp_350())) {
                return;
            }
            if (class_7782.method_62704((class_5321)entry.comp_350()) && entry.comp_351().method_10204() > 0 && !(tags = class_6864.method_40102((class_2378)entry.comp_351())).method_61315()) {
                serializedTags.put(entry.comp_350(), tags);
            }
        });
        configurationPackets.add((class_2596<? super class_8732>)new class_2790(serializedTags));
        configurationPackets.add((class_2596<? super class_8732>)new class_9053(Optional.empty()));
        for (class_9044.class_9049 pack : minecraft.method_1516().field_47598.field_47634) {
            configurationPackets.add((class_2596<? super class_8732>)new class_2720(pack.field_47659, pack.field_47660.toString(), pack.field_47661 == null ? "" : pack.field_47661.toString(), true, Optional.empty()));
        }
        this.asyncReplaySaver.writeConfigurationPackets(this.configurationPacketCodec, configurationPackets);
        ArrayList<class_2596<? super class_2602>> gamePackets = new ArrayList<class_2596<? super class_2602>>();
        long hashedSeed = level.method_22385().field_20641;
        class_8589 commonPlayerSpawnInfo = new class_8589(level.method_40134(), level.method_27983(), hashedSeed, gameMode.method_2920(), gameMode.method_28107(), level.method_27982(), level.method_28104().field_24607, Optional.empty(), 0, level.method_8615());
        class_2678 loginPacket = new class_2678(localPlayer.method_5628(), level.method_28104().method_152(), connection.method_29356(), 1, minecraft.field_1690.method_38521(), level.method_39024(), localPlayer.method_7302(), localPlayer.method_22419(), localPlayer.method_53847(), commonPlayerSpawnInfo, false);
        gamePackets.add((class_2596<? super class_2602>)loginPacket);
        this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
        gamePackets.clear();
        this.writeCreateLocalPlayer();
        class_2703 infoUpdatePacket = new class_2703(EnumSet.of(class_2703.class_5893.field_29136, class_2703.class_5893.field_40700, class_2703.class_5893.field_29139), List.of());
        infoUpdatePacket.field_12369 = new ArrayList();
        HashSet<UUID> addedEntries = new HashSet<UUID>();
        HashSet<UUID> addedWithValidProperties = new HashSet<UUID>();
        for (class_640 info : connection.method_45732()) {
            boolean bl = isValidProperties = !info.method_2966().properties().isEmpty();
            if (!addedEntries.add(info.method_2966().id())) continue;
            infoUpdatePacket.field_12369.add(new class_2703.class_2705(info.method_2966().id(), info.method_2966(), true, info.method_2959(), info.method_2958(), info.method_2971(), info.method_65195(), info.method_62154(), null));
            if (!isValidProperties) continue;
            addedWithValidProperties.add(info.method_2966().id());
        }
        for (class_640 info : connection.method_2880()) {
            isValidProperties = !info.method_2966().properties().isEmpty();
            boolean add = false;
            if (addedEntries.add(info.method_2966().id())) {
                add = true;
            } else if (isValidProperties && !addedWithValidProperties.contains(info.method_2966().id())) {
                infoUpdatePacket.field_12369.removeIf(entry -> entry.comp_1106().equals(info.method_2966().id()));
                add = true;
            }
            if (!add) continue;
            infoUpdatePacket.field_12369.add(new class_2703.class_2705(info.method_2966().id(), info.method_2966(), false, info.method_2959(), info.method_2958(), info.method_2971(), info.method_65195(), info.method_62154(), null));
            if (!isValidProperties) continue;
            addedWithValidProperties.add(info.method_2966().id());
        }
        for (class_742 player : level.method_18456()) {
            class_640 info = player.method_3123();
            if (info != null) {
                boolean isValidProperties2 = !info.method_2966().properties().isEmpty();
                boolean add = false;
                if (addedEntries.add(info.method_2966().id())) {
                    add = true;
                } else if (isValidProperties2 && !addedWithValidProperties.contains(info.method_2966().id())) {
                    infoUpdatePacket.field_12369.removeIf(entry -> entry.comp_1106().equals(info.method_2966().id()));
                    add = true;
                }
                if (!add) continue;
                infoUpdatePacket.field_12369.add(new class_2703.class_2705(player.method_5667(), player.method_7334(), false, info.method_2959(), info.method_2958(), info.method_2971(), info.method_65195(), info.method_62154(), null));
                if (!isValidProperties2) continue;
                addedWithValidProperties.add(info.method_2966().id());
                continue;
            }
            if (!addedEntries.add(player.method_5667())) continue;
            infoUpdatePacket.field_12369.add(new class_2703.class_2705(player.method_5667(), player.method_7334(), false, 0, class_1934.field_28045, player.method_5476(), true, 0, null));
        }
        gamePackets.add((class_2596<? super class_2602>)infoUpdatePacket);
        class_355 playerTabOverlay = minecraft.field_1705.method_1750();
        gamePackets.add((class_2596<? super class_2602>)new class_2772((class_2561)(playerTabOverlay.field_2153 != null ? playerTabOverlay.field_2153 : class_2561.method_43473()), (class_2561)(playerTabOverlay.field_2154 != null ? playerTabOverlay.field_2154 : class_2561.method_43473())));
        class_337 bossOverlay = minecraft.field_1705.method_1740();
        for (class_345 event : bossOverlay.field_2060.values()) {
            gamePackets.add((class_2596<? super class_2602>)class_2629.method_34089((class_1259)event));
        }
        class_269 scoreboard = localPlayer.field_3944.method_55823();
        for (class_268 playerTeam : scoreboard.method_1159()) {
            gamePackets.add((class_2596<? super class_2602>)class_5900.method_34172((class_268)playerTeam, (boolean)true));
        }
        HashSet<class_266> handledObjectives = new HashSet<class_266>();
        class_8646[] playerTeam = class_8646.values();
        int n = playerTeam.length;
        boolean bl = false;
        while (var26_39 < n) {
            class_8646 displaySlot = playerTeam[var26_39];
            class_266 objective = scoreboard.method_1189(displaySlot);
            if (objective != null && handledObjectives.add(objective)) {
                gamePackets.add((class_2596<? super class_2602>)new class_2751(objective, 0));
                for (class_8646 displaySlot2 : class_8646.values()) {
                    if (scoreboard.method_1189(displaySlot2) != objective) continue;
                    gamePackets.add((class_2596<? super class_2602>)new class_2736(displaySlot2, objective));
                }
                for (class_9011 playerScoreEntry : scoreboard.method_1184(objective)) {
                    gamePackets.add((class_2596<? super class_2602>)new class_2757(playerScoreEntry.comp_2127(), objective.method_1113(), playerScoreEntry.comp_2128(), Optional.ofNullable(playerScoreEntry.comp_2129()), Optional.ofNullable(playerScoreEntry.comp_2130())));
                }
            }
            ++var26_39;
        }
        class_2784 worldBorder = level.method_8621();
        gamePackets.add((class_2596<? super class_2602>)new class_5889(worldBorder));
        gamePackets.add((class_2596<? super class_2602>)new class_2761(level.method_8510(), level.method_8532(), level.field_54500));
        gamePackets.add((class_2596<? super class_2602>)new class_2759(level.method_74854()));
        if (level.method_8419()) {
            gamePackets.add((class_2596<? super class_2602>)new class_2668(class_2668.field_25646, 0.0f));
        } else {
            gamePackets.add((class_2596<? super class_2602>)new class_2668(class_2668.field_25647, 0.0f));
        }
        gamePackets.add((class_2596<? super class_2602>)new class_2668(class_2668.field_25652, level.method_8430(1.0f)));
        gamePackets.add((class_2596<? super class_2602>)new class_2668(class_2668.field_25653, level.method_8478(1.0f)));
        try {
            Runnable runnable;
            while ((runnable = (Runnable)level.field_34804.poll()) != null) {
                runnable.run();
            }
        }
        catch (Exception e) {
            Flashback.LOGGER.error("Error while running light tasks", (Throwable)e);
        }
        for (int i2 = 0; i2 < 256; ++i2) {
            try {
                if (level.method_22336().method_15516() != 0) continue;
            }
            catch (Exception exception) {
                Flashback.LOGGER.error("Error while running light updates", (Throwable)exception);
            }
            break;
        }
        if (Runtime.getRuntime().availableProcessors() <= 1) {
            void var26_42;
            ArrayList<class_2672> levelChunkPackets = new ArrayList<class_2672>();
            boolean bl2 = false;
            while (var26_42 < chunks.length()) {
                class_2818 chunk = (class_2818)chunks.get((int)var26_42);
                if (chunk != null) {
                    levelChunkPackets.add(new class_2672(chunk, level.method_22336(), null, null));
                }
                ++var26_42;
            }
            int n2 = localPlayer.method_31477() >> 4;
            int centerZ = localPlayer.method_31479() >> 4;
            levelChunkPackets.sort(Comparator.comparingInt(task -> {
                int dx = task.method_11523() - centerX;
                int dz = task.method_11524() - centerZ;
                return dx * dx + dz * dz;
            }));
            gamePackets.addAll(levelChunkPackets);
        } else {
            try (ForkJoinPool pool = new ForkJoinPool();){
                final class PositionedTask {
                    private final class_1923 pos;
                    private final ForkJoinTask<class_2672> task;
                    private class_6606 lightData = null;

                    PositionedTask(Recorder this$0, class_1923 pos, ForkJoinTask<class_2672> task) {
                        this.pos = pos;
                        this.task = task;
                    }
                }
                ArrayList<PositionedTask> arrayList = new ArrayList<PositionedTask>();
                for (i = 0; i < chunks.length(); ++i) {
                    class_2818 chunk = (class_2818)chunks.get(i);
                    if (chunk == null) continue;
                    Iterator task2 = pool.submit(() -> new class_2672(chunk, level.method_22336(), new BitSet(), new BitSet()));
                    arrayList.add(new PositionedTask(this, chunk.method_12004(), (ForkJoinTask<class_2672>)((Object)task2)));
                }
                int centerX = localPlayer.method_31477() >> 4;
                int centerZ = localPlayer.method_31479() >> 4;
                arrayList.sort(Comparator.comparingInt(task -> {
                    int dx = task.pos.field_9181 - centerX;
                    int dz = task.pos.field_9180 - centerZ;
                    return dx * dx + dz * dz;
                }));
                for (PositionedTask positionedTask : arrayList) {
                    positionedTask.lightData = new class_6606(positionedTask.pos, level.method_22336(), null, null);
                }
                for (PositionedTask positionedTask : arrayList) {
                    class_2672 levelChunkWithLightPacket = positionedTask.task.join();
                    levelChunkWithLightPacket.field_34871 = positionedTask.lightData;
                    gamePackets.add((class_2596<? super class_2602>)levelChunkWithLightPacket);
                }
            }
        }
        if (Flashback.getConfig().recording.recordHotbar) {
            int n3;
            this.lastExperienceProgress = localPlayer.field_7510;
            this.lastTotalExperience = localPlayer.field_7495;
            this.lastExperienceLevel = localPlayer.field_7520;
            gamePackets.add((class_2596<? super class_2602>)new class_2748(localPlayer.field_7510, localPlayer.field_7495, localPlayer.field_7520));
            class_1702 foodData = localPlayer.method_7344();
            this.lastFoodLevel = foodData.method_7586();
            this.lastSaturationLevel = foodData.method_7589();
            gamePackets.add((class_2596<? super class_2602>)new class_2749(localPlayer.method_6032(), foodData.method_7586(), foodData.method_7589()));
            this.lastSelectedSlot = n3 = localPlayer.method_31548().method_67532();
            gamePackets.add((class_2596<? super class_2602>)new class_2735(n3));
            for (i = 0; i < 9; ++i) {
                class_1799 hotbarItem = localPlayer.method_31548().method_5438(i);
                this.lastHotbarItems[i] = hotbarItem.method_7972();
                gamePackets.add((class_2596<? super class_2602>)new class_2653(0, 0, i, hotbarItem.method_7972()));
            }
        }
        for (class_1297 class_12972 : level.method_18112()) {
            class_9817 leashable;
            List nonDefaultEntityData;
            if (PacketHelper.shouldIgnoreEntity(class_12972)) continue;
            if (!(class_12972 instanceof class_746)) {
                gamePackets.add(PacketHelper.createAddEntity(class_12972));
            }
            if ((nonDefaultEntityData = class_12972.method_5841().method_46357()) != null && !nonDefaultEntityData.isEmpty()) {
                gamePackets.add((class_2596<? super class_2602>)new class_2739(class_12972.method_5628(), nonDefaultEntityData));
            }
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                Collection syncableAttributes = livingEntity.method_6127().method_26851();
                if (!syncableAttributes.isEmpty()) {
                    gamePackets.add((class_2596<? super class_2602>)new class_2781(class_12972.method_5628(), syncableAttributes));
                }
                ArrayList<Pair> changedSlots = new ArrayList<Pair>();
                for (class_1304 equipmentSlot : class_1304.values()) {
                    class_1799 itemStack = livingEntity.method_6118(equipmentSlot);
                    if (itemStack.method_7960()) continue;
                    changedSlots.add(Pair.of((Object)equipmentSlot, (Object)itemStack.method_7972()));
                }
                if (!changedSlots.isEmpty()) {
                    gamePackets.add((class_2596<? super class_2602>)new class_2744(class_12972.method_5628(), changedSlots));
                }
            }
            if (class_12972.method_5782()) {
                gamePackets.add((class_2596<? super class_2602>)new class_2752(class_12972));
            }
            if (class_12972.method_5765()) {
                gamePackets.add((class_2596<? super class_2602>)new class_2752(class_12972.method_5854()));
            }
            if (!(class_12972 instanceof class_9817) || !(leashable = (class_9817)class_12972).method_60953()) continue;
            gamePackets.add((class_2596<? super class_2602>)new class_2740(class_12972, leashable.method_60952()));
        }
        for (Map.Entry entry2 : level.field_17675.entrySet()) {
            class_22 data = (class_22)entry2.getValue();
            int offsetX = 0;
            int offsetY = 0;
            int sizeX = 128;
            int sizeY = 128;
            if (data.field_122.length != sizeX * sizeY) {
                Flashback.LOGGER.error("Unable to save snapshot of map data, expected colour array to be size {}, got {} instead", (Object)(sizeX * sizeY), (Object)data.field_122.length);
                continue;
            }
            byte[] colorsCopy = new byte[sizeX * sizeY];
            System.arraycopy(data.field_122, 0, colorsCopy, 0, sizeX * sizeY);
            class_22.class_5637 patch = new class_22.class_5637(offsetX, offsetY, sizeX, sizeY, colorsCopy);
            ArrayList<class_20> decorations = new ArrayList<class_20>();
            for (class_20 decoration : data.method_32373()) {
                decorations.add(decoration);
            }
            class_2683 packet = new class_2683((class_9209)entry2.getKey(), data.field_119, data.field_17403, decorations, patch);
            gamePackets.add((class_2596<? super class_2602>)packet);
        }
        this.writeCustomSnapshot(gamePackets::add);
        this.asyncReplaySaver.writeGamePackets(this.gamePacketCodec, gamePackets);
        if (asActualSnapshot) {
            this.asyncReplaySaver.submit(ReplayWriter::endSnapshot);
        }
    }

    public void writeCustomSnapshot(Consumer<class_2596<? super class_2602>> consumer) {
    }

    private record Position(double x, double y, double z, float yaw, float pitch, float headYRot, boolean onGround) {
        public Position {
            yaw = class_3532.method_15393((float)yaw);
            pitch = class_3532.method_15393((float)pitch);
            headYRot = class_3532.method_15393((float)headYRot);
        }
    }

    private record PacketWithPhase(class_2596<?> packet, class_2539 phase) {
    }
}

