/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback;

import com.google.common.collect.Sets;
import com.moulberry.flashback.FlashbackTextComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class RegistryMetaHelper {
    private static final List<String> REGISTRY_ORDER = List.of("minecraft:block", "minecraft:item", "minecraft:entity_type", "minecraft:fluid", "minecraft:particle_type", "minecraft:block_entity_type", "minecraft:sound_event");

    public static LinkedHashMap<String, LinkedHashSet<String>> calculateNamespacesForRegistries() {
        LinkedHashMap<String, LinkedHashSet<String>> namespacesForRegistries = new LinkedHashMap<String, LinkedHashSet<String>>();
        for (class_2960 registryName : class_7923.field_41167.method_10235()) {
            class_2378 registry = (class_2378)class_7923.field_41167.method_10223(registryName);
            if (registry == null) continue;
            LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
            for (Map.Entry entry : registry.method_29722()) {
                class_2960 location = ((class_5321)entry.getKey()).method_29177();
                String namespace = location.method_12836();
                if (namespace.equals("minecraft") || namespace.equals("brigadier")) continue;
                namespaces.add(namespace);
            }
            if (namespaces.isEmpty()) continue;
            namespacesForRegistries.put(registryName.toString(), namespaces);
        }
        return namespacesForRegistries;
    }

    public static class_2561 createMismatchWarning(LinkedHashMap<String, LinkedHashSet<String>> current, LinkedHashMap<String, LinkedHashSet<String>> replay) {
        class_5250 mutableComponent = class_2561.method_43473();
        mutableComponent.method_10852((class_2561)class_2561.method_43471((String)"flashback.registry.mismatch1").method_27692(class_124.field_1061)).method_10852(FlashbackTextComponents.NEWLINE);
        mutableComponent.method_10852((class_2561)class_2561.method_43471((String)"flashback.registry.mismatch2").method_27692(class_124.field_1061)).method_10852(FlashbackTextComponents.NEWLINE);
        mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"flashback.registry.mismatch3", (Object[])new Object[]{class_2561.method_43471((String)"selectWorld.backupJoinSkipButton")}).method_27692(class_124.field_1061)).method_10852(FlashbackTextComponents.NEWLINE);
        mutableComponent.method_10852(FlashbackTextComponents.NEWLINE);
        record MismatchEntry(String registryName, LinkedHashSet<String> mismatchedElements) {
        }
        ArrayList<MismatchEntry> mismatches = new ArrayList<MismatchEntry>();
        for (String registryName : current.keySet()) {
            LinkedHashSet<String> replayEntries;
            if (!replay.containsKey(registryName)) {
                mismatches.add(new MismatchEntry(registryName, current.get(registryName)));
                continue;
            }
            LinkedHashSet<String> currentEntries = current.get(registryName);
            LinkedHashSet<String> mismatchesForRegistry = new LinkedHashSet<String>((Collection<String>)Sets.symmetricDifference(currentEntries, replayEntries = replay.get(registryName)));
            if (mismatchesForRegistry.isEmpty()) continue;
            mismatches.add(new MismatchEntry(registryName, mismatchesForRegistry));
        }
        for (String registryName : replay.keySet()) {
            if (current.containsKey(registryName)) continue;
            mismatches.add(new MismatchEntry(registryName, replay.get(registryName)));
        }
        mismatches.sort(Comparator.comparingInt(entry -> {
            int index = REGISTRY_ORDER.indexOf(entry.registryName);
            if (index < 0) {
                index = REGISTRY_ORDER.size();
            }
            return index;
        }));
        int maxRows = 15;
        int usedRows = 4;
        class_327 font = class_310.method_1551().field_1772;
        class_5225 splitter = font.method_27527();
        Iterator iterator = mismatches.iterator();
        while (15 - usedRows >= 3 && iterator.hasNext()) {
            MismatchEntry entry2 = (MismatchEntry)iterator.next();
            mutableComponent.method_10852((class_2561)class_2561.method_43470((String)("Registry: " + entry2.registryName + "\n")).method_27692(class_124.field_1073));
            ++usedRows;
            StringBuilder missingElements = new StringBuilder();
            boolean first = true;
            for (String element : entry2.mismatchedElements) {
                if (first) {
                    first = false;
                } else {
                    missingElements.append(", ");
                }
                missingElements.append(element);
            }
            final ArrayList lines = new ArrayList();
            final String missingElementsStr = missingElements.toString();
            splitter.method_27485(missingElementsStr, 300, class_2583.field_24360, false, new class_5225.class_5229(){

                public void accept(class_2583 style, int from, int to) {
                    lines.add(missingElementsStr.substring(from, to));
                }
            });
            for (String line : lines) {
                if (15 - usedRows >= 2) {
                    mutableComponent.method_10852((class_2561)class_2561.method_43470((String)(line + "\n")).method_27692(class_124.field_1054));
                    ++usedRows;
                    continue;
                }
                mutableComponent.method_10852((class_2561)class_2561.method_43470((String)"...and more elements\n").method_27692(class_124.field_1054));
                ++usedRows;
            }
        }
        if (iterator.hasNext()) {
            int remaining = 0;
            while (iterator.hasNext()) {
                ++remaining;
                iterator.next();
            }
            mutableComponent.method_27693("...and " + remaining + " more registries");
            ++usedRows;
        }
        return mutableComponent;
    }
}

