/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.ReplayVisuals;
import com.moulberry.flashback.visuals.ShaderManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4063;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_824;
import net.minecraft.class_846;
import net.minecraft.class_8679;
import net.minecraft.class_8921;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_761.class}, priority=1100)
public abstract class MixinLevelRenderer {
    @Shadow
    @Final
    public ObjectArrayList<class_846.class_851> field_45616;
    @Shadow
    @Nullable
    private class_846 field_45614;
    @Shadow
    @Final
    public class_8679 field_45615;
    @Shadow
    private int field_4073;
    @Unique
    private class_276 roundAlphaBuffer = null;
    @Unique
    private class_1959.class_1963 forcePrecipitation = null;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            this.field_4073 = replayServer.getReplayTick();
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/TickRateManager;runsNormally()Z")})
    public boolean tick_runsNormally(class_8921 instance, Operation<Boolean> original) {
        if (Flashback.isInReplay()) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    public void renderLevel(class_9779 deltaTracker, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f matrix4f, Matrix4f projection, CallbackInfo ci) {
        ReplayUI.lastProjectionMatrix = projection;
        ReplayUI.lastViewQuaternion = camera.method_23767();
    }

    @Inject(method={"close"}, at={@At(value="HEAD")})
    public void close(CallbackInfo ci) {
        if (this.roundAlphaBuffer != null) {
            this.roundAlphaBuffer.method_1238();
        }
    }

    @Inject(method={"renderSectionLayer"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void renderSectionLayer(class_1921 renderType, double d, double e, double f, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderBlocks) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", ordinal=2, shift=At.Shift.AFTER)}, require=0)
    public void renderLevel_renderCutoutLayer(class_9779 deltaTracker, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        if (Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
            class_276 main = class_310.method_1551().field_1689;
            RenderSystem.assertOnRenderThread();
            if (this.roundAlphaBuffer == null) {
                this.roundAlphaBuffer = new class_6367(main.field_1482, main.field_1481, false, class_310.field_1703);
            } else if (this.roundAlphaBuffer.field_1482 != main.field_1482 || this.roundAlphaBuffer.field_1481 != main.field_1481) {
                this.roundAlphaBuffer.method_1238();
                this.roundAlphaBuffer = new class_6367(main.field_1482, main.field_1481, false, class_310.field_1703);
            }
            this.roundAlphaBuffer.method_1235(true);
            GlStateManager._disableDepthTest();
            GlStateManager._depthMask((boolean)false);
            GlStateManager._viewport((int)0, (int)0, (int)main.field_1480, (int)main.field_1477);
            GlStateManager._disableBlend();
            class_5944 shaderInstance = Objects.requireNonNull(ShaderManager.blitScreenRoundAlpha, "Blit shader not loaded");
            shaderInstance.method_34583("DiffuseSampler", (Object)main.field_1475);
            shaderInstance.method_34586();
            class_287 bufferBuilder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_29336);
            bufferBuilder.method_22912(0.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 0.0f, 0.0f);
            bufferBuilder.method_22912(1.0f, 1.0f, 0.0f);
            bufferBuilder.method_22912(0.0f, 1.0f, 0.0f);
            class_286.method_43437((class_9801)bufferBuilder.method_60800());
            shaderInstance.method_34585();
            main.method_1235(true);
            this.roundAlphaBuffer.method_1237(main.field_1482, main.field_1481);
            GlStateManager._enableBlend();
            GlStateManager._depthMask((boolean)true);
            GlStateManager._enableDepthTest();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/FogRenderer;levelFogColor()V", shift=At.Shift.AFTER)}, require=0)
    public void renderLevel_levelFogColor(class_9779 deltaTracker, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f matrix4f, Matrix4f matrix4f2, CallbackInfo ci) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null) {
            ReplayVisuals visuals = editorState.replayVisuals;
            if (visuals.overrideFogColour) {
                float[] fogColour = visuals.fogColour;
                class_758.field_4034 = fogColour[0];
                class_758.field_4033 = fogColour[1];
                class_758.field_4032 = fogColour[2];
                RenderSystem.setShaderFogColor((float)fogColour[0], (float)fogColour[1], (float)fogColour[2]);
                if (visuals.renderSky) {
                    RenderSystem.clearColor((float)fogColour[0], (float)fogColour[1], (float)fogColour[2], (float)1.0f);
                }
            }
            if (!visuals.renderSky) {
                if (Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
                    RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                } else {
                    float[] skyColour = visuals.skyColour;
                    RenderSystem.clearColor((float)skyColour[0], (float)skyColour[1], (float)skyColour[2], (float)1.0f);
                }
            }
        }
    }

    @WrapWithCondition(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;render(Lnet/minecraft/world/level/block/entity/BlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V")}, require=0)
    public boolean renderLevel_renderBlockEntity(class_824 instance, class_2586 blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource) {
        EditorState editorState = EditorStateManager.getCurrent();
        return editorState == null || editorState.replayVisuals.renderBlocks;
    }

    @WrapWithCondition(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V")}, require=0)
    public boolean renderLevel_renderEntity(class_761 instance, class_1297 entity, double d, double e, double f, float g, class_4587 poseStack, class_4597 multiBufferSource) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (entity instanceof class_1657) {
            return editorState == null || editorState.replayVisuals.renderPlayers;
        }
        return editorState == null || editorState.replayVisuals.renderEntities;
    }

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")})
    public void renderSnowAndRain(class_765 lightTexture, float f, double d, double e, double g, CallbackInfo ci) {
        this.forcePrecipitation = null;
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null) {
            switch (editorState.replayVisuals.overrideWeatherMode) {
                case CLEAR: 
                case OVERCAST: {
                    this.forcePrecipitation = class_1959.class_1963.field_9384;
                    break;
                }
                case RAINING: 
                case THUNDERING: {
                    this.forcePrecipitation = class_1959.class_1963.field_9382;
                    break;
                }
                case SNOWING: {
                    this.forcePrecipitation = class_1959.class_1963.field_9383;
                }
            }
        }
    }

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;hasPrecipitation()Z")})
    public boolean renderSnowAndRain_hasPrecipitation(class_1959 instance, Operation<Boolean> original) {
        if (this.forcePrecipitation != null) {
            return this.forcePrecipitation != class_1959.class_1963.field_9384;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")})
    public class_1959.class_1963 renderSnowAndRain_getPrecipitationAt(class_1959 instance, class_2338 blockPos, Operation<class_1959.class_1963> original) {
        if (this.forcePrecipitation != null) {
            return this.forcePrecipitation;
        }
        return (class_1959.class_1963)original.call(new Object[]{instance, blockPos});
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;getCloudsType()Lnet/minecraft/client/CloudStatus;")}, require=0)
    public class_4063 renderLevel_getCloudsType(class_315 instance, Operation<class_4063> original) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderSky) {
            return class_4063.field_18162;
        }
        return (class_4063)original.call(new Object[]{instance});
    }

    @WrapWithCondition(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleEngine;render(Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;F)V")}, require=0)
    public boolean renderLevel_renderParticles(class_702 instance, class_765 lightTexture, class_4184 camera, float f) {
        EditorState editorState = EditorStateManager.getCurrent();
        return editorState == null || editorState.replayVisuals.renderParticles;
    }

    @Inject(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    public void addParticleInternal(class_2394 particleOptions, boolean bl, boolean bl2, double d, double e, double f, double g, double h, double i, CallbackInfoReturnable<class_703> cir) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null && !editorState.replayVisuals.renderParticles) {
            cir.setReturnValue(null);
        }
    }

    @WrapWithCondition(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V")}, require=0)
    public boolean renderLevel_renderSky(class_761 instance, Matrix4f matrix4f, Matrix4f matrix4f2, float f, class_4184 camera, boolean bl, Runnable runnable) {
        EditorState editorState = EditorStateManager.getCurrent();
        return editorState == null || editorState.replayVisuals.renderSky;
    }
}

