/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.screen;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.FlashbackTextComponents;
import com.moulberry.flashback.exporting.AsyncFileDialogs;
import com.moulberry.flashback.record.ReplayExporter;
import com.moulberry.flashback.screen.BottomTextWidget;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4239;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import org.apache.commons.io.FileUtils;

public class SaveReplayScreen
extends class_437 {
    private Path recordFolder;
    private String replayName;
    private Path savePath = null;
    private boolean generateFileFromReplayName = true;
    private class_4185 filePathButton;
    private class_437 previousScreen;

    public SaveReplayScreen(class_437 previousScreen, Path recordFolder, String replayName) {
        super(FlashbackTextComponents.SAVE_REPLAY);
        this.recordFolder = recordFolder;
        this.setReplayName(replayName);
        if (this.savePath == null) {
            this.savePath = Flashback.getReplayFolder().resolve(String.valueOf(UUID.randomUUID()) + ".zip");
        }
        if (!(previousScreen instanceof SaveReplayScreen)) {
            this.previousScreen = previousScreen;
        }
    }

    protected void method_56131() {
    }

    protected void method_25426() {
        super.method_25426();
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46458().method_46466(4, 4, 4, 0);
        class_7845.class_7939 rowHelper = gridLayout.method_47610(2);
        rowHelper.method_47613((class_8021)new class_7842(204, 20, FlashbackTextComponents.SAVE_REPLAY, this.field_22793), 2);
        rowHelper.method_47613((class_8021)new BottomTextWidget(204, 10, FlashbackTextComponents.REPLAY_NAME, this.field_22793).alignLeft(), 2);
        class_342 replayNameEditBox = new class_342(this.field_22793, 0, 0, 204, 20, (class_2561)class_2561.method_43470((String)this.replayName));
        replayNameEditBox.method_1880(128);
        replayNameEditBox.method_1852(this.replayName);
        replayNameEditBox.method_1863(this::setReplayName);
        rowHelper.method_47613((class_8021)replayNameEditBox, 2);
        rowHelper.method_47613((class_8021)new BottomTextWidget(204, 10, FlashbackTextComponents.FILENAME, this.field_22793).alignLeft(), 2);
        this.filePathButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.savePath.getFileName().toString()), button -> {
            CompletableFuture<String> future = AsyncFileDialogs.saveFileDialog(this.savePath.getParent().toString(), this.savePath.getFileName().toString(), "Replay Archive", "zip");
            future.thenAccept(pathStr -> {
                if (pathStr != null) {
                    this.savePath = Path.of(pathStr, new String[0]);
                    this.generateFileFromReplayName = false;
                }
            });
        }).method_46432(204).method_46431();
        rowHelper.method_47613((class_8021)this.filePathButton, 2);
        rowHelper.method_47613((class_8021)new BottomTextWidget(204, 10, class_5244.field_39003, this.field_22793), 2);
        rowHelper.method_47613((class_8021)class_4185.method_46430((class_2561)FlashbackTextComponents.SAVE_REPLAY, button -> {
            this.saveReplay();
            class_310.method_1551().method_1507(this.previousScreen);
        }).method_46432(98).method_46431(), 1);
        rowHelper.method_47613((class_8021)class_4185.method_46430((class_2561)FlashbackTextComponents.DELETE_REPLAY, button -> class_310.method_1551().method_1507((class_437)new class_410(value -> {
            if (value) {
                this.deleteReplay();
                class_310.method_1551().method_1507(this.previousScreen);
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }, FlashbackTextComponents.CONFIRM_DELETE_REPLAY, FlashbackTextComponents.CONFIRM_DELETE_REPLAY_MESSAGE))).method_46432(98).method_46431(), 1);
        gridLayout.method_48222();
        class_7843.method_46443((class_8021)gridLayout, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (float)0.5f, (float)0.5f);
        gridLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48265((class_364)replayNameEditBox);
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if (!Files.exists(this.recordFolder, new LinkOption[0])) {
            class_310.method_1551().method_1507((class_437)new class_403(() -> class_310.method_1551().method_1507(this.previousScreen), FlashbackTextComponents.ERROR_SAVING_REPLAY, FlashbackTextComponents.RECORDING_FOLDER_MISSING));
        }
    }

    private void saveReplay() {
        if (!Files.exists(this.recordFolder, new LinkOption[0])) {
            class_310.method_1551().method_1507((class_437)new class_403(() -> class_310.method_1551().method_1507(this.previousScreen), FlashbackTextComponents.ERROR_SAVING_REPLAY, FlashbackTextComponents.RECORDING_FOLDER_MISSING));
            return;
        }
        ReplayExporter.export(this.recordFolder, this.savePath, this.replayName);
        Flashback.removePendingReplaySave(this.recordFolder);
    }

    private void deleteReplay() {
        try {
            FileUtils.deleteDirectory((File)this.recordFolder.toFile());
        }
        catch (Exception e) {
            Flashback.LOGGER.error("Exception deleting record folder", (Throwable)e);
        }
        Flashback.removePendingReplaySave(this.recordFolder);
    }

    private void setReplayName(String replayName) {
        this.replayName = replayName;
        if (!this.replayName.isEmpty() && (this.savePath == null || this.generateFileFromReplayName)) {
            Object filename;
            Path replayDir = Flashback.getReplayFolder();
            if (!Files.exists(replayDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(replayDir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                filename = class_4239.method_19773((Path)replayDir, (String)this.replayName.replace(' ', '_'), (String)".zip");
            }
            catch (IOException e) {
                Flashback.LOGGER.error("Error while trying to determine filename", (Throwable)e);
                filename = String.valueOf(UUID.randomUUID()) + ".zip";
            }
            this.savePath = replayDir.resolve((String)filename);
            if (this.filePathButton != null) {
                this.filePathButton.method_25355((class_2561)class_2561.method_43470((String)this.savePath.getFileName().toString()));
            }
        }
    }
}

