/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.visuals;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10799;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_9801;

public class FlashbackDrawBuffer
implements AutoCloseable {
    BufferUsage bufferUsage;
    GpuBuffer vertexBuffer;
    int indexCount;
    VertexFormat vertexFormat;
    VertexFormat.class_5596 vertexFormatMode;

    public FlashbackDrawBuffer(BufferUsage bufferUsage) {
        this.bufferUsage = bufferUsage;
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
    }

    public void upload(class_9801 meshData) {
        try (class_9801 class_98012 = meshData;){
            class_9801.class_4574 drawState = meshData.method_60822();
            this.uploadVertexBuffer(meshData.method_60818());
            this.vertexFormat = drawState.comp_749();
            this.vertexFormatMode = drawState.comp_752();
            this.indexCount = drawState.comp_751();
        }
    }

    private void uploadVertexBuffer(ByteBuffer byteBuffer) {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        this.vertexBuffer = RenderSystem.getDevice().createBuffer(null, BufferType.VERTICES, this.bufferUsage, byteBuffer);
    }

    public void draw() {
        class_276 renderTarget = class_310.method_1551().method_1522();
        RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)this.vertexFormatMode);
        GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(this.indexCount);
        VertexFormat.class_5595 indexType = autoStorageIndexBuffer.method_31924();
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        try (RenderPass renderPass = commandEncoder.createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.field_1478 ? renderTarget.method_30278() : null, OptionalDouble.empty());){
            renderPass.setPipeline(class_10799.field_56833);
            renderPass.setVertexBuffer(0, this.vertexBuffer);
            if (RenderSystem.SCISSOR_STATE.isEnabled()) {
                renderPass.enableScissor(RenderSystem.SCISSOR_STATE);
            }
            for (int i = 0; i < 12; ++i) {
                GpuTexture gpuTexture = RenderSystem.getShaderTexture((int)i);
                if (gpuTexture == null) continue;
                renderPass.bindSampler("Sampler" + i, gpuTexture);
            }
            renderPass.setIndexBuffer(indexBuffer, indexType);
            renderPass.drawIndexed(0, this.indexCount);
        }
    }
}

