/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Lifecycle;
import com.moulberry.flashback.FlashbackGson;
import com.moulberry.flashback.FlashbackSystemToasts;
import com.moulberry.flashback.FlashbackTextComponents;
import com.moulberry.flashback.TempFolderProvider;
import com.moulberry.flashback.action.ActionAccuratePlayerPosition;
import com.moulberry.flashback.action.ActionConfigurationPacket;
import com.moulberry.flashback.action.ActionCreateLocalPlayer;
import com.moulberry.flashback.action.ActionGamePacket;
import com.moulberry.flashback.action.ActionLevelChunkCached;
import com.moulberry.flashback.action.ActionMoveEntities;
import com.moulberry.flashback.action.ActionNextTick;
import com.moulberry.flashback.action.ActionRegistry;
import com.moulberry.flashback.combo_options.MarkerColour;
import com.moulberry.flashback.command.BetterColorArgument;
import com.moulberry.flashback.compat.DistantHorizonsSupport;
import com.moulberry.flashback.compat.simple_voice_chat.SimpleVoiceChatPlayback;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.exporting.AsyncFileDialogs;
import com.moulberry.flashback.exporting.ExportJob;
import com.moulberry.flashback.exporting.taskbar.TaskbarManager;
import com.moulberry.flashback.ext.MinecraftExt;
import com.moulberry.flashback.keyframe.KeyframeRegistry;
import com.moulberry.flashback.keyframe.types.AudioKeyframeType;
import com.moulberry.flashback.keyframe.types.BlockOverrideKeyframeType;
import com.moulberry.flashback.keyframe.types.CameraKeyframeType;
import com.moulberry.flashback.keyframe.types.CameraOrbitKeyframeType;
import com.moulberry.flashback.keyframe.types.CameraShakeKeyframeType;
import com.moulberry.flashback.keyframe.types.FOVKeyframeType;
import com.moulberry.flashback.keyframe.types.FreezeKeyframeType;
import com.moulberry.flashback.keyframe.types.SpeedKeyframeType;
import com.moulberry.flashback.keyframe.types.TimeOfDayKeyframeType;
import com.moulberry.flashback.keyframe.types.TimelapseKeyframeType;
import com.moulberry.flashback.keyframe.types.TrackEntityKeyframeType;
import com.moulberry.flashback.packet.FinishedServerTick;
import com.moulberry.flashback.packet.FlashbackAccurateEntityPosition;
import com.moulberry.flashback.packet.FlashbackClearEntities;
import com.moulberry.flashback.packet.FlashbackClearParticles;
import com.moulberry.flashback.packet.FlashbackForceClientTick;
import com.moulberry.flashback.packet.FlashbackInstantlyLerp;
import com.moulberry.flashback.packet.FlashbackRemoteExperience;
import com.moulberry.flashback.packet.FlashbackRemoteFoodData;
import com.moulberry.flashback.packet.FlashbackRemoteSelectHotbarSlot;
import com.moulberry.flashback.packet.FlashbackRemoteSetSlot;
import com.moulberry.flashback.packet.FlashbackSetBorderLerpStartTime;
import com.moulberry.flashback.packet.FlashbackVoiceChatSound;
import com.moulberry.flashback.playback.EmptyLevelSource;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.record.Recorder;
import com.moulberry.flashback.record.ReplayExporter;
import com.moulberry.flashback.record.ReplayMarker;
import com.moulberry.flashback.screen.RecoverRecordingsScreen;
import com.moulberry.flashback.screen.SaveReplayScreen;
import com.moulberry.flashback.screen.UnsupportedLoaderScreen;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.AccurateEntityPositionHandler;
import com.moulberry.flashback.visuals.ShaderManager;
import com.moulberry.lattice.Lattice;
import com.moulberry.lattice.element.LatticeElements;
import com.seibel.distanthorizons.api.DhApi;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1940;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_31;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_403;
import net.minecraft.class_4239;
import net.minecraft.class_4325;
import net.minecraft.class_433;
import net.minecraft.class_434;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_5250;
import net.minecraft.class_5285;
import net.minecraft.class_5359;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_6904;
import net.minecraft.class_7134;
import net.minecraft.class_7237;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7712;
import net.minecraft.class_7723;
import net.minecraft.class_7924;
import net.minecraft.class_9139;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flashback
implements ModInitializer,
ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"flashback");
    public static final int MAGIC = -679417724;
    public static volatile Recorder RECORDER = null;
    public static ExportJob EXPORT_JOB = null;
    private static FlashbackConfigV1 config;
    public static LatticeElements configElements;
    private static Path configDirectory;
    private static int delayedStartRecording;
    private static boolean delayedOpenConfig;
    private static volatile boolean isInReplay;
    public static boolean supportsDistantHorizons;
    private static final List<Path> pendingReplaySave;
    private static final List<Path> pendingReplayRecovery;
    private static List<String> pendingUnsupportedModsForRecording;
    private static boolean isOpeningReplay;
    public static long worldBorderLerpStartTime;
    public static final class_304 createMarker1KeyBind;
    public static final class_304 createMarker2KeyBind;
    public static final class_304 createMarker3KeyBind;
    public static final class_304 createMarker4KeyBind;

    public static class_2960 createResourceLocation(String value) {
        return class_2960.method_60655((String)"flashback", (String)value);
    }

    public static Path getDataDirectory() {
        return FabricLoader.getInstance().getGameDir().resolve("flashback");
    }

    public static Path getReplayFolder() {
        return Flashback.getDataDirectory().resolve("replays");
    }

    public static Path getConfigDirectory() {
        if (configDirectory == null) {
            configDirectory = FabricLoader.getInstance().getConfigDir().resolve("flashback");
            try {
                Files.createDirectories(configDirectory, new FileAttribute[0]);
            }
            catch (Exception e) {
                LOGGER.error("Unable to create directories for config folder", (Throwable)e);
            }
        }
        return configDirectory;
    }

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(FinishedServerTick.TYPE, class_9139.method_56431((Object)FinishedServerTick.INSTANCE));
        PayloadTypeRegistry.playS2C().register(FlashbackForceClientTick.TYPE, class_9139.method_56431((Object)FlashbackForceClientTick.INSTANCE));
        PayloadTypeRegistry.playS2C().register(FlashbackClearParticles.TYPE, class_9139.method_56431((Object)FlashbackClearParticles.INSTANCE));
        PayloadTypeRegistry.playS2C().register(FlashbackClearEntities.TYPE, class_9139.method_56431((Object)FlashbackClearEntities.INSTANCE));
        PayloadTypeRegistry.playS2C().register(FlashbackInstantlyLerp.TYPE, class_9139.method_56431((Object)FlashbackInstantlyLerp.INSTANCE));
        PayloadTypeRegistry.playS2C().register(FlashbackRemoteSelectHotbarSlot.TYPE, FlashbackRemoteSelectHotbarSlot.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(FlashbackRemoteExperience.TYPE, FlashbackRemoteExperience.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(FlashbackRemoteFoodData.TYPE, FlashbackRemoteFoodData.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(FlashbackRemoteSetSlot.TYPE, FlashbackRemoteSetSlot.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(FlashbackVoiceChatSound.TYPE, FlashbackVoiceChatSound.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(FlashbackAccurateEntityPosition.TYPE, FlashbackAccurateEntityPosition.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(FlashbackSetBorderLerpStartTime.TYPE, FlashbackSetBorderLerpStartTime.STREAM_CODEC);
    }

    public void onInitializeClient() {
        Path configFolder = FabricLoader.getInstance().getConfigDir().resolve("flashback");
        try {
            Files.createDirectories(configFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config folder", (Throwable)e);
        }
        config = FlashbackConfigV1.tryLoadFromFolder(configFolder);
        configElements = LatticeElements.fromAnnotations((class_2561)FlashbackTextComponents.FLASHBACK_OPTIONS, (Object)config);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            class_310.method_1551().method_63588(() -> Lattice.performTest((LatticeElements)configElements));
        }
        TempFolderProvider.tryDeleteStaleFolders(TempFolderProvider.TempFolderType.SERVER);
        Path recordingFolder = TempFolderProvider.getTypedTempFolder(TempFolderProvider.TempFolderType.RECORDING);
        if (Files.exists(recordingFolder, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(recordingFolder);){
                for (Path folder : directoryStream) {
                    if (!Files.exists(folder.resolve("metadata.json"), new LinkOption[0])) continue;
                    pendingReplayRecovery.add(folder);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (pendingReplayRecovery.isEmpty()) {
            TempFolderProvider.tryDeleteStaleFolders(TempFolderProvider.TempFolderType.RECORDING);
        }
        try {
            FileUtils.deleteDirectory((File)Path.of("replay_export_temp", new String[0]).toFile());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.deleteUnusedReplayStates();
        ActionRegistry.register(ActionNextTick.INSTANCE);
        ActionRegistry.register(ActionGamePacket.INSTANCE);
        ActionRegistry.register(ActionConfigurationPacket.INSTANCE);
        ActionRegistry.register(ActionCreateLocalPlayer.INSTANCE);
        ActionRegistry.register(ActionMoveEntities.INSTANCE);
        ActionRegistry.register(ActionLevelChunkCached.INSTANCE);
        ActionRegistry.register(ActionAccuratePlayerPosition.INSTANCE);
        KeyframeRegistry.register(CameraKeyframeType.INSTANCE);
        KeyframeRegistry.register(CameraOrbitKeyframeType.INSTANCE);
        KeyframeRegistry.register(TrackEntityKeyframeType.INSTANCE);
        KeyframeRegistry.register(CameraShakeKeyframeType.INSTANCE);
        KeyframeRegistry.register(FOVKeyframeType.INSTANCE);
        KeyframeRegistry.register(SpeedKeyframeType.INSTANCE);
        KeyframeRegistry.register(TimelapseKeyframeType.INSTANCE);
        KeyframeRegistry.register(TimeOfDayKeyframeType.INSTANCE);
        KeyframeRegistry.register(FreezeKeyframeType.INSTANCE);
        KeyframeRegistry.register(BlockOverrideKeyframeType.INSTANCE);
        KeyframeRegistry.register(AudioKeyframeType.INSTANCE);
        ClientPlayNetworking.registerGlobalReceiver(FlashbackForceClientTick.TYPE, (payload, context) -> {
            if (Flashback.isInReplay()) {
                class_310.method_1551().method_1574();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackClearParticles.TYPE, (payload, context) -> {
            if (Flashback.isInReplay()) {
                class_310.method_1551().field_1713.method_48015();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackClearEntities.TYPE, (payload, context) -> {
            if (Flashback.isInReplay()) {
                for (class_1297 entity : class_310.method_1551().field_1687.method_18112()) {
                    if (entity == null || entity instanceof class_1657) continue;
                    entity.method_31472();
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackInstantlyLerp.TYPE, (payload, context) -> {
            if (Flashback.isInReplay()) {
                for (class_1297 entity : class_310.method_1551().field_1687.method_18112()) {
                    if (entity instanceof class_1309 && !entity.method_31481() && !(entity instanceof class_746)) {
                        entity.method_5808(entity.method_53830(), entity.method_53827(), entity.method_53828(), entity.method_53831(), entity.method_53829());
                    }
                    entity.method_22862();
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackRemoteSelectHotbarSlot.TYPE, (payload, context) -> {
            class_1297 entity;
            if (Flashback.isInReplay() && (entity = class_310.method_1551().field_1687.method_8469(payload.entityId())) instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_31548().field_7545 = payload.slot();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackRemoteExperience.TYPE, (payload, context) -> {
            class_1297 entity;
            if (Flashback.isInReplay() && (entity = class_310.method_1551().field_1687.method_8469(payload.entityId())) instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.field_7510 = payload.experienceProgress();
                player.field_7495 = payload.totalExperience();
                player.field_7520 = payload.experienceLevel();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackRemoteFoodData.TYPE, (payload, context) -> {
            class_1297 entity;
            if (Flashback.isInReplay() && (entity = class_310.method_1551().field_1687.method_8469(payload.entityId())) instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_7344().method_7580(payload.foodLevel());
                player.method_7344().method_7581(payload.saturationLevel());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackRemoteSetSlot.TYPE, (payload, context) -> {
            class_1297 entity;
            if (Flashback.isInReplay() && (entity = class_310.method_1551().field_1687.method_8469(payload.entityId())) instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_31548().method_5447(payload.slot(), payload.itemStack());
            }
        });
        if (FabricLoader.getInstance().isModLoaded("voicechat")) {
            ClientPlayNetworking.registerGlobalReceiver(FlashbackVoiceChatSound.TYPE, (payload, context) -> {
                if (Flashback.isInReplay()) {
                    SimpleVoiceChatPlayback.play(payload);
                }
            });
        }
        ClientPlayNetworking.registerGlobalReceiver(FlashbackAccurateEntityPosition.TYPE, (payload, context) -> {
            if (Flashback.isInReplay()) {
                AccurateEntityPositionHandler.update(payload);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FlashbackSetBorderLerpStartTime.TYPE, (payload, context) -> {
            if (Flashback.isInReplay()) {
                worldBorderLerpStartTime = payload.time();
            }
        });
        ShaderManager.INSTANCE.register();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder flashback = ClientCommandManager.literal((String)"flashback");
            flashback.then(ClientCommandManager.literal((String)"start").executes(this::startRecordingReplay));
            flashback.then(ClientCommandManager.literal((String)"finish").executes(this::finishRecordingReplay));
            flashback.then(ClientCommandManager.literal((String)"end").executes(this::finishRecordingReplay));
            flashback.then(ClientCommandManager.literal((String)"pause").executes(ctx -> {
                Flashback.pauseRecordingReplay(true);
                return 0;
            }));
            flashback.then(ClientCommandManager.literal((String)"unpause").executes(ctx -> {
                Flashback.pauseRecordingReplay(false);
                return 0;
            }));
            flashback.then(ClientCommandManager.literal((String)"config").executes(this::openFlashbackConfig));
            flashback.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mark").executes(command -> {
                this.addMarker(null, null, null);
                return 0;
            })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"color", (ArgumentType)BetterColorArgument.color()).executes(command -> {
                int colour = (Integer)command.getArgument("color", Integer.class);
                this.addMarker(colour, null, null);
                return 0;
            })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"savePosition", (ArgumentType)BoolArgumentType.bool()).executes(command -> {
                int colour = (Integer)command.getArgument("color", Integer.class);
                boolean savePosition = (Boolean)command.getArgument("savePosition", Boolean.class);
                this.addMarker(colour, savePosition, null);
                return 0;
            })).then(ClientCommandManager.argument((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(command -> {
                int colour = (Integer)command.getArgument("color", Integer.class);
                boolean savePosition = (Boolean)command.getArgument("savePosition", Boolean.class);
                String description = (String)command.getArgument("description", String.class);
                this.addMarker(colour, savePosition, description);
                return 0;
            })))));
            dispatcher.register(flashback);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (!Flashback.isInReplay() && !isOpeningReplay) {
                return;
            }
            String hideName = "hide";
            if (dispatcher.findNode(Collections.singleton("hide")) != null) {
                hideName = "hide_flashback";
            }
            LiteralArgumentBuilder hideEntity = (LiteralArgumentBuilder)class_2170.method_9247((String)hideName).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(command -> {
                EditorState editorState = EditorStateManager.getCurrent();
                if (!Flashback.isInReplay() || editorState == null) {
                    ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43469((String)"flashback.command_only_inside_replay", (Object[])new Object[]{class_2561.method_43470((String)"hide")}));
                    return 0;
                }
                Collection entities = class_2186.method_9317((CommandContext)command, (String)"targets");
                for (class_1297 entity : entities) {
                    editorState.hideDuringExport.add(entity.method_5667());
                }
                int count = entities.size();
                ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"flashback.hide_command.n_entities_hidden", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(count))}), false);
                return 0;
            }));
            dispatcher.register(hideEntity);
            String showName = "show";
            if (dispatcher.findNode(Collections.singleton("show")) != null) {
                showName = "show_flashback";
            }
            LiteralArgumentBuilder showEntity = (LiteralArgumentBuilder)class_2170.method_9247((String)showName).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(command -> {
                EditorState editorState = EditorStateManager.getCurrent();
                if (!Flashback.isInReplay() || editorState == null) {
                    ((class_2168)command.getSource()).method_9213((class_2561)class_2561.method_43469((String)"flashback.command_only_inside_replay", (Object[])new Object[]{class_2561.method_43470((String)"show")}));
                    return 0;
                }
                Collection entities = class_2186.method_9317((CommandContext)command, (String)"targets");
                for (class_1297 entity : entities) {
                    editorState.hideDuringExport.remove(entity.method_5667());
                }
                int count = entities.size();
                ((class_2168)command.getSource()).method_9226(() -> class_2561.method_43469((String)"flashback.show_command.n_entities_shown", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(count))}), false);
                return 0;
            }));
            dispatcher.register(showEntity);
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (!Flashback.isInReplay() && Flashback.getConfig().recordingControls.automaticallyStart && RECORDER == null) {
                delayedStartRecording = 20;
            }
            if (FabricLoader.getInstance().isModLoaded("voicechat")) {
                SimpleVoiceChatPlayback.cleanUp();
            }
        });
        AtomicReference<String> unsupportedLoader = new AtomicReference<String>(Flashback.findUnsupportedLoaders());
        AtomicBoolean synchronizeTickingCanTickClient = new AtomicBoolean(true);
        AtomicBoolean synchronizeTickingCanTickServer = new AtomicBoolean(true);
        ClientTickEvents.END_CLIENT_TICK.register(minecraft -> {
            class_1297 other;
            Flashback.updateIsInReplay();
            AccurateEntityPositionHandler.tick();
            class_1297 camera = class_310.method_1551().field_1719;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && camera != null && camera != player && camera.method_31481() && (other = player.method_37908().method_8469(camera.method_5628())) != null && !other.method_31481()) {
                class_310.method_1551().method_1504(other);
            }
            Flashback.getConfig().tickDelayedSave();
            synchronizeTickingCanTickServer.set(true);
        });
        ClientTickEvents.START_CLIENT_TICK.register(minecraft -> {
            if (RECORDER != null && Flashback.config.advanced.synchronizeTicking && minecraft.method_1496()) {
                boolean willRecord;
                boolean isLevelLoaded = !(minecraft.field_1755 instanceof class_434);
                boolean bl = willRecord = minecraft.field_1687 != null && (minecraft.method_18506() == null || !minecraft.method_18506().method_18640()) && !minecraft.method_1493() && !RECORDER.isPaused() && isLevelLoaded;
                while (willRecord && !synchronizeTickingCanTickClient.compareAndSet(true, false)) {
                    LockSupport.parkNanos("flashback synchronized ticking: waiting for server", 100000L);
                }
            }
            if (Flashback.canReplaceScreen(minecraft.field_1755)) {
                Flashback.openNewScreen(unsupportedLoader, minecraft.field_1755);
            }
            if (minecraft.field_1687 != null && delayedStartRecording > 0) {
                class_1132 integratedServer = minecraft.method_1576();
                if (integratedServer != null && integratedServer.getClass() != class_1132.class) {
                    delayedStartRecording = 0;
                } else if (Flashback.getConfig().recordingControls.automaticallyStart && RECORDER == null) {
                    if (--delayedStartRecording == 0) {
                        Flashback.startRecordingReplay();
                    }
                } else {
                    delayedStartRecording = 0;
                }
            }
            Flashback.updateIsInReplay();
            if (createMarker1KeyBind.method_1436()) {
                this.addMarker(Flashback.config.marker.markerOptions1);
            }
            if (createMarker2KeyBind.method_1436()) {
                this.addMarker(Flashback.config.marker.markerOptions2);
            }
            if (createMarker3KeyBind.method_1436()) {
                this.addMarker(Flashback.config.marker.markerOptions3);
            }
            if (createMarker4KeyBind.method_1436()) {
                this.addMarker(Flashback.config.marker.markerOptions4);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> synchronizeTickingCanTickClient.set(true));
        ServerTickEvents.START_SERVER_TICK.register(minecraftServer -> {
            if (RECORDER != null && Flashback.config.advanced.synchronizeTicking) {
                while (!synchronizeTickingCanTickServer.compareAndSet(true, false)) {
                    LockSupport.parkNanos("flashback synchronized ticking: waiting for client", 100000L);
                }
            }
        });
        if (FabricLoader.getInstance().isModLoaded("distanthorizons")) {
            if (DhApi.getApiMajorVersion() >= 4) {
                LOGGER.info("DistantHorizons detected. Enabling Flashback+DistantHorizons integration");
                supportsDistantHorizons = true;
                DistantHorizonsSupport.register();
            } else {
                LOGGER.error("DistantHorizons is installed, but API version is too low ({}). Disabling integration.", (Object)DhApi.getApiMajorVersion());
            }
        }
    }

    private static void openNewScreen(AtomicReference<String> unsupportedLoader, class_437 currentScreen) {
        if (unsupportedLoader.get() != null) {
            String loaderName = unsupportedLoader.get();
            unsupportedLoader.set(null);
            if (System.currentTimeMillis() > Flashback.getConfig().internal.nextUnsupportedModLoaderWarning) {
                class_5250 warning = class_2561.method_43469((String)"flashback.unsupported_loader.message", (Object[])new Object[]{class_2561.method_43470((String)loaderName)});
                class_310.method_1551().method_1507((class_437)new UnsupportedLoaderScreen(currentScreen, (class_2561)class_2561.method_43471((String)"flashback.screen_unsupported"), (class_2561)warning));
                return;
            }
        }
        if (!pendingReplayRecovery.isEmpty()) {
            class_2561 nl = FlashbackTextComponents.NEWLINE;
            class_5250 title = class_2561.method_43471((String)"flashback.screen_recovery");
            class_5250 description = class_2561.method_43473().method_10852((class_2561)class_2561.method_43469((String)"flashback.recovery1", (Object[])new Object[]{class_2561.method_43471((String)"flashback.recovery2").method_27692(class_124.field_1054)})).method_10852(nl).method_10852((class_2561)class_2561.method_43471((String)"flashback.recovery3")).method_10852(nl).method_10852(nl).method_10852((class_2561)class_2561.method_43471((String)"flashback.recovery4").method_27692(class_124.field_1061)).method_10852(nl).method_10852(nl).method_10852((class_2561)class_2561.method_43471((String)"flashback.recovery5").method_27692(class_124.field_1060));
            class_310.method_1551().method_1507((class_437)new RecoverRecordingsScreen(currentScreen, (class_2561)title, (class_2561)description, recover -> {
                switch (recover) {
                    case RECOVER: {
                        pendingReplaySave.addAll(pendingReplayRecovery);
                        pendingReplayRecovery.clear();
                        break;
                    }
                    case SKIP: {
                        pendingReplayRecovery.clear();
                        break;
                    }
                    case DELETE: {
                        TempFolderProvider.tryDeleteStaleFolders(TempFolderProvider.TempFolderType.RECORDING);
                        pendingReplayRecovery.clear();
                    }
                }
            }));
            return;
        }
        if (!pendingReplaySave.isEmpty()) {
            Path recordFolder = pendingReplaySave.getFirst();
            LocalDateTime dateTime = LocalDateTime.now();
            dateTime = dateTime.withNano(0);
            class_310.method_1551().method_1507((class_437)new SaveReplayScreen(currentScreen, recordFolder, dateTime.toString()));
            return;
        }
        if (pendingUnsupportedModsForRecording != null) {
            String mods = StringUtils.join(pendingUnsupportedModsForRecording, (String)", ");
            class_5250 title = class_2561.method_43471((String)"flashback.incompatible_with_recording");
            class_5250 description = class_2561.method_43471((String)"flashback.incompatible_with_recording_description").method_10852((class_2561)class_2561.method_43470((String)mods).method_27692(class_124.field_1061));
            class_310.method_1551().method_1507((class_437)new class_403(() -> class_310.method_1551().method_1507(currentScreen), (class_2561)title, (class_2561)description));
            pendingUnsupportedModsForRecording = null;
            return;
        }
        if (delayedOpenConfig) {
            Flashback.openConfigScreen(currentScreen);
            delayedOpenConfig = false;
            return;
        }
    }

    public static class_437 createConfigScreen(class_437 oldScreen) {
        return Lattice.createConfigScreen((LatticeElements)configElements, config::saveToDefaultFolder, (class_437)oldScreen);
    }

    public static void openConfigScreen(class_437 oldScreen) {
        class_310.method_1551().method_1507(Flashback.createConfigScreen(oldScreen));
    }

    public static List<String> getReplayIncompatibleMods() {
        ArrayList<String> incompatible = new ArrayList<String>();
        if (FabricLoader.getInstance().isModLoaded("vmp")) {
            incompatible.add("VeryManyPlayers (vmp)");
        }
        if (FabricLoader.getInstance().isModLoaded("c2me")) {
            incompatible.add("Concurrent Chunk Management Engine (c2me)");
        }
        return incompatible;
    }

    public static List<String> getRecordingIncompatibleMods() {
        ArrayList<String> incompatible = new ArrayList<String>();
        if (FabricLoader.getInstance().isModLoaded("farsight")) {
            incompatible.add("Farsight");
        }
        if (incompatible.isEmpty()) {
            return null;
        }
        return incompatible;
    }

    @Nullable
    private static String findUnsupportedLoaders() {
        if (FabricLoader.getInstance().isModLoaded("feather")) {
            return "Feather Client";
        }
        return null;
    }

    private static boolean canReplaceScreen(class_437 screen) {
        return screen == null || screen instanceof class_433 || screen instanceof class_442 || screen instanceof class_4325 || screen instanceof class_500;
    }

    private void addMarker(FlashbackConfigV1.SubcategoryMarker.SubcategoryMarkerOptions options) {
        String custom;
        int colour = options.color == MarkerColour.CUSTOM_RGB ? ((custom = options.customRGB.replaceAll("[^0-9a-fA-F]", "")).isEmpty() ? 0 : Integer.parseInt(custom, 16)) : options.color.colour;
        this.addMarker(colour, options.savePosition, options.description);
    }

    private void addMarker(@Nullable Integer colour, @Nullable Boolean savePosition, @Nullable String description) {
        class_1297 camera;
        class_310 minecraft = class_310.method_1551();
        if (RECORDER == null) {
            minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"flashback.mark_command.not_recording").method_27692(class_124.field_1061));
            return;
        }
        ReplayMarker.MarkerPosition position = null;
        if ((savePosition == null || savePosition.booleanValue()) && (camera = class_310.method_1551().method_1560()) != null) {
            position = new ReplayMarker.MarkerPosition(camera.method_33571().method_46409(), camera.method_37908().method_27983().toString());
        }
        if (description != null && description.isBlank()) {
            description = null;
        }
        Object feedback = description != null ? class_1074.method_4662((String)"flashback.mark.added_with_description", (Object[])new Object[]{description}) : (colour != null ? class_1074.method_4662((String)"flashback.mark.added_with_color", (Object[])new Object[]{Integer.toHexString(colour)}) : class_1074.method_4662((String)"flashback.mark.added", (Object[])new Object[0]));
        if (position != null) {
            feedback = (String)feedback + class_1074.method_4662((String)"flashback.mark.added_at", (Object[])new Object[]{Float.valueOf(position.position().x), Float.valueOf(position.position().y), Float.valueOf(position.position().z)});
        }
        if (colour == null) {
            colour = 0xFF5555;
        }
        if (description != null && (description = description.trim()).isEmpty()) {
            description = null;
        }
        minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)feedback));
        RECORDER.addMarker(new ReplayMarker(colour, position, description));
    }

    private void deleteUnusedReplayStates() {
        Path flashbackDir = Flashback.getDataDirectory();
        Path replayDir = Flashback.getReplayFolder();
        Path replayStatesDir = flashbackDir.resolve("editor_states");
        if (!Files.exists(replayDir, new LinkOption[0]) || !Files.isDirectory(replayDir, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(replayStatesDir, new LinkOption[0]) || !Files.isDirectory(replayStatesDir, new LinkOption[0])) {
            return;
        }
        ArrayList<String> recentReplays = new ArrayList<String>(Flashback.config.internal.recentReplays);
        CompletableFuture.runAsync(() -> {
            long currentTime = System.currentTimeMillis();
            HashMap<UUID, Path> replayStates = new HashMap<UUID, Path>();
            try (DirectoryStream<Path> directoryStream22 = Files.newDirectoryStream(replayStatesDir);){
                for (Path path : directoryStream22) {
                    UUID uuid;
                    BasicFileAttributeView attributeView;
                    BasicFileAttributes basicFileAttributes;
                    long lastModified;
                    long timeDifference;
                    String filename = path.getFileName().toString();
                    String withoutExtension = null;
                    if (filename.endsWith(".json")) {
                        withoutExtension = filename.substring(0, filename.length() - 5);
                    } else if (filename.endsWith(".json.old")) {
                        withoutExtension = filename.substring(0, filename.length() - 9);
                    }
                    try {
                        boolean used = false;
                        JsonObject jsonObject = (JsonObject)FlashbackGson.COMPRESSED.fromJson(Files.readString(path), JsonObject.class);
                        if (jsonObject.has("usedByPaths")) {
                            for (JsonElement usedBy : jsonObject.get("usedByPaths").getAsJsonArray()) {
                                String usedByStr = usedBy.getAsString();
                                if (recentReplays.contains(usedByStr)) {
                                    used = true;
                                    break;
                                }
                                Path usedByPath = Path.of(usedBy.getAsString(), new String[0]);
                                if (!Files.exists(usedByPath, new LinkOption[0])) continue;
                                used = true;
                                break;
                            }
                        }
                        if (used) {
                            continue;
                        }
                    }
                    catch (Exception used) {
                        // empty catch block
                    }
                    if ((timeDifference = Math.abs(currentTime - (lastModified = Math.max((basicFileAttributes = (attributeView = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0])).readAttributes()).creationTime().toMillis(), basicFileAttributes.lastModifiedTime().toMillis())))) < Duration.ofDays(30L).toMillis() || withoutExtension == null) continue;
                    try {
                        uuid = UUID.fromString(withoutExtension);
                    }
                    catch (Exception ignored) {
                        continue;
                    }
                    replayStates.put(uuid, path);
                }
            }
            catch (IOException directoryStream22) {
                // empty catch block
            }
            if (replayStates.isEmpty()) {
                return;
            }
            HashSet<UUID> replayUuids = new HashSet<UUID>();
            HashSet<Path> checkedReplayPaths = new HashSet<Path>();
            try {
                for (Object recentReplayStr : recentReplays) {
                    Path path = Path.of((String)recentReplayStr, new String[0]);
                    if (!checkedReplayPaths.add(path) || !Files.exists(path, new LinkOption[0])) continue;
                    Flashback.readReplayUuidIntoSet(path, replayUuids);
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Unable read replay uuid", (Throwable)iOException);
                return;
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(replayDir);){
                for (Path path : directoryStream) {
                    if (!checkedReplayPaths.add(path)) continue;
                    Flashback.readReplayUuidIntoSet(path, replayUuids);
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to iterate replay directory or read replay uuid", (Throwable)iOException);
                return;
            }
            for (Map.Entry entry : replayStates.entrySet()) {
                if (replayUuids.contains(entry.getKey())) continue;
                try {
                    Files.deleteIfExists((Path)entry.getValue());
                }
                catch (IOException iOException) {}
            }
        }, (Executor)class_156.method_18349());
    }

    private static void readReplayUuidIntoSet(Path path, Set<UUID> replayUuids) throws IOException {
        JsonObject metadataJson;
        FlashbackMeta metadata;
        if (!path.toString().endsWith(".zip")) {
            return;
        }
        String metadataString = null;
        try (FileSystem fs = FileSystems.newFileSystem(path);){
            Path metadataPath = fs.getPath("/metadata.json", new String[0]);
            if (Files.exists(metadataPath, new LinkOption[0])) {
                metadataString = Files.readString(metadataPath);
            }
        }
        if (metadataString != null && (metadata = FlashbackMeta.fromJson(metadataJson = (JsonObject)new Gson().fromJson(metadataString, JsonObject.class))) != null) {
            replayUuids.add(metadata.replayIdentifier);
        }
    }

    public static FlashbackConfigV1 getConfig() {
        return config;
    }

    @Nullable
    public static ReplayServer getReplayServer() {
        class_1132 class_11322 = class_310.method_1551().method_1576();
        if (class_11322 instanceof ReplayServer) {
            ReplayServer replayServer = (ReplayServer)class_11322;
            return replayServer;
        }
        return null;
    }

    public static void removePendingReplaySave(Path recordFolder) {
        pendingReplaySave.remove(recordFolder);
    }

    public static boolean isExporting() {
        return EXPORT_JOB != null && EXPORT_JOB.isRunning();
    }

    public static void updateIsInReplay() {
        isInReplay = class_310.method_1551().method_1576() instanceof ReplayServer;
    }

    public static boolean isInReplay() {
        return isInReplay;
    }

    public static long getVisualMillis() {
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            ExportJob exportJob = EXPORT_JOB;
            float tick = exportJob != null ? (float)exportJob.getCurrentTickDouble() : (float)replayServer.getPartialReplayTick();
            return (long)(tick * 50.0f);
        }
        return class_156.method_658();
    }

    private int startRecordingReplay(CommandContext<FabricClientCommandSource> command) {
        Flashback.startRecordingReplay();
        return 0;
    }

    private int finishRecordingReplay(CommandContext<FabricClientCommandSource> command) {
        Flashback.finishRecordingReplay();
        return 0;
    }

    private int openFlashbackConfig(CommandContext<FabricClientCommandSource> command) {
        delayedOpenConfig = true;
        return 0;
    }

    public static void startRecordingReplay() {
        if (RECORDER != null) {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)FlashbackSystemToasts.RECORDING_TOAST, (class_2561)class_2561.method_43471((String)"flashback.toast.already_recording"), (class_2561)class_2561.method_43471((String)"flashback.toast.already_recording_description"));
            return;
        }
        List<String> unsupported = Flashback.getRecordingIncompatibleMods();
        if (unsupported != null && !unsupported.isEmpty()) {
            pendingUnsupportedModsForRecording = unsupported;
            return;
        }
        RECORDER = new Recorder(class_310.method_1551().field_1724.method_56673());
        if (Flashback.getConfig().recordingControls.showRecordingToasts) {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)FlashbackSystemToasts.RECORDING_TOAST, (class_2561)FlashbackTextComponents.FLASHBACK, (class_2561)class_2561.method_43471((String)"flashback.toast.started_recording"));
        }
    }

    public static void pauseRecordingReplay(boolean pause) {
        RECORDER.setPaused(pause);
        if (Flashback.getConfig().recordingControls.showRecordingToasts) {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)FlashbackSystemToasts.RECORDING_TOAST, (class_2561)FlashbackTextComponents.FLASHBACK, (class_2561)class_2561.method_43471((String)(pause ? "flashback.toast.paused_recording" : "flashback.toast.unpaused_recording")));
        }
    }

    public static void cancelRecordingReplay() {
        Recorder recorder = RECORDER;
        RECORDER = null;
        Path recordFolder = recorder.finish();
        try {
            FileUtils.deleteDirectory((File)recordFolder.toFile());
        }
        catch (Exception e) {
            LOGGER.error("Exception deleting record folder", (Throwable)e);
        }
        if (Flashback.getConfig().recordingControls.showRecordingToasts) {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)FlashbackSystemToasts.RECORDING_TOAST, (class_2561)FlashbackTextComponents.FLASHBACK, (class_2561)class_2561.method_43471((String)"flashback.toast.cancelled_recording"));
        }
    }

    public static void finishRecordingReplay() {
        if (RECORDER == null) {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)FlashbackSystemToasts.RECORDING_TOAST, (class_2561)class_2561.method_43471((String)"flashback.toast.not_recording"), (class_2561)class_2561.method_43471((String)"flashback.toast.cant_finish_when_not_recording"));
            return;
        }
        Recorder recorder = RECORDER;
        RECORDER = null;
        recorder.endTick(true);
        if (Flashback.getConfig().recordingControls.quicksave) {
            Object filename;
            Path replayDir = Flashback.getReplayFolder();
            if (!Files.exists(replayDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(replayDir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                LocalDateTime dateTime = LocalDateTime.now();
                dateTime = dateTime.withNano(0);
                filename = class_4239.method_19773((Path)replayDir, (String)dateTime.toString(), (String)".zip");
            }
            catch (IOException e) {
                LOGGER.error("Error while trying to determine filename", (Throwable)e);
                filename = String.valueOf(UUID.randomUUID()) + ".zip";
            }
            Path outputFile = replayDir.resolve((String)filename);
            ReplayExporter.export(recorder.finish(), outputFile, null);
        } else {
            pendingReplaySave.add(recorder.finish());
        }
        if (Flashback.getConfig().recordingControls.showRecordingToasts) {
            class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)FlashbackSystemToasts.RECORDING_TOAST, (class_2561)FlashbackTextComponents.FLASHBACK, (class_2561)class_2561.method_43471((String)"flashback.toast.finished_recording"));
        }
    }

    @Nullable
    public static class_742 getSpectatingPlayer() {
        class_742 clientPlayer;
        if (!Flashback.isInReplay()) {
            return null;
        }
        class_1297 class_12972 = class_310.method_1551().method_1560();
        if (class_12972 instanceof class_742 && (clientPlayer = (class_742)class_12972) != class_310.method_1551().field_1724) {
            return clientPlayer;
        }
        return null;
    }

    public static void openReplayFromFileBrowser() {
        String defaultFolder = Flashback.getReplayFolder().toString();
        AsyncFileDialogs.openFileDialog(defaultFolder, "Zip File", "zip").thenAccept(pathStr -> {
            if (pathStr != null) {
                Path path = Path.of(pathStr, new String[0]);
                class_310.method_1551().method_20493(() -> Flashback.openReplayWorld(path));
            }
        });
    }

    public static class_1928 createReplayGameRules(class_7699 featureFlagSet) {
        class_1928 gameRules = new class_1928(featureFlagSet);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19390)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19393)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19409)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19422)).method_20758(true, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_21831)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_38975)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_21832)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_42474)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19387)).method_20758(false, null);
        ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19406)).method_20758(false, null);
        ((class_1928.class_4312)gameRules.method_20746(class_1928.field_19399)).method_35236(0, null);
        return gameRules;
    }

    public static void openReplayWorld(Path path) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 != null) {
            minecraft.field_1687.method_8525();
        }
        minecraft.method_18099();
        minecraft.method_1507((class_437)new class_442());
        ReplayUI.shownRegistryErrorWarning = false;
        ReplayUI.shownPlayerSpawnErrorWarning = false;
        String pathStr = path.toString();
        FlashbackConfigV1 config = Flashback.getConfig();
        config.internal.recentReplays.remove(pathStr);
        config.internal.recentReplays.add(0, pathStr);
        if (config.internal.recentReplays.size() > 32) {
            config.internal.recentReplays.remove(config.internal.recentReplays.size() - 1);
        }
        config.delayedSaveToDefaultFolder();
        try {
            isOpeningReplay = true;
            UUID replayUuid = UUID.randomUUID();
            Path replayTemp = TempFolderProvider.createTemp(TempFolderProvider.TempFolderType.SERVER, replayUuid);
            FileUtils.deleteDirectory((File)replayTemp.toFile());
            class_32 source = new class_32(replayTemp.resolve("saves"), replayTemp.resolve("backups"), class_310.method_1551().method_52702(), class_310.method_1551().method_1543());
            class_32.class_5143 access = source.method_27002("replay");
            class_3283 packRepository = class_3286.method_45285((class_32.class_5143)access);
            packRepository.method_14445();
            class_1928 gameRules = Flashback.createReplayGameRules(class_7701.field_40183);
            class_7712 worldDataConfiguration = new class_7712(new class_5359(List.of(), List.of()), class_7701.field_40183);
            class_1940 levelSettings = new class_1940("Replay", class_1934.field_9219, false, class_1267.field_5802, true, gameRules, worldDataConfiguration);
            class_7237.class_7238 packConfig = new class_7237.class_7238(packRepository, worldDataConfiguration, false, true);
            class_7237.class_6906 initConfig = new class_7237.class_6906(packConfig, class_2170.class_5364.field_25420, 4);
            class_6904 worldStem = (class_6904)class_156.method_43499(executor -> class_7237.method_42098((class_7237.class_6906)initConfig, dataLoadContext -> {
                class_2378 registry = new class_2370(class_7924.field_41224, Lifecycle.stable()).method_40276();
                class_6880.class_6883 plains = (class_6880.class_6883)dataLoadContext.comp_989().method_46762(class_7924.field_41236).method_46746(class_1972.field_9451).get();
                class_6880.class_6883 overworld = (class_6880.class_6883)dataLoadContext.comp_989().method_46762(class_7924.field_41241).method_46746(class_7134.field_37666).get();
                class_7723 worldDimensions = new class_7723(Map.of(class_5363.field_25412, new class_5363((class_6880)overworld, (class_2794)new EmptyLevelSource((class_6880.class_6883<class_1959>)plains))));
                class_7723.class_7725 complete = worldDimensions.method_45518(registry);
                return new class_7237.class_7661((Object)new class_31(levelSettings, new class_5285(0L, false, false), complete.comp_1018(), complete.method_45536()), complete.method_45537());
            }, class_6904::new, (Executor)class_156.method_18349(), (Executor)executor)).get();
            ((MinecraftExt)class_310.method_1551()).flashback$startReplayServer(access, packRepository, worldStem, replayUuid, path);
            TaskbarManager.launchTaskbarManager();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            isOpeningReplay = false;
        }
    }

    static {
        configElements = null;
        configDirectory = null;
        delayedStartRecording = 0;
        delayedOpenConfig = false;
        isInReplay = false;
        supportsDistantHorizons = false;
        pendingReplaySave = new ArrayList<Path>();
        pendingReplayRecovery = new ArrayList<Path>();
        pendingUnsupportedModsForRecording = null;
        isOpeningReplay = false;
        worldBorderLerpStartTime = -1L;
        createMarker1KeyBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("flashback.keybind.create_marker_1", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "flashback.keybind"));
        createMarker2KeyBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("flashback.keybind.create_marker_2", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "flashback.keybind"));
        createMarker3KeyBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("flashback.keybind.create_marker_3", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "flashback.keybind"));
        createMarker4KeyBind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("flashback.keybind.create_marker_4", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "flashback.keybind"));
    }
}

