/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.combo_options.Sizing;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.editor.ui.CustomImGuiImplGl3;
import com.moulberry.flashback.editor.ui.CustomImGuiImplGlfw;
import com.moulberry.flashback.editor.ui.DailyTips;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.editor.ui.ReplayUIDefaults;
import com.moulberry.flashback.editor.ui.windows.ExportDoneWindow;
import com.moulberry.flashback.editor.ui.windows.ExportQueueWindow;
import com.moulberry.flashback.editor.ui.windows.ExportScreenshotWindow;
import com.moulberry.flashback.editor.ui.windows.MainMenuBar;
import com.moulberry.flashback.editor.ui.windows.PreferencesWindow;
import com.moulberry.flashback.editor.ui.windows.SelectedEntityPopup;
import com.moulberry.flashback.editor.ui.windows.StartExportWindow;
import com.moulberry.flashback.editor.ui.windows.TimelineWindow;
import com.moulberry.flashback.editor.ui.windows.VisualsWindow;
import com.moulberry.flashback.editor.ui.windows.WindowType;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import imgui.moulberry90.ImDrawData;
import imgui.moulberry90.ImDrawList;
import imgui.moulberry90.ImFont;
import imgui.moulberry90.ImFontAtlas;
import imgui.moulberry90.ImFontConfig;
import imgui.moulberry90.ImFontGlyphRangesBuilder;
import imgui.moulberry90.ImGui;
import imgui.moulberry90.ImGuiIO;
import imgui.moulberry90.ImGuiViewport;
import imgui.moulberry90.internal.ImGuiContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1078;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1934;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.glfw.GLFW;

public class ReplayUI {
    public static final CustomImGuiImplGlfw imguiGlfw = new CustomImGuiImplGlfw();
    private static final CustomImGuiImplGl3 imguiGl3 = new CustomImGuiImplGl3();
    private static boolean initialized = false;
    private static boolean isFrameFocused = false;
    private static boolean isFrameHovered = false;
    public static int frameX = 0;
    public static int frameY = 0;
    public static int frameWidth = 1;
    public static int frameHeight = 1;
    public static int viewportSizeX = 1;
    public static int viewportSizeY = 1;
    private static boolean activeLastFrame = false;
    public static int focusMainWindowCounter = 0;
    public static boolean hasAnyPopupOpen = false;
    public static Matrix4f lastProjectionMatrix = null;
    public static Quaternionf lastViewQuaternion = null;
    public static ImFont font = null;
    private static String languageCode = null;
    private static boolean wasNavClose = false;
    private static boolean navClose = false;
    private static final Lock deferredCloseLock = new ReentrantLock();
    private static final IntList deferredCloseTextureIds = new IntArrayList();
    private static final List<AutoCloseable> deferredClose = new ArrayList<AutoCloseable>();
    private static float globalScale = 1.0f;
    public static float newGlobalScale = 1.0f;
    private static float contentScale = 1.0f;
    private static ImGuiContext imGuiContext = null;
    private static ImGuiIO imGuiIO = null;
    private static boolean popupOpenLastFrame = false;
    private static String infoOverlayText = null;
    private static long infoOverlayEndMillis = 0L;
    private static UUID selectedEntity = null;
    private static boolean openSelectedEntityPopup = false;
    private static int displayingTip = -1;
    private static boolean dontShowTipsOnStartupCheckbox = false;
    public static boolean shownRegistryErrorWarning = false;
    public static boolean shownPlayerSpawnErrorWarning = false;

    public static void init() {
        if (initialized) {
            throw new IllegalStateException("ReplayUI initialized twice");
        }
        initialized = true;
        Path path = Flashback.getConfigDirectory().resolve("imgui.ini");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.writeString(path, (CharSequence)"[Window][###Timeline]\nPos=0,830\nSize=1920,250\nCollapsed=0\nDockId=0x00000002,0\n\n[Window][###Visuals]\nPos=1670,0\nSize=250,830\nCollapsed=0\nDockId=0x00000004,0\n\n[Docking][Data]\nDockSpace     ID=0x7C6B3D9B Window=0xA787BDB4 Pos=0,22 Size=1920,1080 Split=Y Selected=0x1F1A625A\n  DockNode    ID=0x00000001 Parent=0x7C6B3D9B SizeRef=1920,830 Split=X Selected=0x1F1A625A\n    DockNode  ID=0x00000003 Parent=0x00000001 SizeRef=1670,830 CentralNode=1 NoTabBar=1 Selected=0x1F1A625A\n    DockNode  ID=0x00000004 Parent=0x00000001 SizeRef=250,830 Selected=0x595032EA\n  DockNode    ID=0x00000002 Parent=0x7C6B3D9B SizeRef=1920,250 Selected=0xBF88A430\n", new OpenOption[0]);
            }
            catch (IOException iOException) {}
        } else {
            try {
                String imguiIni = Files.readString(path);
                boolean modified = false;
                if (imguiIni.contains("[Window][Timeline]")) {
                    imguiIni = imguiIni.replace("[Window][Timeline]", "[Window][###Timeline]");
                    modified = true;
                }
                if (imguiIni.contains("[Window][Visuals]")) {
                    imguiIni = imguiIni.replace("[Window][Visuals]", "[Window][###Visuals]");
                    modified = true;
                }
                if (imguiIni.contains("0x8B93E3BD")) {
                    imguiIni = imguiIni.replace("0x8B93E3BD", "0x7C6B3D9B");
                    modified = true;
                }
                if (modified) {
                    Files.writeString(path, (CharSequence)imguiIni, new OpenOption[0]);
                }
            }
            catch (IOException imguiIni) {
                // empty catch block
            }
        }
        long oldImGuiContext = ImGui.getCurrentContext().ptr;
        imGuiContext = new ImGuiContext(ImGui.createContext().ptr);
        ImGui.setCurrentContext(imGuiContext);
        imGuiIO = new ImGuiIO(ImGui.getIO().ptr);
        Path relativePath = FabricLoader.getInstance().getGameDir().relativize(path);
        imGuiIO.setIniFilename(relativePath.toString());
        imGuiIO.addConfigFlags(128);
        imGuiIO.setConfigMacOSXBehaviors(class_310.field_1703);
        imguiGlfw.init(class_310.method_1551().method_22683().method_4490(), true);
        imguiGl3.init("#version 150");
        contentScale = ReplayUI.imguiGlfw.contentScale;
        ReplayUI.initFonts(languageCode);
        ReplayUIDefaults.applyStyle(ImGui.getStyle());
        ImGuiContext currentContext = ImGui.getCurrentContext();
        currentContext.ptr = oldImGuiContext;
        ImGui.setCurrentContext(currentContext);
    }

    public static void initFonts(String languageCode) {
        if (languageCode != null) {
            ReplayUI.languageCode = languageCode;
        } else {
            languageCode = "en_us";
        }
        if (!initialized) {
            return;
        }
        ImGuiIO io = ReplayUI.getIO();
        ImFontAtlas fonts = io.getFonts();
        fonts.clear();
        int size = (int)(16.0f * ReplayUI.getUiScale());
        ImFontGlyphRangesBuilder rangesBuilder = new ImFontGlyphRangesBuilder();
        rangesBuilder.addRanges(fonts.getGlyphRangesDefault());
        if (languageCode.startsWith("uk") || languageCode.startsWith("ru") || languageCode.startsWith("bg")) {
            ReplayUI.addRanges(rangesBuilder, fonts.getGlyphRangesCyrillic());
        } else if (languageCode.startsWith("tr")) {
            rangesBuilder.addText("\u00c7\u00e7\u011e\u011f\u0130\u0131\u00d6\u00f6\u015e\u015f\u00dc\u00fc");
        } else if (languageCode.startsWith("pl")) {
            ReplayUI.addRanges(rangesBuilder, new short[]{256, 383, 0});
        } else if (languageCode.startsWith("cs")) {
            rangesBuilder.addText("\u00c1\u00e1\u010c\u010d\u010e\u010f\u00c9\u00e9\u011a\u011b\u00cd\u00ed\u0147\u0148\u00d3\u00f3\u0158\u0159\u0160\u0161\u0164\u0165\u00da\u00fa\u016e\u016f\u00dd\u00fd\u017d\u017e");
        } else if (languageCode.startsWith("he")) {
            ReplayUI.addRanges(rangesBuilder, new short[]{1424, 1535, -1251, -1201, 0});
        } else if (languageCode.startsWith("ja")) {
            ReplayUI.addRanges(rangesBuilder, fonts.getGlyphRangesJapanese());
        } else if (languageCode.startsWith("zh")) {
            ReplayUI.addRanges(rangesBuilder, fonts.getGlyphRangesChineseFull());
        } else if (languageCode.startsWith("ko")) {
            ReplayUI.addRanges(rangesBuilder, fonts.getGlyphRangesKorean());
        }
        class_2477 class_24772 = class_2477.method_10517();
        if (class_24772 instanceof class_1078) {
            class_1078 clientLanguage = (class_1078)class_24772;
            for (String value : clientLanguage.field_5330.values()) {
                rangesBuilder.addText(value);
            }
        }
        rangesBuilder.addChar('\u2318');
        rangesBuilder.addChar('\u2303');
        rangesBuilder.addChar('\u2387');
        rangesBuilder.addChar('\u21e7');
        rangesBuilder.addChar('\u2756');
        rangesBuilder.addChar('\u26a0');
        rangesBuilder.addChar('\u2190');
        rangesBuilder.addChar('\u2191');
        rangesBuilder.addChar('\u2192');
        rangesBuilder.addChar('\u2193');
        for (int i = 32; i <= 348; ++i) {
            String key;
            int scancode = GLFW.glfwGetKeyScancode((int)i);
            if (scancode == -1 || (key = GLFW.glfwGetKeyName((int)i, (int)-1)) == null) continue;
            rangesBuilder.addText(key);
            rangesBuilder.addText(key.toLowerCase());
            rangesBuilder.addText(key.toUpperCase());
            rangesBuilder.addText(key.toLowerCase(Locale.ROOT));
            rangesBuilder.addText(key.toUpperCase(Locale.ROOT));
        }
        short[] glyphRanges = rangesBuilder.buildRanges();
        ImFontConfig fontConfig = new ImFontConfig();
        fontConfig.setOversampleH(2);
        fontConfig.setOversampleV(2);
        fontConfig.setName("Inter (Medium), 16px");
        fontConfig.setGlyphOffset(0.0f, 0.0f);
        font = fonts.addFontFromMemoryTTF(ReplayUI.loadFont("inter-medium.ttf"), (float)size, fontConfig, glyphRanges);
        fontConfig.setMergeMode(true);
        fontConfig.setGlyphOffset(0.0f, (int)(5.0f * ReplayUI.getUiScale()));
        io.getFonts().addFontFromMemoryTTF(ReplayUI.loadFont("materialiconsround-regular.otf"), (float)((int)(20.0f * ReplayUI.getUiScale())), fontConfig, ReplayUI.buildMaterialIconRanges());
        fontConfig.setGlyphOffset(0.0f, 0.0f);
        if (languageCode.startsWith("he")) {
            short[] hebrewRanges = new short[]{1424, 1535, -1251, -1201, 0};
            io.getFonts().addFontFromMemoryTTF(ReplayUI.loadFont("heebo-medium.ttf"), (float)size, fontConfig, hebrewRanges);
        } else if (languageCode.startsWith("ja")) {
            io.getFonts().addFontFromMemoryTTF(ReplayUI.loadFont("notosansjp-medium.ttf"), (float)(size * 5 / 4), fontConfig, glyphRanges);
        } else if (languageCode.startsWith("zh")) {
            io.getFonts().addFontFromMemoryTTF(ReplayUI.loadFont("notosanstc-medium.ttf"), (float)(size * 5 / 4), fontConfig, glyphRanges);
            io.getFonts().addFontFromMemoryTTF(ReplayUI.loadFont("notosanssc-medium.ttf"), (float)(size * 5 / 4), fontConfig, glyphRanges);
        } else if (languageCode.startsWith("ko")) {
            io.getFonts().addFontFromMemoryTTF(ReplayUI.loadFont("notosanskr-medium.ttf"), (float)(size * 5 / 4), fontConfig, glyphRanges);
        }
        fontConfig.setMergeMode(false);
        fonts.build();
        imguiGl3.updateFontsTexture();
        fontConfig.destroy();
        fonts.clearTexData();
    }

    private static void addRanges(ImFontGlyphRangesBuilder builder, short[] ranges) {
        for (int i = 0; i < ranges.length && ranges[i] != 0; i += 2) {
            int from = ranges[i] & 0xFFFF;
            int to = ranges[i + 1] & 0xFFFF;
            for (int k = from; k <= to; ++k) {
                builder.addChar((char)k);
            }
        }
    }

    private static short[] buildMaterialIconRanges() {
        ImFontGlyphRangesBuilder builder = new ImFontGlyphRangesBuilder();
        builder.addChar('\ue04b');
        builder.addChar('\ue577');
        builder.addChar('\uefeb');
        builder.addChar('\ue3af');
        builder.addChar('\ue9e4');
        builder.addChar('\ue422');
        builder.addChar('\ue518');
        builder.addChar('\ue945');
        builder.addChar('\ue8f4');
        builder.addChar('\ue8f5');
        builder.addChar('\ue148');
        builder.addChar('\ue5d2');
        builder.addChar('\ue872');
        builder.addChar('\ue3c9');
        builder.addChar('\ue40a');
        builder.addChar('\ue92b');
        builder.addChar('\ueb3b');
        builder.addChar('\ue14a');
        builder.addChar('\ue55f');
        builder.addChar('\uea44');
        builder.addChar('\ue3a1');
        return builder.buildRanges();
    }

    private static byte[] loadFont(String name) {
        byte[] byArray;
        block9: {
            Optional resource = class_310.method_1551().method_1478().method_14486(Flashback.createResourceLocation(name));
            if (resource.isEmpty()) {
                throw new MissingResourceException("Missing font: " + name, "Font", "");
            }
            InputStream is = ((class_3298)resource.get()).method_14482();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public static ImGuiIO getIO() {
        if (!initialized) {
            ReplayUI.init();
        }
        return imGuiIO;
    }

    public static class_243 getMouseForwardsVector() {
        return ReplayUI.getMouseForwardsVector(ReplayUI.getIO().getMousePosX(), ReplayUI.getIO().getMousePosY());
    }

    public static class_243 getMouseForwardsVector(float mouseX, float mouseY) {
        if (!ReplayUI.isActive() || !isFrameHovered && !ReplayUI.isMovingCamera() || lastProjectionMatrix == null || lastViewQuaternion == null) {
            return null;
        }
        return ReplayUI.getForwardsVector(mouseX, mouseY);
    }

    public static class_241 getMouseViewportFraction() {
        float x = (ReplayUI.getIO().getMousePosX() - ImGui.getMainViewport().getPosX() - (float)frameX) / (float)frameWidth;
        float y = (ReplayUI.getIO().getMousePosY() - ImGui.getMainViewport().getPosY() - (float)frameY) / (float)frameHeight;
        return new class_241(x, y);
    }

    public static class_241 getMouseViewportFraction(float mouseX, float mouseY) {
        float x = (mouseX - ImGui.getMainViewport().getPosX() - (float)frameX) / (float)frameWidth;
        float y = (mouseY - ImGui.getMainViewport().getPosY() - (float)frameY) / (float)frameHeight;
        return new class_241(x, y);
    }

    public static class_243 getForwardsVector(float mouseX, float mouseY) {
        float x = (mouseX - ImGui.getMainViewport().getPosX() - (float)frameX) / (float)frameWidth * 2.0f - 1.0f;
        float y = (mouseY - ImGui.getMainViewport().getPosY() - (float)frameY) / (float)frameHeight * 2.0f - 1.0f;
        return ReplayUI.getForwardsVectorRaw(x, y);
    }

    public static class_243 getForwardsVectorRaw(float x, float y) {
        if (!ReplayUI.isMovingCamera() && (x < -1.0f || x > 1.0f || y < -1.0f || y > 1.0f)) {
            return null;
        }
        Matrix4f matrix = new Matrix4f((Matrix4fc)lastProjectionMatrix);
        matrix.invert();
        Vector4f forwards = new Vector4f(x, y, 0.0f, 1.0f);
        forwards.mul((Matrix4fc)matrix);
        return new class_243((double)forwards.x(), (double)(-forwards.y()), (double)forwards.z()).method_1029();
    }

    @Nullable
    public static class_243 getMouseLookVectorFromForwards(class_243 forwards) {
        if (forwards == null) {
            return null;
        }
        Vector3f view = forwards.method_46409();
        view.rotate((Quaternionfc)lastViewQuaternion);
        return new class_243((double)view.x(), (double)view.y(), (double)view.z()).method_1029();
    }

    @Nullable
    public static class_243 getMouseLookVector(float mouseX, float mouseY) {
        return ReplayUI.getMouseLookVectorFromForwards(ReplayUI.getMouseForwardsVector(mouseX, mouseY));
    }

    @Nullable
    public static class_243 getMouseLookVector() {
        return ReplayUI.getMouseLookVectorFromForwards(ReplayUI.getMouseForwardsVector());
    }

    public static boolean isEntitySelected(UUID uuid) {
        return ReplayUI.isActive() && uuid.equals(selectedEntity);
    }

    public static UUID getSelectedEntity() {
        return selectedEntity;
    }

    private static void setSelectedEntity(UUID uuid) {
        selectedEntity = uuid;
    }

    public static boolean isMovingCamera() {
        return imguiGlfw.isGrabbed() && imguiGlfw.getMouseHandledBy() == CustomImGuiImplGlfw.MouseHandledBy.GAME;
    }

    public static void setInfoOverlay(String text) {
        infoOverlayText = text;
        infoOverlayEndMillis = System.currentTimeMillis() + 5000L;
    }

    public static synchronized void setInfoOverlayShort(String text) {
        infoOverlayText = text;
        infoOverlayEndMillis = System.currentTimeMillis() + 1000L;
    }

    public static void setupMainViewport() {
        class_1041 window = class_310.method_1551().method_22683();
        int frameBottom = window.field_5197 - (frameY + frameHeight);
        GlStateManager._viewport((int)(frameX * window.method_4489() / window.method_4480()), (int)(frameBottom * window.method_4506() / window.method_4507()), (int)Math.max(1, frameWidth * window.method_4489() / window.method_4480()), (int)Math.max(1, frameHeight * window.method_4506() / window.method_4507()));
    }

    public static float getUiScale() {
        return globalScale * contentScale;
    }

    public static int scaleUi(int v) {
        return (int)((float)v * ReplayUI.getUiScale());
    }

    public static double getNewMouseX(double x) {
        return x - (double)frameX;
    }

    public static double getNewMouseY(double y) {
        return y - (double)frameY;
    }

    public static int getNewGameWidth(float scale) {
        return Math.max(1, Math.round((float)frameWidth * scale));
    }

    public static int getNewGameHeight(float scale) {
        return Math.max(1, Math.round((float)frameHeight * scale));
    }

    private static boolean isActiveInternal() {
        if (!Flashback.isInReplay()) {
            return false;
        }
        if (Flashback.EXPORT_JOB != null) {
            return false;
        }
        if (class_310.method_1551().field_1690.field_1842) {
            return false;
        }
        class_636 gameMode = class_310.method_1551().field_1761;
        if (gameMode == null) {
            return false;
        }
        if (gameMode.method_2920() != class_1934.field_9219) {
            return false;
        }
        if (class_310.method_1551().field_1687 == null) {
            return false;
        }
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        return class_310.method_1551().method_18506() == null;
    }

    public static void deferredCloseTextureId(int textureId) {
        deferredCloseLock.lock();
        try {
            deferredCloseTextureIds.add(textureId);
        }
        finally {
            deferredCloseLock.unlock();
        }
    }

    public static void deferredClose(AutoCloseable autoCloseable) {
        deferredCloseLock.lock();
        try {
            deferredClose.add(autoCloseable);
        }
        finally {
            deferredCloseLock.unlock();
        }
    }

    public static boolean isActive() {
        return activeLastFrame;
    }

    public static boolean shouldModifyViewport() {
        EditorState editorState = EditorStateManager.getCurrent();
        return ReplayUI.isActive() && editorState != null && editorState.replayVisuals.sizing != Sizing.UNDERLAY;
    }

    private static void transitionActiveState(boolean active) {
        if (activeLastFrame == active) {
            return;
        }
        activeLastFrame = active;
        class_1041 window = class_310.method_1551().method_22683();
        if (window.method_4489() > 0 && window.method_4489() <= 16384 && window.method_4506() > 0 && window.method_4506() <= 16384) {
            class_310.method_1551().method_15993();
        }
        imguiGlfw.ungrab();
        if (!activeLastFrame) {
            if (class_310.method_1551().field_1761 != null) {
                if (class_310.method_1551().field_1755 == null) {
                    class_310.method_1551().field_1729.method_1610();
                    class_310.method_1551().field_1729.method_1612();
                } else {
                    class_310.method_1551().field_1729.method_1612();
                    class_310.method_1551().field_1729.method_1610();
                }
                class_310.method_1551().field_1729.method_1599();
            }
        } else {
            long handle = ImGui.getMainViewport().getPlatformHandle();
            if (GLFW.glfwGetInputMode((long)handle, (int)208897) != 212993) {
                GLFW.glfwSetInputMode((long)handle, (int)208897, (int)212993);
                GLFW.glfwSetCursorPos((long)handle, (double)(ImGui.getMainViewport().getSizeX() / 2.0f), (double)(ImGui.getMainViewport().getSizeY() / 2.0f));
            }
        }
        imguiGlfw.setViewportWindowsHidden(!activeLastFrame);
    }

    public static void drawOverlay() {
        long oldImGuiContext = ImGui.getCurrentContext().ptr;
        ImGui.setCurrentContext(imGuiContext);
        try {
            ReplayUI.drawOverlayInternal();
        }
        catch (Throwable throwable) {
            ImGuiContext currentContext = ImGui.getCurrentContext();
            currentContext.ptr = oldImGuiContext;
            ImGui.setCurrentContext(currentContext);
            throw throwable;
        }
        ImGuiContext currentContext = ImGui.getCurrentContext();
        currentContext.ptr = oldImGuiContext;
        ImGui.setCurrentContext(currentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawOverlayInternal() {
        int oldFrameX = frameX;
        int oldFrameY = frameY;
        int oldFrameWidth = frameWidth;
        int oldFrameHeight = frameHeight;
        if (!initialized) {
            throw new IllegalStateException("Tried to use EditorUI while it was not initialized");
        }
        deferredCloseLock.lock();
        try {
            IntListIterator intListIterator = deferredCloseTextureIds.iterator();
            while (intListIterator.hasNext()) {
                int id = (Integer)intListIterator.next();
                TextureUtil.releaseTextureId((int)id);
            }
            deferredCloseTextureIds.clear();
            for (AutoCloseable closeable : deferredClose) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
            }
            deferredClose.clear();
        }
        finally {
            deferredCloseLock.unlock();
        }
        if (class_310.method_1551().field_1755 instanceof class_435 || class_310.method_1551().field_1755 instanceof class_434) {
            return;
        }
        if (!ReplayUI.isActiveInternal()) {
            ReplayUI.transitionActiveState(false);
            imguiGlfw.updateReleaseAllKeys(true);
            focusMainWindowCounter = 5;
            return;
        }
        imguiGlfw.updateReleaseAllKeys(false);
        if (!ImGui.isAnyMouseDown()) {
            float newContentScale;
            if ((double)(newGlobalScale = (float)((int)(newGlobalScale * 16.0f)) / 16.0f) < 0.25) {
                newGlobalScale = 0.25f;
            }
            if (newGlobalScale > 4.0f) {
                newGlobalScale = 4.0f;
            }
            if ((double)(newContentScale = (float)((int)(ReplayUI.imguiGlfw.contentScale * 16.0f)) / 16.0f) < 0.125) {
                newContentScale = 0.125f;
            }
            if (newContentScale > 8.0f) {
                newContentScale = 8.0f;
            }
            if (globalScale != newGlobalScale || contentScale != newContentScale) {
                int oldFontSize = (int)(16.0f * ReplayUI.getUiScale());
                globalScale = newGlobalScale;
                contentScale = newContentScale;
                if (oldFontSize != (int)(16.0f * ReplayUI.getUiScale())) {
                    ReplayUI.initFonts(languageCode);
                }
            }
        }
        imguiGlfw.newFrame();
        imguiGl3.newFrame();
        ImGui.newFrame();
        hasAnyPopupOpen = ImGui.isPopupOpen("", 3072);
        boolean bl = navClose = hasAnyPopupOpen && ImGui.isKeyPressed(526);
        if (wasNavClose != navClose) {
            wasNavClose = navClose;
        } else if (wasNavClose) {
            navClose = false;
        }
        if (hasAnyPopupOpen) {
            ReplayUI.getIO().addConfigFlags(1);
        } else {
            ReplayUI.getIO().removeConfigFlags(1);
        }
        MainMenuBar.render();
        if (!ReplayUI.isActiveInternal()) {
            ImGui.render();
            ImGuiHelper.endFrame();
            ReplayUI.transitionActiveState(false);
            imguiGlfw.updateReleaseAllKeys(true);
            focusMainWindowCounter = 5;
            return;
        }
        ImGui.setNextWindowBgAlpha(0.0f);
        int mainDock = ImGui.dockSpaceOverViewport(0, ImGui.getMainViewport(), 4);
        imgui.moulberry90.internal.ImGui.dockBuilderGetCentralNode(mainDock).addLocalFlags(4096);
        isFrameFocused = false;
        isFrameHovered = false;
        ImGui.setNextWindowDockID(mainDock);
        ImGuiHelper.pushStyleVar(2, 0.0f, 0.0f);
        if (ImGui.begin("Main", 65966)) {
            Sizing sizing;
            if (focusMainWindowCounter > 0) {
                --focusMainWindowCounter;
                ImGui.setWindowFocus();
            }
            ImGuiHelper.popStyleVar();
            float minX = ImGui.getWindowContentRegionMinX();
            float maxX = ImGui.getWindowContentRegionMaxX();
            float minY = ImGui.getWindowContentRegionMinY();
            float maxY = ImGui.getWindowContentRegionMaxY();
            if (ReplayUI.getIO().hasConfigFlags(1024)) {
                frameX = (int)(ImGui.getWindowPosX() - ImGui.getWindowViewport().getPosX() + minX);
                frameY = (int)(ImGui.getWindowPosY() - ImGui.getWindowViewport().getPosY() + minY);
            } else {
                frameX = (int)(ImGui.getWindowPosX() + minX);
                frameY = (int)(ImGui.getWindowPosY() + minY);
            }
            frameWidth = (int)Math.max(1.0f, maxX - minX);
            frameHeight = (int)Math.max(1.0f, maxY - minY);
            viewportSizeX = (int)ImGui.getMainViewport().getSizeX();
            viewportSizeY = (int)ImGui.getMainViewport().getSizeY();
            EditorState editorState = EditorStateManager.getCurrent();
            Sizing sizing2 = sizing = editorState == null ? Sizing.KEEP_ASPECT_RATIO : editorState.replayVisuals.sizing;
            if (sizing == Sizing.KEEP_ASPECT_RATIO || sizing == Sizing.CHANGE_ASPECT_RATIO) {
                float currentAspectRatio = (float)frameWidth / (float)frameHeight;
                float aspectRatio = sizing == Sizing.KEEP_ASPECT_RATIO ? ImGui.getMainViewport().getSizeX() / ImGui.getMainViewport().getSizeY() : editorState.replayVisuals.changeAspectRatio.aspectRatio();
                if (currentAspectRatio < aspectRatio) {
                    int newHeight = (int)((float)frameWidth / aspectRatio);
                    frameY += (frameHeight - newHeight) / 2;
                    frameHeight = newHeight;
                } else if (currentAspectRatio > aspectRatio) {
                    int newWidth = (int)((float)frameHeight * aspectRatio);
                    frameX += (frameWidth - newWidth) / 2;
                    frameWidth = newWidth;
                }
            }
            if (ImGui.isWindowFocused()) {
                ImGui.getWindowDrawList().addRect(frameX + 1, frameY + 1, (float)(frameX + frameWidth - 1), (float)(frameY + frameHeight - 1), -4040669);
                isFrameFocused = true;
            }
            String showText = null;
            int showTextBorderColour = -1;
            if (infoOverlayText != null) {
                long currentMillis = System.currentTimeMillis();
                if (currentMillis < infoOverlayEndMillis - 30000L || currentMillis > infoOverlayEndMillis) {
                    infoOverlayText = null;
                    infoOverlayEndMillis = 0L;
                } else {
                    showText = infoOverlayText;
                    showTextBorderColour = -16711681;
                }
            }
            if (showText != null) {
                ImGui.setNextWindowPos((float)frameX + (float)frameWidth * 0.5f, (float)frameY + (float)frameHeight * 0.75f, 1, 0.5f, 0.5f);
                ImGui.setNextWindowSizeConstraints(0.0f, 0.0f, 550.0f, (float)frameHeight * 0.45f);
                ImGuiHelper.pushStyleVar(4, 2.0f);
                ImGuiHelper.pushStyleColor(5, showTextBorderColour);
                if (ImGui.begin("##InfoOverlay", 528739)) {
                    ImGui.textUnformatted(showText);
                }
                ImGui.end();
                ImGuiHelper.popStyleColor();
                ImGuiHelper.popStyleVar();
            }
            if (sizing == Sizing.UNDERLAY) {
                frameX = 0;
                frameY = 0;
                frameWidth = class_310.method_1551().method_22683().method_4480();
                frameHeight = class_310.method_1551().method_22683().method_4507();
            }
            if (class_310.method_1551().field_1755 == null && class_310.method_1551().method_18506() == null) {
                if (editorState != null && editorState.replayVisuals.ruleOfThirdsGuide) {
                    ImDrawList drawList = ImGui.getBackgroundDrawList();
                    drawList.removeFlags(1);
                    drawList.addLine(frameX + frameWidth / 3, frameY, frameX + frameWidth / 3, frameY + frameHeight, -1426063361, 2.0f);
                    drawList.addLine(frameX + frameWidth * 2 / 3, frameY, frameX + frameWidth * 2 / 3, frameY + frameHeight, -1426063361, 2.0f);
                    drawList.addLine(frameX, frameY + frameHeight / 3, frameX + frameWidth, frameY + frameHeight / 3, -1426063361, 2.0f);
                    drawList.addLine(frameX, frameY + frameHeight * 2 / 3, frameX + frameWidth, frameY + frameHeight * 2 / 3, -1426063361, 2.0f);
                    drawList.addFlags(1);
                }
                if (editorState != null && editorState.replayVisuals.centerGuide) {
                    ImDrawList drawList = ImGui.getBackgroundDrawList();
                    drawList.removeFlags(1);
                    drawList.addLine(frameX + frameWidth / 2, frameY, frameX + frameWidth / 2, frameY + frameHeight, -1426063361, 2.0f);
                    drawList.addLine(frameX, frameY + frameHeight / 2, frameX + frameWidth, frameY + frameHeight / 2, -1426063361, 2.0f);
                    drawList.addFlags(1);
                }
            }
            if (displayingTip == -1) {
                FlashbackConfigV1 config = Flashback.getConfig();
                if (!config.internal.showTipOfTheDay) {
                    displayingTip = 0;
                } else {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime >= config.internal.nextTipOfTheDay - TimeUnit.DAYS.toMillis(2L) && currentTime <= config.internal.nextTipOfTheDay) {
                        displayingTip = 0;
                    } else {
                        displayingTip = Integer.numberOfTrailingZeros(~config.internal.viewedTipsOfTheDay) + 1;
                        config.internal.viewedTipsOfTheDay |= 1 << displayingTip - 1;
                        config.internal.nextTipOfTheDay = currentTime + TimeUnit.DAYS.toMillis(1L);
                        config.delayedSaveToDefaultFolder();
                    }
                }
            } else if (displayingTip > 0) {
                int tip = displayingTip - 1;
                if (tip >= DailyTips.TIPS.length) {
                    displayingTip = 0;
                } else {
                    ImGuiViewport viewport = ImGui.getMainViewport();
                    ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 8, 0.5f, 0.5f);
                    if (ImGui.begin(class_1074.method_4662((String)"flashback.tip_of_the_day", (Object[])new Object[0]), 320)) {
                        boolean canShowNext;
                        boolean canShowPrev;
                        float oldPositionY = ImGui.getCursorPosY();
                        ImGui.pushTextWrapPos(ReplayUI.scaleUi(375));
                        ImGui.textUnformatted(DailyTips.TIPS[tip]);
                        ImGui.popTextWrapPos();
                        float verticalSize = ImGui.getCursorPosY() - oldPositionY;
                        int minimumVerticalSize = ReplayUI.scaleUi(100);
                        if (verticalSize < (float)minimumVerticalSize) {
                            ImGui.setCursorPosY(ImGui.getCursorPosY() + (float)minimumVerticalSize - verticalSize);
                        }
                        if (ImGui.checkbox(class_1074.method_4662((String)"flashback.replayui.dont_show_tips", (Object[])new Object[0]), dontShowTipsOnStartupCheckbox)) {
                            dontShowTipsOnStartupCheckbox = !dontShowTipsOnStartupCheckbox;
                        }
                        ImGui.sameLine();
                        ImGui.dummy(ReplayUI.scaleUi(20), 0.0f);
                        ImGui.sameLine();
                        if (ImGui.button(class_1074.method_4662((String)"flashback.close", (Object[])new Object[0]))) {
                            if (dontShowTipsOnStartupCheckbox) {
                                FlashbackConfigV1 config = Flashback.getConfig();
                                config.internal.showTipOfTheDay = false;
                                config.delayedSaveToDefaultFolder();
                            }
                            displayingTip = 0;
                        }
                        ImGui.sameLine();
                        boolean bl2 = canShowPrev = displayingTip > 1;
                        if (!canShowPrev) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(class_1074.method_4662((String)"gui.back", (Object[])new Object[0])) && canShowPrev) {
                            FlashbackConfigV1 config = Flashback.getConfig();
                            config.internal.viewedTipsOfTheDay |= 1 << --displayingTip - 1;
                            config.delayedSaveToDefaultFolder();
                        }
                        if (!canShowPrev) {
                            ImGui.endDisabled();
                        }
                        ImGui.sameLine();
                        boolean bl3 = canShowNext = displayingTip < DailyTips.TIPS.length;
                        if (!canShowNext) {
                            ImGui.beginDisabled();
                        }
                        if (ImGui.button(class_1074.method_4662((String)"flashback.next", (Object[])new Object[0])) && canShowNext) {
                            FlashbackConfigV1 config = Flashback.getConfig();
                            config.internal.viewedTipsOfTheDay |= 1 << ++displayingTip - 1;
                            config.delayedSaveToDefaultFolder();
                        }
                        if (!canShowNext) {
                            ImGui.endDisabled();
                        }
                    }
                    ImGui.end();
                }
            }
            if (selectedEntity != null) {
                class_1297 entity = (class_1297)class_310.method_1551().field_1687.method_31592().method_31808(selectedEntity);
                if (entity == null || editorState == null) {
                    ReplayUI.setSelectedEntity(null);
                } else if (entity instanceof class_1657 && !editorState.replayVisuals.renderPlayers) {
                    ReplayUI.setSelectedEntity(null);
                } else if (!(entity instanceof class_1657) && !editorState.replayVisuals.renderEntities) {
                    ReplayUI.setSelectedEntity(null);
                } else {
                    if (openSelectedEntityPopup) {
                        ImGui.openPopup("###EntityPopup");
                        SelectedEntityPopup.open(entity, editorState);
                    }
                    if (ImGuiHelper.beginPopup("###EntityPopup")) {
                        SelectedEntityPopup.render(entity, editorState);
                        ImGui.endPopup();
                    }
                    if (!ImGui.isPopupOpen("###EntityPopup")) {
                        ReplayUI.setSelectedEntity(null);
                    }
                }
            }
            openSelectedEntityPopup = false;
            if (ImGui.isWindowHovered() && ReplayUI.getIO().getMousePosY() > ImGui.getWindowPosY()) {
                isFrameHovered = true;
                if (class_310.method_1551().field_1755 != null) {
                    ImGui.setNextFrameWantCaptureMouse(false);
                } else {
                    int wheelY;
                    class_746 player;
                    boolean isMovingCamera = ReplayUI.isMovingCamera();
                    if ((isFrameFocused || isMovingCamera) && (player = class_310.method_1551().field_1724) != null && (wheelY = (int)Math.signum(ReplayUI.getIO().getMouseWheel())) != 0) {
                        float defaultFlyingSpeed = 0.05f;
                        float flyingSpeed = class_3532.method_15363((float)(player.method_31549().method_7252() + (float)wheelY * 0.05f / 10.0f), (float)0.005f, (float)0.5f);
                        ReplayUI.setInfoOverlay(class_1074.method_4662((String)"flashback.flying_speed", (Object[])new Object[]{Float.valueOf(flyingSpeed / 0.05f)}));
                        player.method_31549().method_7248(flyingSpeed);
                    }
                    if (!isMovingCamera && ReplayUI.getIO().getWantCaptureMouse() && !popupOpenLastFrame && !ImGui.isPopupOpen("", 3072)) {
                        ReplayUI.handleBasicInputs();
                    }
                }
            }
        } else {
            ImGuiHelper.popStyleVar();
        }
        ImGui.end();
        VisualsWindow.render();
        TimelineWindow.render();
        StartExportWindow.render();
        ExportScreenshotWindow.render();
        PreferencesWindow.render();
        ExportQueueWindow.render();
        WindowType.renderAll();
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null) {
            if (replayServer.failedToLoadRegistryDataWarning && !shownRegistryErrorWarning) {
                ImGui.openPopup("###RegistryWarning");
                if (ImGuiHelper.beginPopupModal(class_1074.method_4662((String)"flashback.registry_warning", (Object[])new Object[0]) + "###RegistryWarning", 64)) {
                    ImGui.pushTextWrapPos(ReplayUI.scaleUi(375));
                    ImGui.textWrapped(class_1074.method_4662((String)"flashback.registry_warning_description", (Object[])new Object[0]));
                    ImGui.popTextWrapPos();
                    if (ImGui.button(class_1074.method_4662((String)"gui.ok", (Object[])new Object[0]))) {
                        ImGui.closeCurrentPopup();
                        shownRegistryErrorWarning = true;
                    }
                    ImGui.endPopup();
                }
            } else if (replayServer.failedToSpawnPlayerWarning && !shownPlayerSpawnErrorWarning) {
                ImGui.openPopup("###PlayerSpawnWarning");
                if (ImGuiHelper.beginPopupModal(class_1074.method_4662((String)"flashback.player_spawn_warning", (Object[])new Object[0]) + "###PlayerSpawnWarning", 64)) {
                    ImGui.pushTextWrapPos(ReplayUI.scaleUi(375));
                    ImGui.textWrapped(class_1074.method_4662((String)"flashback.player_spawn_warning_description", (Object[])new Object[0]));
                    ImGui.popTextWrapPos();
                    if (ImGui.button(class_1074.method_4662((String)"gui.ok", (Object[])new Object[0]))) {
                        ImGui.closeCurrentPopup();
                        shownPlayerSpawnErrorWarning = true;
                    }
                    ImGui.endPopup();
                }
            }
        }
        ExportDoneWindow.render();
        popupOpenLastFrame = ImGui.isPopupOpen("", 3072);
        ImGui.render();
        ImGuiHelper.endFrame();
        long ctx = GLFW.glfwGetCurrentContext();
        ImGui.updatePlatformWindows();
        ImGui.renderPlatformWindowsDefault();
        GLFW.glfwMakeContextCurrent((long)ctx);
        ImDrawData drawData = ImGui.getDrawData();
        if (drawData != null) {
            imguiGl3.renderDrawData(drawData);
        }
        if (frameX != oldFrameX || frameY != oldFrameY || frameWidth != oldFrameWidth || frameHeight != oldFrameHeight) {
            class_310.method_1551().method_15993();
        }
        ReplayUI.transitionActiveState(true);
    }

    public static boolean isMainFrameActive() {
        return isFrameFocused;
    }

    private static void handleBasicInputs() {
        int key;
        if (ImGui.isMouseClicked(1)) {
            class_239 result = ReplayUI.getLookTarget();
            if (result instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)result;
                if (class_310.method_1551().field_1724 == class_310.method_1551().field_1719) {
                    class_310.method_1551().field_1724.method_18799(class_243.field_1353);
                }
                ReplayUI.setSelectedEntity(entityHitResult.method_17782().method_5667());
                openSelectedEntityPopup = true;
            }
            return;
        }
        if (ImGui.isMouseClicked(0) && (key = -1) != 0) {
            imguiGlfw.setGrabbed(true, key, true, (float)frameX + (float)frameWidth / 2.0f, (float)frameY + (float)frameHeight / 2.0f);
        }
    }

    @Nullable
    private static class_239 getLookTarget() {
        class_3959 clipContext;
        class_243 look = ReplayUI.getMouseLookVector();
        if (look == null) {
            return null;
        }
        class_1297 cameraEntity = class_310.method_1551().field_1719;
        if (cameraEntity == null) {
            return null;
        }
        float distance = 64.0f;
        class_243 from = cameraEntity.method_33571();
        class_243 to = from.method_1019(look.method_1021((double)distance));
        class_3965 blockResult = null;
        class_3966 entityResult = null;
        EditorState editorState = EditorStateManager.getCurrent();
        if ((editorState == null || editorState.replayVisuals.renderBlocks) && (blockResult = class_310.method_1551().field_1687.method_17742(clipContext = new class_3959(from, to, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, class_3726.method_16194()))).method_17783() != class_239.class_240.field_1333) {
            distance = (float)blockResult.method_17784().method_1022(from);
        }
        if (editorState == null || editorState.replayVisuals.renderEntities || editorState.replayVisuals.renderPlayers) {
            Predicate<class_1297> predicate;
            class_238 boundingBox = new class_238(from.method_1023(0.5, 0.5, 0.5), from.method_1031(0.5, 0.5, 0.5));
            boundingBox = boundingBox.method_18804(look.method_1021((double)distance));
            if (editorState.replayVisuals.renderEntities && editorState.replayVisuals.renderPlayers) {
                predicate = entity -> true;
            } else if (editorState.replayVisuals.renderPlayers) {
                predicate = entity -> entity instanceof class_1657;
            } else if (editorState.replayVisuals.renderEntities) {
                predicate = entity -> !(entity instanceof class_1657);
            } else {
                throw new IllegalStateException();
            }
            entityResult = class_1675.method_18075((class_1297)cameraEntity, (class_243)from, (class_243)from.method_1019(look.method_1021((double)distance)), (class_238)boundingBox, predicate, (double)(distance * distance));
        }
        if (entityResult != null && entityResult.method_17784().method_1022(from) < (double)distance) {
            return entityResult;
        }
        if (blockResult != null && blockResult.method_17783() != class_239.class_240.field_1333) {
            return blockResult;
        }
        return null;
    }

    public static boolean consumeNavClose() {
        boolean navClose = ReplayUI.navClose;
        ReplayUI.navClose = false;
        return navClose;
    }

    public static boolean isMoveQuickDown() {
        return ImGui.isKeyDown(class_310.method_1551().field_1690.field_1867.field_1655.method_1444());
    }

    public static boolean isCtrlOrCmdDown() {
        return class_310.field_1703 ? ReplayUI.getIO().getKeySuper() : ReplayUI.getIO().getKeyCtrl();
    }
}

