/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.editor.ui.windows;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.configuration.FlashbackConfigV1;
import com.moulberry.flashback.editor.ui.ImGuiHelper;
import com.moulberry.flashback.editor.ui.ReplayUI;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import imgui.moulberry90.ImGui;
import imgui.moulberry90.ImGuiListClipper;
import imgui.moulberry90.ImGuiViewport;
import imgui.moulberry90.callback.ImListClipperCallback;
import imgui.moulberry90.type.ImBoolean;
import imgui.moulberry90.type.ImString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class RenderFilterWindow {
    private static boolean wasDocked = false;
    private static ImString entitySearch = ImGuiHelper.createResizableImString("");
    private static String lastEntitySearch = null;
    private static List<class_1299<?>> searchedEntityTypes = new ArrayList();
    private static ImString particleSearch = ImGuiHelper.createResizableImString("");
    private static String lastParticleSearch = null;
    private static List<class_2960> searchedParticleTypes = new ArrayList<class_2960>();

    public static void render(ImBoolean open, boolean newlyOpened) {
        String title;
        if (newlyOpened) {
            ImGuiViewport viewport = ImGui.getMainViewport();
            ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 8, 0.5f, 0.5f);
        }
        ImGui.setNextWindowSizeConstraints(250.0f, 50.0f, 5000.0f, 5000.0f);
        int flags = 4096;
        if (!wasDocked) {
            flags |= 0x40;
        }
        if (ImGui.begin((title = class_1074.method_4662((String)"flashback.render_filter", (Object[])new Object[0])) + "###Render Filter", open, flags)) {
            wasDocked = ImGui.isWindowDocked();
            FlashbackConfigV1 config = Flashback.getConfig();
            if (!config.internal.signedRenderFilter) {
                String name = class_310.method_1551().method_53462().getName();
                ImGui.pushTextWrapPos(ReplayUI.scaleUi(300));
                ImGui.textWrapped(class_1074.method_4662((String)"flashback.render_filter_affirmation", (Object[])new Object[]{name}));
                if (ImGui.checkbox(class_1074.method_4662((String)"flashback.render_filter_sign", (Object[])new Object[]{name}), false)) {
                    config.internal.signedRenderFilter = true;
                    config.delayedSaveToDefaultFolder();
                }
                ImGui.popTextWrapPos();
                ImGui.end();
                return;
            }
            final EditorState editorState = EditorStateManager.getCurrent();
            if (editorState == null) {
                ImGui.end();
                return;
            }
            if (ImGui.beginTabBar("##Select")) {
                class_2960 resourceLocation;
                Object contains;
                String searchString;
                if (ImGui.beginTabItem(class_1074.method_4662((String)"flashback.entities", (Object[])new Object[0]))) {
                    ImGui.inputText(class_1074.method_4662((String)"flashback.search", (Object[])new Object[0]), entitySearch);
                    searchString = ImGuiHelper.getString(entitySearch).trim().toLowerCase(Locale.ROOT);
                    if (!searchString.equals(lastEntitySearch)) {
                        lastEntitySearch = searchString;
                        searchedEntityTypes = new ArrayList();
                        contains = new ArrayList();
                        for (class_1299 entityType : class_7923.field_41177) {
                            String name = class_1074.method_4662((String)entityType.method_5882(), (Object[])new Object[0]).trim().toLowerCase(Locale.ROOT);
                            if (name.startsWith(lastEntitySearch)) {
                                searchedEntityTypes.add(entityType);
                                continue;
                            }
                            if (!name.contains(lastEntitySearch)) continue;
                            contains.add(entityType);
                        }
                        searchedEntityTypes.addAll((Collection<class_1299<?>>)contains);
                    }
                    if (searchedEntityTypes.isEmpty()) {
                        ImGui.textUnformatted(class_1074.method_4662((String)"flashback.no_entities_found", (Object[])new Object[0]));
                    } else {
                        if (ImGui.beginChild("##Scroller", 0, 300)) {
                            ImGuiListClipper.forEach(searchedEntityTypes.size(), new ImListClipperCallback(){

                                @Override
                                public void accept(int i) {
                                    class_1299<?> entityType = searchedEntityTypes.get(i);
                                    class_2960 resourceLocation = class_7923.field_41177.method_10221(entityType);
                                    boolean filtered = editorState.filteredEntities.contains(resourceLocation.toString());
                                    String name = class_1074.method_4662((String)entityType.method_5882(), (Object[])new Object[0]);
                                    if (ImGui.checkbox(name + "###" + String.valueOf(resourceLocation), !filtered)) {
                                        if (filtered) {
                                            editorState.filteredEntities.remove(resourceLocation.toString());
                                        } else {
                                            editorState.filteredEntities.add(resourceLocation.toString());
                                        }
                                    }
                                }
                            });
                        }
                        ImGui.endChild();
                        if (ImGui.smallButton(class_1074.method_4662((String)"flashback.enable_all", (Object[])new Object[0]))) {
                            editorState.filteredEntities.clear();
                        }
                        ImGui.sameLine();
                        if (ImGui.smallButton(class_1074.method_4662((String)"flashback.disable_all", (Object[])new Object[0]))) {
                            for (Iterator entityType : class_7923.field_41177) {
                                resourceLocation = class_7923.field_41177.method_10221((Object)entityType);
                                editorState.filteredEntities.add(resourceLocation.toString());
                            }
                        }
                    }
                    ImGui.endTabItem();
                }
                if (ImGui.beginTabItem(class_1074.method_4662((String)"flashback.particles", (Object[])new Object[0]))) {
                    ImGui.inputText(class_1074.method_4662((String)"flashback.search", (Object[])new Object[0]), particleSearch);
                    searchString = ImGuiHelper.getString(particleSearch).trim().toLowerCase(Locale.ROOT);
                    if (!searchString.equals(lastParticleSearch)) {
                        lastParticleSearch = searchString;
                        searchedParticleTypes = new ArrayList<class_2960>();
                        contains = new ArrayList();
                        for (class_2396 particleType : class_7923.field_41180) {
                            class_2960 resourceLocation2 = class_7923.field_41180.method_10221((Object)particleType);
                            if (resourceLocation2 == null) continue;
                            String name = resourceLocation2.method_12836().equals("minecraft") ? resourceLocation2.method_12832().toLowerCase(Locale.ROOT) : resourceLocation2.toString().toLowerCase(Locale.ROOT);
                            if (name.startsWith(lastParticleSearch)) {
                                searchedParticleTypes.add(resourceLocation2);
                                continue;
                            }
                            if (!name.contains(lastParticleSearch)) continue;
                            contains.add(resourceLocation2);
                        }
                        searchedParticleTypes.addAll((Collection<class_2960>)contains);
                    }
                    if (searchedParticleTypes.isEmpty()) {
                        ImGui.textUnformatted(class_1074.method_4662((String)"flashback.no_particles_found", (Object[])new Object[0]));
                    } else {
                        if (ImGui.beginChild("##Scroller", 0, 300)) {
                            ImGuiListClipper.forEach(searchedParticleTypes.size(), new ImListClipperCallback(){

                                @Override
                                public void accept(int i) {
                                    class_2960 particleType = searchedParticleTypes.get(i);
                                    boolean filtered = editorState.filteredParticles.contains(particleType.toString());
                                    String name = particleType.method_12836().equals("minecraft") ? particleType.method_12832().toLowerCase(Locale.ROOT) : particleType.toString().toLowerCase(Locale.ROOT);
                                    if (ImGui.checkbox(name, !filtered)) {
                                        if (filtered) {
                                            editorState.filteredParticles.remove(particleType.toString());
                                        } else {
                                            editorState.filteredParticles.add(particleType.toString());
                                        }
                                    }
                                }
                            });
                        }
                        ImGui.endChild();
                        if (ImGui.smallButton(class_1074.method_4662((String)"flashback.enable_all", (Object[])new Object[0]))) {
                            editorState.filteredParticles.clear();
                        }
                        ImGui.sameLine();
                        if (ImGui.smallButton(class_1074.method_4662((String)"flashback.disable_all", (Object[])new Object[0]))) {
                            for (class_2396 particleType : class_7923.field_41180) {
                                resourceLocation = class_7923.field_41180.method_10221((Object)particleType);
                                if (resourceLocation == null) continue;
                                editorState.filteredParticles.add(resourceLocation.toString());
                            }
                        }
                    }
                    ImGui.pushTextWrapPos(ReplayUI.scaleUi(300));
                    ImGui.textWrapped(class_1074.method_4662((String)"flashback.particles_note", (Object[])new Object[0]));
                    ImGui.popTextWrapPos();
                    ImGui.endTabItem();
                }
                ImGui.endTabBar();
            }
        }
        ImGui.end();
    }
}

