/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.io;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.FlashbackGson;
import com.moulberry.flashback.action.Action;
import com.moulberry.flashback.action.ActionLevelChunkCached;
import com.moulberry.flashback.action.ActionRegistry;
import com.moulberry.flashback.record.FlashbackChunkMeta;
import com.moulberry.flashback.record.FlashbackMeta;
import com.moulberry.flashback.record.ReplayMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2672;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_9095;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ReplayCombiner {
    public static void combine(class_5455 registryAccess, String replayName, Path first, Path second, Path output) throws Exception {
        class_9139 gamePacketCodec = class_9095.field_48173.method_61107(class_9129.method_56350((class_5455)registryAccess)).comp_2236();
        try (FileSystem firstFileSystem = FileSystems.newFileSystem(first);
             FileSystem secondFileSystem = FileSystems.newFileSystem(second);){
            ArrayList<class_2672> levelChunkPackets = new ArrayList<class_2672>();
            Int2IntOpenHashMap levelChunkMappingsFirst = new Int2IntOpenHashMap();
            Int2IntOpenHashMap levelChunkMappingsSecond = new Int2IntOpenHashMap();
            ReplayCombiner.extractChunks(registryAccess, firstFileSystem, (class_9139<ByteBuf, class_2596<? super class_2602>>)gamePacketCodec, levelChunkPackets, (Int2IntMap)levelChunkMappingsFirst);
            ReplayCombiner.extractChunks(registryAccess, secondFileSystem, (class_9139<ByteBuf, class_2596<? super class_2602>>)gamePacketCodec, levelChunkPackets, (Int2IntMap)levelChunkMappingsSecond);
            Path metadataPath = firstFileSystem.getPath("/metadata.json", new String[0]);
            String metadataJson = Files.readString(metadataPath);
            FlashbackMeta firstMetadata = FlashbackMeta.fromJson((JsonObject)FlashbackGson.COMPRESSED.fromJson(metadataJson, JsonObject.class));
            if (firstMetadata == null) {
                throw new RuntimeException("Unable to load /metadata.json from first replay");
            }
            Path secondMetadataPath = secondFileSystem.getPath("/metadata.json", new String[0]);
            String secondMetadataJson = Files.readString(secondMetadataPath);
            FlashbackMeta secondMetadata = FlashbackMeta.fromJson((JsonObject)FlashbackGson.COMPRESSED.fromJson(secondMetadataJson, JsonObject.class));
            if (secondMetadata == null) {
                throw new RuntimeException("Unable to load /metadata.json from second replay");
            }
            if (firstMetadata.dataVersion != secondMetadata.dataVersion) {
                throw new RuntimeException("Replays were created on different versions of the game, unable to combine");
            }
            firstMetadata.replayIdentifier = UUID.randomUUID();
            firstMetadata.name = replayName;
            for (Map.Entry<Integer, ReplayMarker> entry : secondMetadata.replayMarkers.entrySet()) {
                firstMetadata.replayMarkers.put(entry.getKey() + firstMetadata.totalTicks, entry.getValue());
            }
            firstMetadata.totalTicks += secondMetadata.totalTicks;
            record ReplayChunk(Path path, Int2IntMap levelChunkMappings) {
            }
            HashMap<Object, ReplayChunk> newReplayChunks = new HashMap<Object, ReplayChunk>();
            for (String string : firstMetadata.chunks.keySet()) {
                newReplayChunks.put(string, new ReplayChunk(firstFileSystem.getPath("/" + string, new String[0]), (Int2IntMap)levelChunkMappingsFirst));
            }
            boolean bl = true;
            for (Map.Entry<String, FlashbackChunkMeta> entry : secondMetadata.chunks.entrySet()) {
                boolean bl2;
                String newName = "c" + firstMetadata.chunks.size() + ".flashback";
                if (bl2) {
                    bl2 = false;
                    entry.getValue().forcePlaySnapshot = true;
                }
                firstMetadata.chunks.put(newName, entry.getValue());
                newReplayChunks.put(newName, new ReplayChunk(secondFileSystem.getPath("/" + entry.getKey(), new String[0]), (Int2IntMap)levelChunkMappingsSecond));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(output.toFile());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ZipOutputStream zipOut = new ZipOutputStream(bufferedOutputStream);
            zipOut.setLevel(1);
            ZipEntry zipEntry = new ZipEntry("metadata.json");
            zipOut.putNextEntry(zipEntry);
            zipOut.write(FlashbackGson.COMPRESSED.toJson((JsonElement)firstMetadata.toJson()).getBytes(StandardCharsets.UTF_8));
            zipOut.closeEntry();
            int lastCacheIndex = -1;
            class_9129 chunkCacheOutput = null;
            for (int i = 0; i < levelChunkPackets.size(); ++i) {
                int cacheIndex = i / 10000;
                if (chunkCacheOutput == null) {
                    lastCacheIndex = cacheIndex;
                    chunkCacheOutput = new class_9129(Unpooled.buffer(), registryAccess);
                } else if (cacheIndex != lastCacheIndex) {
                    byte[] bytes = new byte[chunkCacheOutput.writerIndex()];
                    chunkCacheOutput.method_52952(0, bytes);
                    zipEntry = new ZipEntry("level_chunk_caches/" + lastCacheIndex);
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(bytes);
                    zipOut.closeEntry();
                    lastCacheIndex = cacheIndex;
                    chunkCacheOutput = new class_9129(Unpooled.buffer(), registryAccess);
                }
                int startWriterIndex = chunkCacheOutput.writerIndex();
                chunkCacheOutput.method_53002(-1);
                gamePacketCodec.encode((Object)chunkCacheOutput, (Object)((class_2596)levelChunkPackets.get(i)));
                int endWriterIndex = chunkCacheOutput.writerIndex();
                int size = endWriterIndex - startWriterIndex - 4;
                chunkCacheOutput.method_52990(startWriterIndex);
                chunkCacheOutput.method_53002(size);
                chunkCacheOutput.method_52990(endWriterIndex);
            }
            if (chunkCacheOutput != null) {
                byte[] bytes = new byte[chunkCacheOutput.writerIndex()];
                chunkCacheOutput.method_52952(0, bytes);
                zipEntry = new ZipEntry("level_chunk_caches/" + lastCacheIndex);
                zipOut.putNextEntry(zipEntry);
                zipOut.write(bytes);
                zipOut.closeEntry();
            }
            zipEntry = new ZipEntry("icon.png");
            zipOut.putNextEntry(zipEntry);
            Files.copy(firstFileSystem.getPath("/icon.png", new String[0]), zipOut);
            zipOut.closeEntry();
            for (Map.Entry entry : newReplayChunks.entrySet()) {
                zipEntry = new ZipEntry((String)entry.getKey());
                zipOut.putNextEntry(zipEntry);
                Path path = ((ReplayChunk)entry.getValue()).path();
                byte[] replayChunk = Files.readAllBytes(path);
                class_9129 inputBuf = new class_9129(Unpooled.wrappedBuffer((byte[])replayChunk), registryAccess);
                class_2540 outputBuf = new class_2540(Unpooled.buffer());
                int magic = inputBuf.readInt();
                if (magic != -679417724) {
                    throw new RuntimeException("Invalid magic");
                }
                outputBuf.method_53002(magic);
                int levelChunkCachedActionId = -1;
                int actions = inputBuf.method_10816();
                outputBuf.method_10804(actions);
                for (int i = 0; i < actions; ++i) {
                    class_2960 actionName = inputBuf.method_10810();
                    outputBuf.method_10812(actionName);
                    Action action = ActionRegistry.getAction(actionName);
                    if (!(action instanceof ActionLevelChunkCached)) continue;
                    levelChunkCachedActionId = i;
                }
                if (levelChunkCachedActionId == -1) {
                    Files.copy(((ReplayChunk)entry.getValue()).path, zipOut);
                } else {
                    int snapshotSize = inputBuf.readInt();
                    if (snapshotSize < 0) {
                        throw new RuntimeException("Invalid snapshot size: " + snapshotSize + " (0x" + Integer.toHexString(snapshotSize) + ")");
                    }
                    int snapshotInputEnd = inputBuf.readerIndex() + snapshotSize;
                    int snapshotOutputWriterIndex = outputBuf.writerIndex();
                    outputBuf.method_53002(-559038737);
                    int snapshotStartWriterIndex = outputBuf.writerIndex();
                    int snapshotEndWriterIndex = outputBuf.writerIndex();
                    while (inputBuf.readerIndex() < inputBuf.writerIndex()) {
                        boolean inSnapshot = inputBuf.readerIndex() < snapshotInputEnd;
                        int id = inputBuf.method_10816();
                        int size = inputBuf.readInt();
                        if (id == levelChunkCachedActionId) {
                            int cachedChunkId = inputBuf.method_10816();
                            if (!((ReplayChunk)entry.getValue()).levelChunkMappings.containsKey(cachedChunkId)) {
                                throw new RuntimeException("Missing cached chunk id " + cachedChunkId);
                            }
                            int newCachedChunkId = ((ReplayChunk)entry.getValue()).levelChunkMappings.get(cachedChunkId);
                            outputBuf.method_10804(id);
                            int sizeWriterIndex = outputBuf.writerIndex();
                            outputBuf.method_53002(0);
                            int cachedIdWriterIndex = outputBuf.writerIndex();
                            outputBuf.method_10804(newCachedChunkId);
                            int endWriterIndex = outputBuf.writerIndex();
                            outputBuf.method_52990(sizeWriterIndex);
                            outputBuf.method_53002(endWriterIndex - cachedIdWriterIndex);
                            outputBuf.method_52990(endWriterIndex);
                        } else {
                            outputBuf.method_10804(id);
                            outputBuf.method_53002(size);
                            outputBuf.method_52976((ByteBuf)inputBuf, size);
                        }
                        if (!inSnapshot) continue;
                        snapshotEndWriterIndex = outputBuf.writerIndex();
                    }
                    int endWriterIndex = outputBuf.writerIndex();
                    outputBuf.method_52990(snapshotOutputWriterIndex);
                    outputBuf.method_53002(snapshotEndWriterIndex - snapshotStartWriterIndex);
                    outputBuf.method_52990(endWriterIndex);
                    byte[] bytes = new byte[outputBuf.writerIndex()];
                    outputBuf.method_52952(0, bytes);
                    zipOut.write(bytes);
                }
                zipOut.closeEntry();
            }
            zipOut.close();
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
    }

    private static void extractChunks(class_5455 registryAccess, FileSystem fileSystem, class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec, List<class_2672> packets, Int2IntMap levelChunkMappings) throws IOException {
        Path levelChunkCachePath = fileSystem.getPath("/level_chunk_cache", new String[0]);
        if (Files.exists(levelChunkCachePath, new LinkOption[0])) {
            ReplayCombiner.loadLevelChunkCache(gamePacketCodec, registryAccess, levelChunkCachePath, 0, packets, levelChunkMappings);
        }
        int index = 0;
        while (Files.exists(levelChunkCachePath = fileSystem.getPath("/level_chunk_caches/" + index, new String[0]), new LinkOption[0])) {
            ReplayCombiner.loadLevelChunkCache(gamePacketCodec, registryAccess, levelChunkCachePath, index * 10000, packets, levelChunkMappings);
            ++index;
        }
    }

    private static void loadLevelChunkCache(class_9139<ByteBuf, class_2596<? super class_2602>> gamePacketCodec, class_5455 registryAccess, Path levelChunkCachePath, int chunkCacheIndex, List<class_2672> packets, Int2IntMap levelChunkMappings) throws IOException {
        try (InputStream is = Files.newInputStream(levelChunkCachePath, new OpenOption[0]);){
            byte[] sizeBuffer;
            while ((sizeBuffer = is.readNBytes(4)).length >= 4) {
                int size = (sizeBuffer[0] & 0xFF) << 24 | (sizeBuffer[1] & 0xFF) << 16 | (sizeBuffer[2] & 0xFF) << 8 | sizeBuffer[3] & 0xFF;
                byte[] chunk = is.readNBytes(size);
                if (chunk.length < size) {
                    Flashback.LOGGER.error("Ran out of bytes while reading level_chunk_cache, needed {}, had {}", (Object)size, (Object)chunk.length);
                    break;
                }
                class_9129 registryFriendlyByteBuf = new class_9129(Unpooled.wrappedBuffer((byte[])chunk), registryAccess);
                try {
                    class_2596 packet = (class_2596)gamePacketCodec.decode((Object)registryFriendlyByteBuf);
                    if (!(packet instanceof class_2672)) {
                        throw new IllegalStateException("Level chunk cache contains wrong packet: " + String.valueOf(packet));
                    }
                    class_2672 levelChunkWithLightPacket = (class_2672)packet;
                    levelChunkMappings.put(chunkCacheIndex, packets.size());
                    packets.add(levelChunkWithLightPacket);
                }
                catch (Exception e) {
                    Flashback.LOGGER.error("Encountered error while reading level_chunk_cache", (Throwable)e);
                }
                ++chunkCacheIndex;
            }
        }
    }
}

